/* [wkrc2.c wk 1.6.91] Hilfsfunktionen 2 fr WKRC
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * $Header: /usr/src/master/libs/wkswn/wkrc2.c,v 1.2 1996/09/10 12:24:48 wk Exp $
 *
 * Symboltabelle Makros
 */

#include <wk/tailor.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <wk/lib.h>
#include <wk/string.h>

#include "wkrc.h"

/****** types ******/

typedef struct t_symtbl {   /* linked list */
	struct t_symtbl *next;
	char name[MAX_NAMELEN+1];
	ushort value;
    } symtbl_t;

/***** globals *****/
static symtbl_t  *symHead; /* ptr to head of list */
static symtbl_t  *symLast; /* ptr to last element */

/******* local protos ******/
static void Insert( const char *name, ushort value );
/******** functions *********/

/*
 * Die Funktion erwartet eine String in der Form:
 *  "Macroname [Number]"
 * und speichert dieses Macro in der Symboltabelle ab.
 * ist nummer nicht angegeben, so wird der Wert 0 angenommen
 * Returns: 0 = Okay
 *	    ERR_DUPMAC
 *	    ERR_INVMAC
 */

int StoreMacro( const char *string )
{
    char name[MAX_NAMELEN+1];
    long hl;
    ushort value;
    size_t len;
    int err;

    err = 0;
    mem2str( name, string, DIM(name) );
    len = strcspn( string, "\t " );
    if( len < strlen(name) )
        name[len] = '\0';
    if( isdigit(*name) || isspace( *name ) )
	err = ERR_INVMAC;
    else if( GetMacro(name, &value) != ERR_UDFMAC )
	err = ERR_DUPMAC;
    else {
	hl = strtol( string+len, NULL, 0 );
	if( hl < 0L && hl > 0x0ffff )
	    err = ERR_RANGE;
	else {
	    value = (ushort)hl;
	    Insert( name, value );
	}
    }
    return err;
}


/*
 * Funktion ermittel den Wert eines Macros
 * Der Wert wird in value zurckgegeben
 * Returns: 0 = Okay
 *	    ERR_UDFMAC = macro nicht definiert
 */

int GetMacro( const char *name, ushort *value )
{
    symtbl_t *p;

    for( p = symHead; p; p = p->next )
	if( !strcmp( p->name, name ) ) {
	    *value = p->value;
	    return 0;
	}
    return ERR_UDFMAC;
}




/*
 * Store a Macro in the Symboltable
 * name muss darf hchstens MAX_NAMELEN lang sein
 */

static void Insert( const char *name, ushort value )
{
    symtbl_t *p;

    if( !(p = malloc( sizeof(symtbl_t))) ) {
        fprintf(stderr,"out of memory in symboltable\n");
	exit(4);
    }

    p->next = NULL;
    strcpy( p->name, name);
    p->value = value;

    if( symHead )
	symLast->next = p;
    else
	symHead = p;
    symLast = p;
}




/*
 * Die Symboltabelle komplett lschen
 */

void DeleteAllMacros()
{
    symtbl_t *p, *help;

    p = symHead;
    while( p ) {
	help = p->next ;
	free( p ) ;
	p = help ;
    }
    symHead = symLast = NULL ;
}



#ifdef DEBUG
void PrintAllMacros()
{
    symtbl_t *p;

    puts("------- List of all macros --------");
    for( p = symHead; p; p = p->next )
        printf( "'%-31s' %u\n", p->name, p->value );
    puts("-----------------------------------");
}
#endif


/*************** main function for Module Test ***************/
#ifdef TEST


int main( int argc, char **argv )
{
    char buf[200];
    symtbl_t *p;
    int err ;

    if( argc != 1 ) {
        fprintf(stderr,"no parameters: getting input from stdin\n");
	exit(3);
    }

    while( gets(buf) ) {
        if( *buf == '.' ) {
	    for( p = symHead; p; p = p->next )
                printf( "'%-31s' %u\n", p->name, p->value );
	}
	else {
	    StripWSpaces(buf);
	    if( err = StoreMacro( buf ) )
                printf("Alread defined err = %d\n", err );
	}
	fflush(stdout);
    }

    return 0;
}

#endif /* TEST */

/**** end of file ****/
