/* [wkrc1.c wk 1.6.91] Hilfsfunktionen fr WKRC
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * $Header: /usr/src/master/libs/wkswn/wkrc1.c,v 1.2 1996/09/10 12:24:47 wk Exp $
 */

#include <wk/tailor.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <wk/lib.h>


#include "wkrc.h"

/******* constants *********/
#define BLANK_CHAR ' '  /* used to replace Comments */

/******* local protos ******/
/******** functions *********/


#ifdef DOCUMENTATION
@Summary FRead_C_Char	   Read an C Character
 #include "wkrc.h"

@Description
 Dies Funktion liest von einem Stream Zeichen, dabei werden
 die Zeichen bereits vorverarbeitet:
 - Kommentare im C-Stil werden bersprungen.
 Um die interen Statemachine zurckzusetzen ist der Parameter Helper
 vor dem ersten Aufruf auf 0 zu setzen.
@Return Value
 Character
@See Also
 CheckCommentState
@Notes
#endif



/*
 * Implementation details:
 * Implemeted as a final state machine:
 * state 0 = Init
 *	 1 = Comment Init erkannt
 *	 2 = in Comment
 *	 3 = Comment exit erkannt
 *	 4 = Inside a String
 *	 5 = Backslash within a string
 * int helper:
 *	Byte 0:
 *	   Bit 2-0 : state
 *	   Bit 3   : saved Char is EOF
 *	   Bit 4   : saved char is valid
 *	Byte 1 : Saved Char 1
 */


int RemoveComment( int c, int *helper )
{
    int state, nxtChar;

    state = *helper & 0x07;   /* 3 lower bits */
    nxtChar = c ;
    if( *helper )  /* not the first call , so bnxtChar is valid */
	c = *helper & 8 ? EOF : (*helper>>8) & 0x00ff ;
    else   /* first call */
	c = BLANK_CHAR;
    *helper = (nxtChar == EOF? 8 : (nxtChar << 8) & 0xff00) | 16 ;

    if( c == EOF )
	state = 6 ;

    switch( state ) {
      case 0:   if( c == '/' ) {
                    if( nxtChar == '*' ) {
			state++  ; /* this is a comment */
			c = BLANK_CHAR;     /* skip it */
		    }
		}
                else if( c == '\"' )
		     state = 4 ; /* remember start of string */
		break ;
      case 1:	state++;
		c = BLANK_CHAR; /* skip this character (this must be an *) */
		break;
      case 2:	if( !isspace( c ) ) {	/* white blanks may pass thru */
                    if( c == '*' )
			state++ ;   /* possible end of comment */
		    c = BLANK_CHAR;	 /* remove character */
		}
		break ;
      case 3:   if( c == '/' ) {
		    state = 0 ;
		    c = BLANK_CHAR;
		}
                else if( c == '*' ) {
                    if( nxtChar != '*' && nxtChar != '/' )
			state = 2 ;
		    c = BLANK_CHAR;
		}
		else {
		    state = 2 ;
		    if( !isspace( c ) )
			c = BLANK_CHAR;
		}
		break ;
      case 4:	/* we are inside a string */
                if( c == '\\' )
		    state++;
                else if( c == '\"' )
		    state = 0 ; /* end of string */
		break;
      case 5:	/* last char was a backslash */
		state = 4 ;
		break;
      case 6:	/* EOF */
		break;
    }

    *helper |= state & 7;
    return c ;
}



/*
 * Diese Funktion berprft den Stand der State machine von
 * RemoveComments(), Als Paramtere erwartet, sie die helper-Variable
 * von RemoveComments.
 * Returns: 0 = Normaler Text
 *	    1 = Innerhalb eines Kommentars
 *	    2 = Innerhalb eines Strings
 */

int CheckCommentState( int helper )
{
    int state ;

    state = helper & 0x07;   /* 3 lower bits */
    if( !state )
	return 0 ;  /* state machine is in init-State */
    else if( state < 4 )
	return 1 ;  /* in a Comment */
    else
	return 2 ;  /* in a string */
}



/*************** main function for Module Test ***************/
#ifdef TEST

int main( int argc, char **argv )
{
    char *fileName ;
    FILE *stream;
    int helper, c ;
    long lineCount;
    int newLine;

    if( argc != 2 ) {
        fprintf(stderr,"parameters: Filename");
	exit(3);
    }

    fileName = argv[1];
    printf("Reading file: `%s'\n", fileName);

    if( !(stream = fopen(fileName, "r") ) ) {
        fprintf(stderr,"Error opening file\n");
	exit(2);
    }

    helper = 0;
    lineCount = 0L;
    newLine = 1;
    while( (c = RemoveComment(c=getc(stream), &helper )) != EOF ) {
	if( newLine ) {
            printf("%05ld ", lineCount+1 );
	    newLine = 0;
	}

        if( c == '\n' ) {
	    lineCount++;
	    newLine++ ;
	}
	putchar( c );
	fflush(stdout);
    }

    fclose(stream);

    return 0;
}

#endif /* TEST */

/**** end of file ****/
