/* [wkrc.h wk 1.6.91] Defs for WKRC
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 *  This file is part of WkCUA.
 *
 *  WkCUA is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkCUA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /usr/src/master/libs/wkswn/wkrc.h,v 1.2 1996/09/10 12:24:47 wk Exp $
 */

#ifndef WKRC_H
#define WKRC_H 1
#ifndef HDR_WK_RCMGR
    #include <wk/rcmgr.h>
#endif


/****** constants *****/
#define ERR_UNKOWN  1
#define ERR_DUPMAC  2	 /* duplicated defined macro */
#define ERR_INVMAC  3	 /* invalid form of macro */
#define ERR_UDFMAC  4	 /* undefined macro */
#define ERR_RANGE   5	 /* value out of range */
#define ERR_FILENF  6	 /* File not found */
#define ERR_FATAL   7	 /* Fatal error    */
#define ERR_SYNTAX  8	 /* Syntax error   */
#define ERR_INVKWD  9	 /* Invalid keyword */
#define ERR_UKWKWD  10	 /* Unkown keyword */
#define ERR_DUPNAM  11	 /* duplicated name */
#define ERR_DUPTYP  12	 /* duplicated type */
#define ERR_INVTYP  13	 /* invalid type */
#define ERR_PRMEOF  14	 /* premature end of file */
#define ERR_R2BIG   15	 /* resource to big */
#define ERR_R2MANY  16	 /* resource to many entries */
#define ERR_VALUE   17	 /* value error */
#define ERR_INVSTR  18	 /* Invalid string */
#define ERR_INVCHR  19	 /* Invalid character */
#define ERR_UBNEST  20	 /* Unbalanced Nesting */
#define ERR_ALDEF   21	 /* Already defined */
#define ERR_INCMPL  22	 /* Incomplete Data */
#define ERR_2MBTNS  23	 /* 2 many Buttons */

#define MAX_LINELEN 512
#define MAX_NAMELEN 31


/***** protos *******/
    /*-- wkrc.c --*/
void StartTempFile( const char *name );
void WriteTempFile( const void *buffer, size_t size );
void PrintError( const char *string, const char *file, long line,  int err );
const char *GetErrorString( int err );
const char *ProcStrg( char *d, const char *s, size_t n, size_t *copied );
const char *ProcChar( int *value, const char *s );

    /*-- wkrc1.c --*/
int RemoveComment( int c, int *helper );
int CheckCommentState( int helper );

    /*-- wkrc2.c --*/
int StoreMacro( const char *string );
int GetMacro( const char *name, ushort *value );
void DeleteAllMacros(void);

    /*-- wkrc3.c --*/
int ReadIncludeFile( const char * );

    /*-- wkrc4.c --*/
int ProcNextResource( FILE *, long *, const char *, int * );

    /*-- wkrc_1.c --*/
int ProcRcStrBlk( const char *line, int mode );

    /*-- wkrc_2.c --*/
int ProcRcPlain( const char *line, int mode );

    /*-- wkrc_3.c --*/
int ProcRcPDMenu( const char *line, int mode );

    /*-- wkrc_4.c --*/
int ProcRcDlgWin( const char *line, int mode );


#ifdef DEBUG
void PrintAllMacros(void);
#endif


#endif	/* WKRC_H */
