/* [scrmod2.c wk 23.6.91] SPecial functions
 *	(c) Werner Koch (dd9jn) 1991
 * $Header: /usr/src/master/libs/wkswn/scrmod2.c,v 1.2 1996/09/10 12:24:47 wk Exp $
 */

#include <wk/tailor.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wk/lib.h>
#include <wk/scr.h>

/****** constants *********/
/******** typedefs ********/
/****** prototypes ********/
/******* globals **********/
/***** def. Function ******/
/******* Functions ********/

/*
 * Die Funktion zeichent einen scrollbalken
 * px, py gibt die anfangsposition des balken an, also die des
 * Pfeils. In flag sollte 0 sein. wl ist die anzhal der elemente
 * die im Window angezeigt werden, sl ist die lnge des scrollbalkens
 * inclusive der Pfeile
 * Returns : Position des Gliders ( absolute position )
 */

int ScrScrollBar(  int hd,  /* windowhandle */
		   int px,  /* Position des scrollbalkens */
		   int py,
		   unsigned flag, /* bit 0: horizontal bar */
		   long n,  /* Gesamtanzahl der Elemente */
		   long c,  /* index des aktuellen Elements */
		   int wl,  /* lnge des windows */
		   int sl,  /* lnge des scrollbalkens */
		   byte attr1, /* standard attribute */
		   byte attr2, /* inverses attribute */
		   int *gl   /* Return: Lnge des Gliders */
		)
{
    int g1, g2;     /* anfangs und endposition des gliders */
    int i;

    g1 = py;
    *gl = 0;
    if( sl >= 2 ) {    /* absolute Mindestgre */
        ScrWriteCell( hd, px, py,      '\x18', attr2 ); /* Pfeil hoch */
        ScrWriteCell( hd, px, py+sl-1, '\x19', attr2 ); /* Pfeil runter */
	if( sl > 2 ) {
	    g1 = ScrCalcGlider( n, c, wl, sl-2, gl );
	    g1 += py+1; /* wg. pfeil */
	    g2 = g1 + *gl -1;
	    for( i=py+1; i < py+sl-1; i++ )
                ScrWriteCell( hd, px, i , i<g1||i>g2? '\xb0':'\xdb', attr1);
	}
    }
    return g1;
}



/*
 * Die Gliderposition bestimmen:
 * Returns: erste Postion des Gliders
 */

int ScrCalcGlider(  long n,  /* Gesamtanzahl der Elemente */
		    long c,  /* index des aktuellen Elements */
		    int wl, /* lnge des windows */
		    int sl, /* lnge des scrollbalkens */
		    int *gl   /* Return: Lnge des Gliders */
		 )
{
    int gp; /* gliderposition */

    if( n > wl ) {
	*gl = ( wl * sl ) / n;
	gp = ( c * sl ) / n - *gl/2;
	if( gp < 0 )
	    gp = 0;
    }
    else {
	*gl = sl;
	gp = 0;
    }

    if( *gl < 1 )
	*gl = 1;
    return gp;
}

/*** bottom of file ***/
