/* [scrmod1.c wk 22.4.91] Screen dummy Functions and Utilities
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkCUA.
 *
 *  WkCUA is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkCUA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /usr/src/master/libs/wkswn/scrmod1.c,v 1.3 1997/01/07 14:47:12 wk Exp $
 *
 *  Redirected Functions
 */

#include <wk/tailor.h>
#define MODULE_NAME "ScrMod1"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>

#include <wk/lib.h>
#include "scr_sy.h"

/****** constants *********/
/******** typedefs ********/
/****** prototypes ********/
static const char *DummyScrDriver(void);

/******* globals **********/
static int redirectFlag = 0 ;	  /*set if Screen Functions activ*/

static const char *(*TheScrDriver)(void) = DummyScrDriver ;

/***** def. Function ******/
/******* Functions ********/


/* [internal to Screen System]
 * Dies Funktion wird mit vom Modul "ScrMod0" nach erfolgreicher
 * initialisierung aufgerufen um die umgeleitetet Funktionen auf
 * die richtigen Screen funktionen zu lenken
 * Mit Mode 0 oder 1 kann diese Umlenkung aus oder eingeschaltet werden.
 * Mode -1 gibt nur den Status zurck
 * Returns:
 */


int ScrChangeRedirector( int mode, const char *(*D0)(void) )
{
    int old ;

    old = redirectFlag ;
    if( !mode ) { /*Link out : default*/
	redirectFlag = 0 ;
	TheScrDriver = DummyScrDriver ;
    }
    else if( mode == 1) {
	redirectFlag = 1 ;
	TheScrDriver = D0 ;
    }
    return old ;
}



/*
 * Zhlen der Zeilen, Spalten und Seiten in einem String
 */

void ScrGetStringSize( int level, const char *p,
		       int *retColumns, int *retLines, int *retPages )
{
    int spalten , zeilen, i ;

    spalten=zeilen=1 ;
    for( i=0 ; *p ; p++ )
	if( *p == '\n' ) {
	    zeilen++ ;
	    if( i > spalten )
		spalten = i ;
	    i=0 ;
	}
	else
	    i++ ;
    if( i > spalten )
	spalten = i ;
    if( retLines )
	*retLines = zeilen;
    if( retColumns )
	*retColumns = spalten ;
    if( retPages )
	*retPages = 1;
}




/**********************************************
 *********** redirected functions  ************
 **********************************************/
const char *ScrDriver()
{
    return TheScrDriver() ;
}

/**********************************************
 **** functions used if screen not activ ******
 **********************************************/

static const char *DummyScrDriver()
{
    return NULL ;
}

/*********************** bottom of file ***********************************/

