/* [scr_sy.h wk 22.4.91] Internal Defs for Screen Manager
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkCUA.
 *
 *  WkCUA is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkCUA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /usr/src/master/libs/wkswn/scr_sy.h,v 1.2 1996/09/10 12:24:45 wk Exp $
 *
 *  [internal]
 *  more Definitions for Screen Manager
 */

#ifndef HDR_WK_SCR_SY
#define HDR_WK_SCR_SY 1
#ifndef HDR_WK_LIB
    #include <wk/lib.h>
#endif
#ifndef HDR_WK_SCR
    #include <wk/scr.h>
#endif

#if __cplusplus
extern "C" {
#endif

/***** constants ********/
#define SCRDRV_SYNCMIRROR 1	/* kompletten Mirror zurcksetzen*/
#define SCRDRV_SYNCAREA   2	/* bestimme Area zurcksetzen*/
#define SCRDRV_RESTORGSCR 3	/* org Screen wiederherstellen */
#define SCRDRV_SAVEORGSCR 4	/* org Screen wiedersichern */
#define SCRDRV_SOUNDBEEP  5	/* beep */

#ifdef UNIX
    /* window frame */
#define C_WF_UL  '+'    /* upper left corner */
#define C_WF_DUL '*'    /* double .. */
#define C_WF_HL  '-'    /* horizontal line */
#define C_WF_DHL '='    /* double .. */
#define C_WF_UR  '+'    /* upper right corner */
#define C_WF_DUR '*'    /* double .. */
#define C_WF_VL  '|'    /* vertical line */
#define C_WF_DVL '|'    /* double .. */
#define C_WF_LL  '+'    /* lower left corner */
#define C_WF_DLL '*'    /* double .. */
#define C_WF_LR  '+'    /* lower right corner */
#define C_WF_DLR '*'    /* double .. */

#else
    /* window frame */
#define C_WF_UL  '\xda' /* upper left corner */
#define C_WF_DUL '\xc9' /* double .. */
#define C_WF_HL  '\xc4' /* horizontal line */
#define C_WF_DHL '\xcd' /* double .. */
#define C_WF_UR  '\xbf' /* upper right corner */
#define C_WF_DUR '\xbb' /* double .. */
#define C_WF_VL  '\xb3' /* vertical line */
#define C_WF_DVL '\xba' /* double .. */
#define C_WF_LL  '\xc0' /* lower left corner */
#define C_WF_DLL '\xc8' /* double .. */
#define C_WF_LR  '\xd9' /* lower right corner */
#define C_WF_DLR '\xbc' /* double .. */

#endif

/******** types *********/
typedef struct {
	char c;     /* Character*/
	byte a;     /* Attribute Number*/
    } cell_t ;

typedef struct {
	int sy, sx;
	int col;    /* 0 - mono, 1 - Farbe, 2- Farbe Graphik*/
	int r2, r3, r4, r5, r6, r7, r8, r9;
	int r10, r11, r12 ;
    } scrPhyInf_t ;

typedef struct {
	int x1, x2, y1, y2;
	int r1, r2;			/* reserved*/
	void *vp1, *vp2, *vp3, *vp4;	/* reserved*/
    } scrPhyDevCtrl_t ;


/***** Prototypes *******/
    /*-- Module ScrMod0 --*/
int ScrGetAttrTbl( int, const char *, byte *, ushort);
int ScrRegisterDriver( int*,void(*)(cell_t*,int,int,int,int,int),
		       void(*)(scrPhyInf_t*),
		       void(*)(int,int,int),void(*)(int,scrPhyDevCtrl_t*));
int ScrDeRegisterDriver( int );

    /*-- Module ScrMod1 --*/
int ScrChangeRedirector( int, const char *(*)(void) );


#if __cplusplus
}
#endif
#endif /* HDR_WK_SCR_SY */
