/* [pdmenu.c wk 27.5.91] PullDown Menuesystem
 *	(c) Werner Koch (dd9jn) 1991
 * $Header: /usr/src/master/libs/wkswn/pdmenu.c,v 1.5 1997/01/07 15:18:00 wk Exp $
 *
 */


#include <wk/tailor.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/lib.h>
#include <wk/scr.h>
#include <wk/event.h>
#include <wk/rcmgr.h>

#include <wk/cua.h>

/**** constants ***/
#define MAX_DEEP  16	    /* max. MenuTiefe + inclusiv Dummmenue 0 */
#define WIN_A_WIN 14	    /* Window:	 Schwarz auf Trkis */
#define WIN_A_STD  6	    /* Standard: Wei auf Trkis */
#define WIN_A_DIS  5	    /* Disabled: Grau auf Trkis */
#define WIN_A_SEL  1	    /* Selected: Wei auf Schwarz */
#define WIN_A_MRK  7	    /* MarkChar: Gelb auf Trkis */

/**** types ******/
typedef struct {
	ushort oName;	    /* Offset into NameTable; 0 = EndOfArray Marker */
	ushort id;	    /* Id of item or in case of flag.special : */
			    /* 1 = Straight text, can't be selected       */
			    /* 2 = Locate the next Items right justified  */
			    /*	   ( valid only for horicontal menues )   */
			    /* 3 =  Insert some spaces as separator	  */
			    /* 4 =  Insert a bar as Separator		  */
	struct {
	    unsigned level:4; /* MenuLevel of this item; 0=Top */
	    int special:1;  /* this is an special Item */
			    /* ID gives closer Info ( Separator etc. )*/
	    int enabled:1;  /* item is enabled */
	    int toggle:1;   /* add a row for an toggle Character */
	    int togStat:1;  /* Status of toggle Bit */
	    int reserved:3; /* force compiler to use 2 Bytes */
	} flag;
    } minfo_t;

/**** globals ****/
static const char *nameTbl;
static minfo_t *minfo;
static int menuActivFlag;   /* any Menu shown ? */
static struct {
	int whd;	    /* Handle of window */
	ushort id;	    /* ID of selected Item */
	int px,py;	    /* position of selected item within PS */
    } stack[MAX_DEEP];	    /* Stack: das aktuelle Menu ist das letzte Element*/
static int stackInd;
static int cursorId;	    /* actual Id */
static int cursorIdChanged;
static int menuHidden;	    /* Menu is hidden */

/*** local Protos ***/
static ushort ShowWin( int handle, int moveCrs, int xItm, int yItm );
static int MoveCursor( int handle, int direction );
static int MoveKey( int handle, int mrkChr );
/*static int MoveMs( int handle );*/
static int ChangeMenu( int handle, int direction );
static minfo_t *CheckCursor(void);
static minfo_t *GetMenPtr(void);
static void DieQuick(int);


/**** def'd Functions ****/
/**** Global Functions ****/

/*
 * ffnet ein Menue, es wird aber noch nichts angezeigt,
 * liefert einen Handle zurck.
 */

int MenuOpen( const char *name )
{
    minfo_t *mi;
    ushort entries , n, buf[3];
    int rcHd;


    /* load Menu from Resourcefile */
    rcHd= RcmLoadResource( name , RC_PDMENU );
    nameTbl = RcmQryPDMenu( rcHd, &entries );
    minfo = xcalloc( entries+1 /* for end of array */ , sizeof *minfo );
    for( mi=minfo, n=0; n < entries; n++, mi++ ) {
	RcmGetPDMenu( rcHd, n, buf );
     /* printf("RcmGet: n=%u buf= %u %u %u\n", n,buf[0], buf[1], buf[2] );*/
	mi->oName = buf[0] ;
	mi->id	  = buf[1] ;
	mi->flag.level	 = buf[2] & 0x0f;
	mi->flag.special = (buf[2] >> 4) & 1;
	mi->flag.enabled = (buf[2] >> 5) & 1;
	mi->flag.toggle  = (buf[2] >> 6) & 1;
	mi->flag.togStat = (buf[2] >> 7) & 1;
	if( !mi->id )
	    Bug("Invalid Menu '%s'", name );

    }

    menuActivFlag = 0; /* no Menu yet displayed */
    cursorId = 0;   /* default, may be changed by MenuSet() */
    cursorIdChanged=0;
    menuHidden = 0;
    return rcHd;   /* als Handle wird z.Z noch der rcHd benutzt */
}

/*
 * Schliet ein Menue und gibt die Resource wieder frei,
 * der Bildschirm wird aufgerumt.
 */

int MenuClose( int handle )
{
    if( menuActivFlag )
	for( ; stackInd >= 0; stackInd-- )
	    if( ScrClose( stack[stackInd].whd ) )
		DieQuick(__LINE__);
    free( minfo );
    RcmFreeResource( handle );
    return 0;
}

/*
 * Liefert folgende Return Codes:
 * Paramater c ist ein Tastencode
 * Ist ein Menuitem ausgewhlt worden, so wird das Kommando
 * K_CMD_MENUSEL abgesetzt.
 * Ist via Escape das Menusystem beendet worden, so wird das Kommando
 * K_CMD_MENUESC abgestzt ( z.b. auch beim Clicken auuserhalb des Menus)
 * Returns: ErrorCode
 */

int MenuGet( int handle, ushort *retId )
{
    int update, okay, ex, c;
    unsigned eventWord;

    for(ex=0; !ex; ) {
	update = okay = 0;
	if( !menuActivFlag ) {	/* Display the First Menu */
	    stackInd = 0;
	    CheckCursor();
	    ShowWin(handle, 0,0,0);
	    menuActivFlag++;
	    update++;
	}

	if( cursorIdChanged ) {
	    cursorIdChanged=0;
	    ShowWin(handle,1,0,0);
	    update++;
	}

	if( update )
	    c = K_CMD_DUMMY_1;
	else {
	    eventWord = EventWait();
	    if( eventWord & EVT_CMD )
		c = K_CMD_DUMMY_0;
	    else if( eventWord & EVT_KBD )
		c = EventGetKbd();
	    else
		c = K_CMD_DUMMY_0;
	}

	if( c  == K_CMD_DUMMY_0 )
	    ex++;
	else if( c  == K_CMD_DUMMY_1 )
	    ;
	else if( c == K_LEFT || c == K_RIGHT ) { /* hor. */
	    if( !stackInd ) {
		if( !MoveCursor( handle, c == K_LEFT ? -1 : 1 ) )
		    okay = update = 1;
	    }
	    else if( stackInd == 1 ) { /* special Feature */
		ChangeMenu(handle, -1) ; /* go back to TopMenu */
		if( !MoveCursor( handle, c == K_LEFT ? -1 : 1 ) ) {
		    ChangeMenu(handle,1);
		    okay = 1;
		}
		else	/* didn't work, so restore old */
		    ChangeMenu(handle,1);  /* switch back to submenu, but no okay!*/
		update = 1;
	    }
	    EventClear( EVT_KBD );
	}
	else if( stackInd && (c == K_UP || c == K_DOWN) ) {	/* vert. */
	    if( !MoveCursor( handle, c == K_UP ? -1 : 1 ) )
		okay = update = 1;
	    EventClear( EVT_KBD );
	}
	else if( cursorId && c == K_RETURN ) { /* select if any or change to sub */
	    EventClear( EVT_KBD );
	    if( ChangeMenu(handle,1) ) {  /* try to switch to submenu */
		/* no Submenu: select this Item */
		EventPutCmd( K_CMD_MENUSEL );
		ex++;
	    }
	    update = 1;
	    okay = 1;
	}
      #if 0
	else if( c == K_MLEFT || c == K_MRIGHT ) {
	    if( !(i=MoveMs(handle)) ) { /* okay: inside Item */
		ScrUpdate( stack[stackInd].whd );
		if( c == K_MRIGHT )
		    if( ChangeMenu(handle,1) ){  /* try to switch to submenu */
			EventPutCmd(K_CMD_MENUSEL); /*select this Item */
			ex++;
		    }
		okay = update = 1;
	    }
	    else if( i == 2 ) { /* outside of window: simulate Escape */
		if( ChangeMenu(handle, -1) ) { /* go back one menu */
		    cursorIdChanged=1; /* we are topmenu */
		}
		else
		    update = 1; 	 /* a window was closed, so Show this */
		okay = 1;
	    }
	}
      #endif
	else if( c == K_ESCAPE ) {
	    EventClear( EVT_KBD );
	    if( ChangeMenu(handle, -1) ) { /* go back one menu */
		cursorIdChanged=1;
		EventPutCmd( K_CMD_MENUESC );
		ex++;
	    }
	    else
		update = 1;	     /* a window was closed, so Show this */
	    okay = 1;
	}
	else if( isalnum( c ) && c < 256 ) {
	    if( !MoveKey(handle, c ) ) { /* okay: Found, simulate ENTER */
		ScrUpdate( stack[stackInd].whd );
		if( ChangeMenu(handle,1) ) { /* try to switch to submenu */
		    EventPutCmd( K_CMD_MENUSEL );
		    ex++;
		}
		okay = update = 1;
	    }
	    EventClear( EVT_KBD );
	}
	else
	    ex++;

	if( update )
	    ScrUpdate( stack[stackInd].whd );
    }
    *retId = cursorId;
    return 0;
}


/*
 * Setzt das Menue so, dass die Angegebene ID angewhlt ist.
 */

int MenuSet( int handle, ushort id )
{
    cursorId = id;
    cursorIdChanged=1;
    return 0;
}



/*
 * Testet ob der Mouse Cursor im TopMenu ist
 * Returns: True: Mouse is in TopMenue
 *	    False: Mouse not in TopMenu
 */

int MenuMsAtTop( int handle )
{
    int i, x, y, px, py;

    if( menuActivFlag ) {
	ScrMsStat( &i, &x, &y );
	if( i == stack[0].whd ) {
	    ScrGetPos( i, 0 /* position of window */, &px, &py );
	    if( y == py )
		return 1;
	}
    }
    return 0;
}


/*
 * Gibt ein MenueItem zur Auswahl frei
 */

int MenuEnable( int handle, ushort id )
{
    return 0;
}


/*
 * Sperrt ein MenueItem von Auswahl
 */

int MenuDisable( int handle, ushort id )
{
    return 0;
}


/*
 * Geht auf die oberste Menuestufe zurck.
 * und fhrt Update des Screen durch
 */

int MenuBack( int handle )
{
    if( menuActivFlag ) {
	for( ; stackInd > 0; stackInd-- )
	    if( ScrClose( stack[stackInd].whd ) )
		DieQuick(__LINE__);
	ShowWin( handle, 2,0,0 ); /* remove highlighting */
	cursorIdChanged=1;
	ScrUpdate(0);
    }
    return 0;
}


/*
 * Enfernt das Menue vom Bildschirm, verndert aber sonst nicht;
 * d.h. auch ein MenuGet() kann noch benutzt werden, allerdings
 * knnen Auswahlen nur via KeyAccelarator ausgelst werden.
 */

int MenuHide( int handle )
{
    int i;

    if( menuActivFlag )
	for( i = 0; i <= stackInd; i++ )
	    if( ScrHide( stack[i].whd ) )
		DieQuick(__LINE__);
    menuHidden = 1;
    ScrUpdate(0);
    return 0;
}


/*
 * Macht das Menue (wieder) sichtbar, wird es direkt nach
 * MenuOpen() aufgerufen, so wird das erste Anzeigen nicht
 * durch MenuGet() sondern hier besorgt.
 */

int MenuShow( int handle )
{
    int i;

    if( menuActivFlag )
	for( i = 0; i <= stackInd; i++ )
	    if( ScrShow( stack[i].whd ) )
		DieQuick(__LINE__);
    menuHidden = 0;
    ScrUpdate(0);
    return 0;
}


/*
 * Funktion um das Toggle bit zu setze oder zu lesen.
 * Parameter sind die Id und ein Mode:
 * mode -1 : Status des ToggleBits lesen
 *	 0 : ToggleBit auf FALSE setzen
 *	 1 : ToggleBit auf TRUE setzen
 *	 2 : ToggleBit umschalten
 *	 andere Werte reserviert fr Erweiterungen !
 * Returns: alter Status des Toggle Bits. ( 0 oder 1 )
 * Ist kein Toggle Bit fr diese Id vorhanden, wird
 * der Aufruf ignoriert.
 */

int MenuToggle( int handle, ushort id, int mode )
{
    minfo_t *mi;
    ushort stat=0;

    for( mi = minfo; mi->oName ; mi++ )
	if( mi->id == id )
	    if( mi->flag.toggle ) {
		stat = mi->flag.togStat;
		if( mode != -1 ) {
		    if( !mode )
			mi->flag.togStat = 0;
		    else if( mode == 1 )
			mi->flag.togStat = 1;
		    else
			mi->flag.togStat = !stat;
		    if( stackInd == mi->flag.level )
			cursorIdChanged=1; /* to show result */
		}
	    }

    return stat ? 0 : 1;
}


/**** Local Functions ****/

/*
 * Ein Window aufbauen, es wird das Window aufgebaut,
 * welches zum stackInd gehrt; die Stackelemete werden gefllt.
 * mode: 0 = neues Window
 *	 1 = nur Cursor setzen
 *	 2 = Cursor entfernen
 *	 3 = Nur Item bestimmen, nichts anzeigen
 * Returns: Id of Item at Position x,y in actual window
 */

static ushort ShowWin( int handle, int moveCrs, int xItm, int yItm )
{
    minfo_t *mi;
    int sx, sy, whd, noShow;
    int y, x, px, py, i, special, startX;
    const char *t;
    byte attr;
    ushort id, retItm;

    retItm = 0;
    noShow = 0;
    if( moveCrs == 2 )
	id = 0;     /* invalid ID, so nothing will be highlighted */
    else {
	CheckCursor();
	id = cursorId;
    }
    noShow = moveCrs == 3;

    /* Fill and Display the window */
    if( moveCrs ) {
	whd = stack[stackInd].whd ;
	ScrGetPos( whd, 0 /* position of window */, &px, &py );
    }
    else {
	if( !stackInd ) { /* horicontal bar */
	    ScrGetSize( 0 /* PS */, &sx, NULL );
	    sy = 1;
	    px = py = 0;
	    if( ScrOpen( &whd, 0, px, py, sx, sy, WIN_A_WIN, 0,
			 menuHidden ? SCR_MODE_HIDDEN:0))
		DieQuick(__LINE__);
	}
	else {	/* Vertical Menu */
	    /* get position of selected Elemnt in previous window */
	    px = stack[stackInd-1].px;
	    py = stack[stackInd-1].py;
	    py++; /* and one line down */
	    if( stackInd > 1 )
		px += 2;    /* ab 2. vert. Menu: 2 nach rechts */
	    /* Number of items and length of longest */
	    sx = sy = 0;
	    for( mi = GetMenPtr(); mi->oName &&
				   mi->flag.level >= stackInd ; mi++ )
		if( mi->flag.level == stackInd ) {
		    special = mi->flag.special ? mi->id : 0;
		    if( !special || special == 1 ) {
			for( i=0,t = nameTbl + mi->oName; *t; t++ )
			    if( *t != '~' )
				i++;
			if( i > sx )
			    sx = i;
			sy++;
		    }
		    else if( special == 3 || special == 4 )
			sy++;
		}
	    sx += 2; /* leave space for blanks left and right */
	    if( ScrOpen( &whd, 0, px+1, py+1, sx, sy,
			 WIN_A_WIN, SCR_STYLE_FRAME,
			 menuHidden ? SCR_MODE_HIDDEN:0 ))
		DieQuick(__LINE__);
	}
	stack[stackInd].whd = whd;
    }

    /* Loop to show the Items */
    ScrGetSize( whd, &sx, NULL );
    y = 0; x = 0;
    for( mi = GetMenPtr(); mi->oName && mi->flag.level >= stackInd; mi++ ) {
	startX = x;
	if( mi->flag.level == stackInd ) {
	    if( stackInd ) /* vertical */
		x = 0;
	    if( mi->flag.special ) {
		special = mi->id;
		if( special == 1 ) {
		    for(t = nameTbl + mi->oName; *t; t++, x++ )
			if( !noShow )
			    ScrWriteCell(whd, x, y, *t, WIN_A_WIN);
		    if( stackInd )
			y++;
		}
		else if( special == 3 || special == 4 )  {
		    if( !stackInd ) {
			if( !noShow )
			    ScrWriteCell(whd, x, y,
					 special==3? ' ':'\xb3', WIN_A_WIN );
			x++;
		    }
		    else {
			for( ; x < sx; x++ )
			    if( !noShow )
				ScrWriteCell(whd, x, y,
					 special==3? ' ':'\xc4', WIN_A_WIN);
			y++;
		    }
		}
	    }
	    else {
		if( mi->id == id )   {
		    attr = WIN_A_SEL;
		    stack[stackInd].id = id;
		    stack[stackInd].px = x + px;
		    stack[stackInd].py = y + py;
		}
		else
		    attr = mi->flag.enabled ?
				stackInd ? WIN_A_STD : WIN_A_WIN : WIN_A_DIS ;
		if( !noShow )
		    ScrWriteCell(whd, x, y,
			mi->flag.toggle && mi->flag.togStat ? '\xfb': ' ', attr);
		x++;
		for( i=0,t = nameTbl + mi->oName; *t; t++ )
		    if( *t == '~' ) {
			if( attr != WIN_A_SEL )
			    i++ ;
		    }
		    else {
			if( !noShow )
			    ScrWriteCell(whd, x, y, *t, i? WIN_A_MRK:attr);
			x++;
			i = 0;
		    }
		if( !stackInd ) {
		    if( !noShow )
			ScrWriteCell(whd, x, y, ' ', attr );
		    ++x;
		    if( xItm >= startX && xItm < x )
			retItm = mi->id ;
		}
		else {
		    for( ; x < sx; x++	)
			if( !noShow )
			    ScrWriteCell(whd, x, y, ' ', attr );
		    if( yItm == y   )
			retItm = mi->id ;
		    y++;
		}
	    }
	}
    }

    return retItm;
}


/*
 * Im aktuellen Menu den Cursor bewegen
 * direction > 0 : vorwrts
 *	     < 0 : Rckwrts
 * Returns: false = Okay
 *	    true  = error ( we are at an edge )
 */

static int MoveCursor( int handle, int direction )
{
    minfo_t *mi, *miStart;
    ushort id;

    mi = CheckCursor();

    if( direction > 0 ) { /* search next item */
	for( id=0, mi++; mi->oName && mi->flag.level >= stackInd; mi++ )
	    if( mi->flag.level == stackInd ) {
		if( !mi->flag.special )
		    if( mi->flag.enabled ) {
			id = mi->id;
			break;
		    }
	    }
    }
    else {
	for( id=0, mi--, miStart = GetMenPtr(); mi >= miStart; mi-- )
	    if( mi->flag.level == stackInd ) {
		if( !mi->flag.special )
		    if( mi->flag.enabled ) {
			id = mi->id;
			break;
		    }
	    }
    }

    if( id ) {
	cursorId = id;
	ShowWin(handle, 1,0,0 ); /* show it */
	return 0; /* okay */
    }
    return -1; /* error */
}


/*
 * Im aktuellen Menue den cursaor auf den Namen mit dem SelChar setzen.
 * Returns: false = Okay
 *	    true  = error ( no Char)
 */

static int MoveKey( int handle, int mrkChr )
{
    minfo_t *mi;
    ushort id;
    const char *t;
    int i;

    mrkChr = toupper( mrkChr );
    mi = GetMenPtr();
    for( id=0 ; mi->oName && mi->flag.level >= stackInd; mi++ )
	if( mi->flag.level == stackInd ) {
	    if( !mi->flag.special )
		if( mi->flag.enabled ) {
		    for( i=0, t=nameTbl + mi->oName; *t; t++ )
			if( *t == '~' )
			    i++;
			else {
			    if( i )
				if( toupper(*t) == mrkChr ) {
				    cursorId = mi->id;
				    ShowWin(handle, 1,0,0 ); /* show it */
				    return 0; /* okay */
				}
			    i = 0;
			}
		}
	}
    return -1; /* error */
}

/*
 * Im aktuellen Menue den cursor auf die Position des Mouse Cursors setzen
 * Returns: 0 = Okay
 *	    1 = kein Item
 *	    2 = kein Item und ausserhalb des Windows
 */
#if 0
static int MoveMs( int handle )
{
    ushort id;
    int i, x, y;

    ScrMsStat( &i, &x, &y );
    if( i == stack[stackInd].whd ) {  /* okay Mouse ih this window */
	if( id = ShowWin( handle, 3, x, y ) ) {
	    cursorId = id;
	    ShowWin(handle, 1,0,0 ); /* show it */
	    return 0;
	}
	else
	    return 1;	/* not at Item, but inside Window */
    }
    else
	return 2;   /* not inside Window */
}
#endif


/*
 * das Menu wechseln:
 * direction > 0 : Das Submenue zum aktuellen Item anzeigen
 *	     < 0 : das Parentmenue anzeigen, falls bereits
 *		   im TopMenu, fehler aber cursorId auf 0 setzen
 * returns: false = okay; aktion durchgefhrt
 *	    tru   = error; kein Submenu bzw. bereits im Topmenu
 */

static int ChangeMenu( int handle, int direction )
{
    minfo_t *mi;

    mi = CheckCursor();

    if( direction > 0 ) {   /* switch to Submenu */
	mi++;
	if( mi->oName && mi->flag.level == stackInd+1 ) { /* found */
	    if( stackInd ) {	    /* not Topmenu: */
		ShowWin(handle,2,0,0);	/* remove higlighting */
		if( ScrUpdate( stack[stackInd].whd ) ) /* wg. bug ? in SCR */
		   BUG();
	    }
	    stackInd++;
	    xassert( stackInd < MAX_DEEP );
	    ShowWin(handle, 0,0,0); /* create new Window */
	    return 0;	/* okay */
	}
    }
    else {  /* one menu back */
	if( stackInd ) {
	    if( ScrClose( stack[stackInd].whd ) )
		DieQuick(__LINE__);
	    stackInd-- ;
	    cursorId = stack[stackInd].id;
	    ShowWin(handle, 1,0,0); /* window ist ja noch da */
	    return 0;	/* okay */
	}
	else {
	    cursorId = 0;   /* can't leave topmenu , but set cursorId to none*/
	    ShowWin(handle, 2,0,0 ); /* remove hightlighting */
	}
    }
    return -1 ; /* error */
}



/*
 * Funktion berprft, ob im aktuellen Menu ein Cursor gesetzt ist,
 * wenn nicht wird cursor Id auf das erste Elemnt gestzt.
 * Anzeige erfolgt jedoch nicht.
 * Returns: Ptr zum ausgewhlten Element
 */

static minfo_t *
CheckCursor()
{
    minfo_t *mi, *miSave;

    miSave = NULL ;
    for( mi = GetMenPtr(); mi->oName && mi->flag.level >= stackInd; mi++ )
	if( mi->flag.level == stackInd )
	    if( !mi->flag.special ) {
		if( !miSave )
		    miSave = mi;
		if( mi->id == cursorId )
		    return mi; /* okay cursorId is okay */
	    }
    xassert(miSave);
    cursorId = miSave->id ;
    return miSave;
}


/*
 * Dies Funktion gibt einen Zeiger auf das erste Element
 * des aktuellen Menues zurck
 */

static minfo_t *GetMenPtr()
{
    minfo_t *mi;
    ushort id;
    int state;

    if( !stackInd ) /* Topmenu will start with the first element */
	return minfo;

    id = stack[stackInd-1].id ; /* last selected id */
    for( mi = minfo, state=0; mi->oName; mi++ )
	if( !mi->flag.special || state ) {
	    if( !state && mi->id == id )
		state++; /* first we have to pass the selection of parent menu*/
	    else if( state && mi->flag.level == stackInd )
		return mi ;
	}
    BUG();
    /*NOTREACHED*/
    return NULL;
}



/*
 * Abbruch des Systems nach ScreenError
 */

static void DieQuick( int line )
{
    Fatal("%s[%d]: ScreenError: %s", __FILE__ , line, ScrErrorText(-1) );
    exit(4);
}



#ifdef TEST
/******************************************************
 ******** Test suite **********************************
 */

#include <conio.h>  /* wg. kbhit() */
static void Beep(void);

#include "testmenu.h"

int main( int argc, char **argv )
{
    int mhd, whd, c, ret;
    ushort id;

    RcmInitialize( *argv );
    ErrorRgText( 2, ScrErrorText );
    if( ScrInitialize(0,0,0,0,0,0,0) )
	Error(2004,"Can't init Screen");
    if( ScrInitDriverStd(0,0) )
	Error(2004,"Can't init ScreenDriver");

    if( ScrOpen( &whd, 0, -1, -1, 20, 1 , 3, SCR_STYLE_DBLFRAME, 0 ))
	Error(2002,"Can't open screen");
    if( ScrPrintF( whd, " ID = %d", id ) )
	Error(2002,"Can't ScrPrintF");
    if( ScrUpdate( whd ) )
	Error(2002,"Can't ScrUpdate");


    mhd = MenuOpen("TestMenu");

    do {
	/* wait for Selection */
	while( (ret=MenuGet( mhd, c=inkey(), &id )) != 2 )
	    if( !ret )
		if( c == K_F3 ) {
		    id = ID_EXIT;
		    break;
		}
		else if( c )
		    Beep() ; /* ungltiger Code */

	if( ScrUpdate( 0 ) )
	    Error(2002,"Can't ScrUpdatePS" );
	switch(id) {
	  case 0 :  MenuSet(mhd, ID_FILE ); break;
	  case ID_TELIX_C1:
	  case ID_TELIX_C2:
	  case ID_TELIX_C3:
	  case ID_TELIX_C4:
	  case ID_HELP:
	    MenuToggle(mhd, id, 2 );
	    break;
	  case ID_CLOSE:
	    MenuClose(mhd);
	    if( ScrPrintF( whd, " closed ", id ) )
		Error(2002,"Can't ScrPrintF");
	    if( ScrUpdate( 0 ) )
		Error(2002,"Can't ScrUpdate");
	    while( inkey() )
		;
	    while( !inkey() )
		;
	    mhd = MenuOpen("TestMenu");
	    break;
	  case ID_LOAD: MenuHide(mhd); break;
	  case ID_SAVE: MenuShow(mhd); break;

	}

    } while( id != ID_EXIT );

    MenuClose(mhd);
    ScrClose( whd );
    ScrUpdate(0);
    return 0;
}


int inkey(void)
{
    int  c ;

    if( kbhit() )
	return	((c=getch()) == 0)?  getch() +256 : c ;
    else
	return 0 ;
}

static void Beep()
{
    putchar('\a');
    fflush(stdout);
}

#endif


/***********************************************************
 *  Kurze verbale Beschreibung
 *
 * 1) Unterfunktion: Window Anzeigen
 *   --------------------------------
 * - Entscheiden welcher MenueTyp:
 *   Erstes Item bestimmen:
 *   - solange zurck bis flag.first gefunden
 *     ( falls nicht gefunden ---> bug )
 *   A : Horizontal:
 *   ---------------
 *   - Screenbreite Bestimmen
 *   - Window ffnen (1 Zeile hoch, Screenbreite breit)
 *   - loop over Items until next first oder EndOfItems gefunden
 *	   -Name oder Special Anzeigen ( falls Name zu lang --> bug() )
 *     endloop
 *   B: Vertikal:
 *   ------------
 *   - loop over Items until next first on lower level oder EndOfItems gefunden
 *	   if( same level )
 *	   -lngesten Namen bestimmen
 *	   - Anzahl der Namen , bzw Separator bestimmen
 *     endloop
 *   - Windowposition aufgrund des parentWindows bestimmen
 *   - Window zu gro ? -->bug
 *   - Window ffnen (mit den ermittelten Daten)
 *   - loop over Items until next first oder EndOfItems gefunden
 *	   -Name oder Special Anzeigen
 *	   - nchste Zeile
 *     endloop
 * Ende Der Funktion
 *
 *
 * 2. Unterfunktion: Cursorsetzen
 *   - Erstes Item bestimmen:
 *     - solange zurck bis flag.first gefunden
 *	 ( falls nicht gefunden ---> bug )
 *   - loop over Items until next first on lower level oder EndOfItems gefunden
 *	   if( same Lavel )
 *	       -Ist die das aktuelle Item gleich diesem:
 *		 ja: Auswahlfarbe setzen
 *		 nein: Standardfarbe setzen
 *	       -Name oder Special Aneu Anzeigen ( hor. und Vertikal unterscheiden ! )
 *     endloop
 *
 *
 *
 * 3. FunktioN. MenueGet()
 *    - TastenCode verfgbar ( inkey() )
 *
 *	ja: case Cursor Taste:
 *		aktuelleItem vorhanden ?
 *		   Ja: Item entsprechen Korrigieren
 *		       aktuelles darauf setzen
 *		       Cursorsetzen()
 *		   nein: Auf aktuellesItem  default Item setzen
 *	    case Buchstabe
 *		   Buchtabe als Auswahlzeichen in einem Item vorhanden ?
 *		     ja: auf 1. Item mit diesem Buchstaben setzen
 *			 Cursorsetzen()
 *		     nein: beep()
 *	    case ENTER:
 *		 aktuelles Item vorhanden:
 *		   Folgt ein Submenue
 *		       Submenue als nchstest menue vormerken
 *		   ID ermitteln und returnCode 2
 *
 *	    case ESCAPE:
 *		 Topmenue ist aktuelle:
 *		   ID := 0 zurckgeben, ReturnCode := 2
 *		 nein:
 *		   Window schlieen
 *		   Parentmenue vormerken
 *		   ID von ParentItem Ermitteln, returnCode := 1
 *	MausCode verfgbar und Maus innerhalb des aktuellen Windows:
 *	  nein: keine Aktiion
 *	   ja: Id des Items unter Maus bestimmen
 *	       ID  := MenueId
 *	       linke Taste: returnCode :=1
 *	       recte Taste: Sprung zu ENTER
 *
 */

/***** bottom of File *****/
