/* [dlg.c wk 10.6.91] TEST Dialog Windows
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * $Header: /usr/src/master/libs/wkswn/dtest.c,v 1.3 1996/09/10 12:24:42 wk Exp $
 *
 */

#include <wk/tailor.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <signal.h>
#include <wk/lib.h>
#include <wk/scr.h>
#include <wk/keys.h>
#include <wk/rcmgr.h>
#include <wk/cua.h>
#include <wk/event.h>

#include "dtest.h"



int main( int argc, char **argv )
{
    int hdDlg, dlgBody, mhd, c, ret,i, menuFlag, menSel;
    int activeDlg;
    int new_c, ex;
    ushort id, menId, bodyId;
    ushort activeId;
    unsigned eventWord, clearWord;

    Initialize_Main();
    RcmInitialize( *argv );
    ErrorRgText( 2, ScrErrorText );
    if( ScrInitialize(0,0,0,0,0,0,0) )
	Error(2004,"Can't init Screen");
    if( ScrInitDriverStd(0,0) )
	Error(2004,"Can't init ScreenDriver");
    EventInit();
    ScrCursor( 0, SCR_MCRS_SHOW, 0, 0 );

    DialogSigInit();
    mhd = MenuOpen("TestMenu");
    MenuShow(mhd);
    hdDlg = DialogOpen( "AtexHeader" );
    DialogShow( hdDlg );
    dlgBody = DialogOpen( "AtexBody" );

    id = bodyId = 0;
    menuFlag = 1;
    new_c = 0;
    clearWord = ~0; /* clear all events */
    activeDlg = hdDlg;
    activeId = id;
    for( ex=0; !ex; ) {
	if( clearWord ) {
	    EventClear( clearWord );
	    clearWord = 0;
	}


	if( menuFlag ) {
	    if( MenuGet( mhd, &menId ) == K_CMD_MENUESC )
		menuFlag = 0;
	}
	else
	    DialogSeqEdit( activeDlg, &activeId );
	eventWord = EventWait();
	if( eventWord & EVT_KBD )
	    c = EventGetKbd();
	else if( eventWord & EVT_CMD )
	    c = EventGetCmd();
	else
	    EventError();

	switch( c ) {  /* process other keys */
	  case K_F5: activeDlg = dlgBody ;
		     activeId  = bodyId;   clearWord = EVT_KBD; break;
	  case K_F6: activeDlg = hdDlg	 ;
		     activeId  = id;	   clearWord = EVT_KBD; break;

	  case K_ESCAPE:
	    menuFlag = !menuFlag;
	    clearWord = EVT_KBD;
	    break;

	  default:
	    if( 0  /*EventPeek() & ~EVT_KBD*/ )  /* org: EventPoll() */
		EventError();
	    else {
		clearWord = EVT_KBD;
		ScrBeep();
	    }
	    break;
	}
    }

    DialogClose( dlgBody );
    DialogClose( hdDlg );
    MenuClose( mhd );
    ScrUpdate(0);
    return 0;
}



/***** bottom of File *****/
