/* [dlgwin4.c wk 10.6.91] Dialog Windows: ListBox
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * $Header: /usr/src/master/libs/wkswn/dlgwin4.c,v 1.3 1997/01/07 15:17:59 wk Exp $
 *
 */

#include <wk/tailor.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/lib.h>
#include <wk/scr.h>
#include <wk/event.h>
#include <wk/cua.h>

#include "dlgwin.h"
#include "dlgwin2.h"

/**** constants ***/
/***** types *****/
/**** globals ****/
/*** local Protos ***/
static void PaintScrollbar(dlgwin_t*d,int x,int py,int sy,size_t count,size_t pos);
static int GetGliderPos( int sy, size_t count, size_t pos, int *gyRet );

/**** def'd Functions ****/
#define EnterCritical()     /* Dummies*/
#define LeaveCritical()     /* Dummies*/
/**** Global Functions ****/

/*
 * ListBox
 * Den Rahmen zeichnen
 */

int Dialog_put20( dlgwin_t *dlg, dlg_lstbox_t *box )
{
    int px, py, sx, sy, whd;
    int x,y, x2, y2, frame;
    byte attr, attrInv;

    whd = dlg->whd;
    attr = dlg->col[WIN_A_FLD];
    attrInv = dlg->col[WIN_A_SEL];
    frame = box->flag.noFrm ? 0 : 1;
    px = box->px-frame;
    py = box->py-frame;
    sx = box->sx+2*frame;
    sy = box->sy+2*frame;

    x2 = px+sx-1;
    y2 = py+sy-1;
    x = px;
    if( frame ) {
	ScrWriteCell( whd, x, py, C_UL, attr );
	ScrWriteCell( whd, x, y2, C_LL, attr );
	for(x++; x < x2 ; x++ ) {
	    ScrWriteCell( whd, x, py, C_HL, attr );
	    ScrWriteCell( whd, x, y2, C_HL, attr );
	}
	ScrWriteCell( whd, x, py, C_UR, attr );
	ScrWriteCell( whd, x, y2, C_LR, attr );
	for( y = py+1; y < y2; y++ )
	    ScrWriteCell( whd, px, y , C_VL, attr );
    }
    if( sy > 3 )  {    /* 4 ist mindesthhe fr Pfeile */
	ScrWriteCell( whd, x2, py+1, C_AU  , attrInv ); /* Pfeil hoch */
	ScrWriteCell( whd, x2, y2-1, C_AD  , attrInv ); /* Pfeil runter */
    }
    return 0;
}



/*
 * ListBox
 * Editieren
 * mode 0: nur anzeigen und direkt wieder zurck
 *	1: editieren
 * Retuns: errocode
 */

int Dialog_edt20( dlgwin_t *dlg, dlg_lstbox_t *box, int mode)
{
    int pos, wpos, count;
    const char *t;
    byte attr, attr_sel, attr_edt, attr_std, attr_std2;
    int upd, x, y, i, ex, keyCode=0, frame, selCol;
    int px, py, sx, sy;
    unsigned eventWord=0;
    unsigned btns;

    attr_sel = dlg->col[WIN_A_SEL];
    attr_edt = dlg->col[WIN_A_BTN0];
    attr_std = dlg->col[WIN_A_FLD];
    attr_std = dlg->col[WIN_A_FLD];
    attr_std2 = dlg->col[WIN_A_BTN2];
    frame = box->flag.noFrm ? 0 : 1;	/* auf definierte Werte setzen */
    selCol= box->flag.selCol ? 1 : 0;
    px = box->px;
    py = box->py;
    sx = box->sx;
    sy = box->sy;
    pos = box->pos;
    wpos = box->wpos;
    count = box->nstrgs;

    if( !count )
	return 0;   /* nothing to do */
    if( pos >= count || pos < 0 )
	pos = 0;
    if( wpos < 0 || wpos >= sy )
	wpos = 0;

    for(ex=0; !ex; ) {
	upd = 0;
	if( !mode ) {
	    ex++;  /* nur anzeigen und direkt zurck */
	    upd++;
	    keyCode = K_CMD_DUMMY_0;
	}
	else {
	    eventWord = EventWait();
	    if( eventWord & EVT_CMD ) {
		keyCode = EventGetCmd();
		if( keyCode == K_CMD_EDITSTART ||
		    keyCode == K_CMD_EDITEND ||
		    keyCode == K_CMD_EDITUPD )
		    upd++;		  /* nur anzeigen*/
		else
		    keyCode = K_CMD_DUMMY_0;
	    }
	    else if( eventWord & EVT_KBD )
		keyCode = EventGetKbd();
	    else if( eventWord & EVT_MS ) {
		btns = ScrMsStat( &i, &x, &y );
		if( i == dlg->whd && x == px+sx )  /* in scroll bar */
		    if( eventWord & EVT_MSLB )
			keyCode = K_CMD_USER_0; /* left mouse btn clicked */
		    else if( eventWord & EVT_MSRB )
			keyCode = K_CMD_USER_1; /* right Button clicked */
		    else if( eventWord & EVT_MSMV )
			keyCode = K_CMD_USER_2; /* dragged */
		else
		    keyCode = K_CMD_DUMMY_0;
	    }
	    else
		keyCode = K_CMD_DUMMY_0;
	}

	switch( keyCode ) {
	  case K_CMD_EDITSTART:
	  case K_CMD_EDITEND:
	    break;
	  case K_CMD_EDITUPD:
	    upd++;
	    break;

	  case K_CMD_DUMMY_0:
	    ex++;
	    break;

	  case K_CMD_USER_0:	/* left Button is down */
	    if( y == py ) { /* Up-Arrow */
		if( pos > 0 ) {
		    pos--;
		    if( wpos )
			wpos-- ;
		    upd++;
		}
	    }
	    else if( y == py+sy-1 )  { /* Down Arrow */
		if( pos+1 < count ) {
		    pos++;
		    if( wpos+1 < sy )
			wpos++;
		    upd++;
		}
	    }
	    else if( y > py && y < py+sy-1) {
		int psX, psY;
		ScrGetPos( dlg->whd, 0, &psX, &psY );
	    }
	    EventClear( EVT_MSLB );
	    break;


	  case K_CMD_USER_2:	/* mouse moved with button */
	    {
		int gh, gy, dmy1, dmy2;

		gh = GetGliderPos( sy,	count, pos, &gy );
		gy += py-1;
		if( gh )
		    if( y >= gy && y < gy+gh ) { /* inside glider */
			if( EventGetMs(&dmy1,&dmy2) & EVT_MS_MV_U ) {
			    if( pos > 0 ) {
				pos--;
				if( wpos )
				    wpos-- ;
				upd++;
			    }
			}
			else {	/* must be down */
			    if( pos+1 < count ) {
				pos++;
				if( wpos+1 < sy )
				    wpos++;
				upd++;
			    }
			}
		    }
	    }
	    if( !upd )
		EventClear( EVT_MSMV );
	    break;



	  case K_UP :
	    if( pos > 0 ) {
		pos--;
		if( wpos )
		    wpos-- ;
		upd++;
	    }
	    break;

	  case K_DOWN :
	    if( pos+1 < count ) {
		pos++;
		if( wpos+1 < sy )
		    wpos++;
		upd++;
	    }
	    break;

	  case K_PGUP :
	    if( pos >= (sy-1) ) {
		pos -= (sy-1) ;
		wpos = 0;
		upd++;
	    }
	    break;

	  case K_PGDN :
	    if( pos+(sy-1) < count ) {
		pos += (sy-1) ;
		wpos = 0;
		upd++;
	    }
	    break;

	  case K_HOME :
	    pos = wpos = 0;
	    upd++;
	    break;

	  case K_END :
	    pos = count-1;
	    wpos = 0;
	    upd++;
	    break;

	  default : ex++; break;
	}

	if( upd ) {
	    for( y = 0; y < sy; y++ ) {
		t = pos-wpos+y < count ?  box->text[pos-wpos+y] : "\0" ;
		if( selCol ) {
		    if( y==wpos )
			attr = (keyCode == K_CMD_EDITEND ||!mode)?
				attr_sel: attr_edt;
		    else
			attr = *t ? attr_std2 : attr_std;
		    t++;
		}
		else {
		    attr = y==wpos ?
		       (keyCode == K_CMD_EDITEND ||!mode)? attr_sel :
							   attr_edt : attr_std;
		}
		for(x = 0; x < sx && *t ; x++ )
		    ScrWriteCell( dlg->whd, px+x, py+y, *t++, attr );
		for(; x < sx ; x++ )
		    ScrWriteCell( dlg->whd, px+x, py+y, ' ', attr );
	    }

	    PaintScrollbar( dlg, px+sx, py, sy, count, pos );
	    ScrUpdate(dlg->whd);
	    box->wpos = wpos;
	    box->pos = pos;
	}

	if( !ex && keyCode != K_CMD_USER_0 ) {
	    EventClear( eventWord & EVT_CMD ? EVT_CMD : EVT_KBD );
	    if( keyCode == K_CMD_EDITEND )
		ex++;
	}

    }

    return 0;
}




/*
 * Eine Scrollbar zeichen, Pfeile sind bereits gezeichnet.
 * Parms: x = X-Position
 *	  sy = Hhe des Windows ( Scrollbar ist 2 kleiner ( wg. Pfeile ) )
 *	  count = Anzahl der Elemente
 *	  pos	= Nummer des Anzuzeigendden Elements
 */

static void PaintScrollbar( dlgwin_t *dlg, int x, int py, int sy,
			   size_t count, size_t pos)
{
    int glider_py, glider_y2,  y, y2, whd;
    byte attr;

    py--;
    whd = dlg->whd;
    attr = dlg->col[WIN_A_FLD];
    if( sy > 4 )  {    /* 5 ist Mindesthhe fr Scrollbar */
	glider_y2 = GetGliderPos( sy, count, pos, &glider_py );
	glider_py += py;
	glider_y2 += glider_py-1 ;
	y2 = py+sy;
	for( y=py+2; y < y2; y++ ) {
	    if( y < glider_py || y > glider_y2 ) /* Paint bar */
		ScrWriteCell( whd, x, y , C_B1, attr );
	    else /* Paint glider */
		ScrWriteCell( whd, x, y , C_B0, attr );
	}
    }
}


/*
 * Bestimmt die Position und die gre des gliders.
 * Args: sy = Anzahl der Zeilen in der Listbox
 *	 count = Gesamtanzahl der Zeilen
 *	 pos   = Aktuelle Zeile
 *	 gyRet = Return : Y-Position des Gliders
 * Returns: Gre des Gliders bzw. 0 wenn keiner da.
 */

static int GetGliderPos( int sy, size_t count, size_t pos, int *gyRet )
{
    int gy;	/* Gliderposition*/
    int gh;	/* hoehe des Gliders */

    if( sy > 4 )  {    /* 5 ist Mindesthhe fr Scrollbar */
	/* Hhe des Gliders bestimmen */
	if( (gh = (sy * (sy-2)) / count ) < 1 )
	    gh = 1; /* min. Hoehe */
	/* Position des Gliders bestimmen ( oberer Rand ) */
	if( gh >= sy-4 )
	    gy = 2;   /* first valid positoion for a glider */
	else
	    gy = 2 + ((sy-4-gh/2)*pos) / count ;
	*gyRet = gy;
    }
    else
	gh = 0;
    return gh;
}

/***** bottom of File *****/
