/* [dlgwin3.c wk 5.6.91] Dialog Windows: Buttons
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * $Header: /usr/src/master/libs/wkswn/dlgwin3.c,v 1.2 1996/09/10 12:24:42 wk Exp $
 *
 */

#include <wk/tailor.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/lib.h>
#include <wk/scr.h>
#define INCL_CTRL_KEYCODES 1
#include <wk/event.h>
#include <wk/cua.h>

#include "dlgwin.h"
#include "dlgwin2.h"

/**** constants ***/


/***** types *****/
/**** globals ****/
/*** local Protos ***/
/**** def'd Functions ****/
/**** Global Functions ****/

/* [Internal]
 * Anzeigen eines Buttons, bzw. mehrerer RadioButtons
 * mode : 0 = Nur anzeigen
 *	  1 = Edit-Mode
 *	  2 = Edit-Mode 2 (nur Cursor setzen)
 * Retuns: errorCode
 */

int Dialog_put10( dlgwin_t *dlg, dlg_button_t *button, int mode )
{
    int n, x, y, onFlag, nbtn, sx, px, py, crsFlag, hd, esc;
    const char *t, *txtTbl;
    byte a, attr, attr0, attr1, attr2;
    char c;

    hd = dlg->whd;
    txtTbl = dlg->txtTbl;
    attr  = dlg->col[WIN_A_BTN];
    attr0 = dlg->col[WIN_A_BTN0];
    attr1 = dlg->col[WIN_A_BTN1];
    attr2 = dlg->col[WIN_A_BTN2];
    nbtn = button->nBtn;
    for(n=0; n < nbtn; n++ ) {
	px = x = button->btn[n].px;
	py = y = button->btn[n].py;
	t = txtTbl + button->btn[n].oText;
	if( nbtn == 1 ) {
	    onFlag = button->val;
	    crsFlag = 1;
	}
	else {
	    onFlag = (button->val&0xff) == n;
	    crsFlag =(button->val>>8)	== n;
	}
	if( *t ) { /* Text Button */
	    a = onFlag ? mode ? attr0 : attr1 : attr ;
	    esc = 0;
	    for( sx=0 ; *t; t++ )
                if( !esc && *t == '~' && t[1] != '~' )
		    esc++;
		else {
		    ScrWriteCell(hd, x++, y, *t,
				    esc && !(onFlag && mode)? attr2 : a);
		    esc = 0;
		    sx++;
		}
	    /* Rahmen darum malen */
	    a = attr1;
	    x = px-1; y = py-1;
	    ScrWriteCell(hd, x, y  , C_UL, a );
	    ScrWriteCell(hd, x, y+1, C_VL, a );
	    ScrWriteCell(hd, x, y+2, onFlag? C_LL_H:C_LL, a );
	    for( c = onFlag? C_HL_H:C_HL, x++,sx += px; x < sx; x++ ) {
		ScrWriteCell(hd, x, y, C_HL, a );
		ScrWriteCell(hd, x, y+2, c   , a );
	    }
	    ScrWriteCell(hd, x, y  , onFlag? C_UR_H:C_UR, a );
	    ScrWriteCell(hd, x, y+1, onFlag? C_VL_H:C_VL, a );
	    ScrWriteCell(hd, x, y+2, onFlag? C_LR_H:C_LR, a );
	}
	else {	/* Check Button */
	    if( mode != 2 ) {
                ScrWriteCell(hd, x-1, y, '('             , attr1);
                ScrWriteCell(hd, x  , y, onFlag? 'X':' ' , attr1);
                ScrWriteCell(hd, x+1, y, ')'             , attr1);
	    }
	    if( crsFlag && mode )
		ScrCursor(hd, SCR_CRS_SET, x, y );
	}
    }

    return 0;
}


/* [Internal]
 * Editieren im Window, for Itemtype Button
 * Retuns: 0 = Key not used
 *	   DLGE_KEYUSD = key used
 */

int Dialog_edt10( dlgwin_t *dlg, dlg_button_t *button)
{
    int upd, ex, endCmd, keyCode;
    byte lsb, msb;
    unsigned eventWord;

    lsb = button->val & 0xff;
    msb = button->val>>8 & 0xff;
    for(endCmd=upd=ex=0; !ex; ) {
	eventWord = EventWait();
	if( eventWord & EVT_CMD ) {
	    keyCode = EventGetCmd();
	    if( keyCode == K_CMD_EDITSTART ) {
		if( !button->btn[0].oText )  /* cursor on bei CheckButtons */
		    ScrCursor(dlg->whd, SCR_CRS_SHOW, 0, 0 );
		upd = 1;
	    }
	    else if( keyCode == K_CMD_EDITEND ) {
		ScrCursor(dlg->whd, SCR_CRS_HIDE, 0, 0 );
		upd = 1;
		endCmd++;
	    }
	    else
		ex++;
	}
	else if( eventWord & EVT_KBD ) {
	    keyCode = EventGetKbd();
	    if( button->nBtn==1 && button->btn[0].oText ) /*single textButton*/
                ex++; /* we can't change any value, always selected */
	    else if( button->nBtn == 1 ) {  /* Single Button */
                if( keyCode == ' ' ) { /* Change Value */
		    lsb = !lsb;
		    upd = 1;
		}
		else
		    ex++;
	    }
	    else if( keyCode == K_LEFT || keyCode == K_UP ) {
		if( msb ) {
		    msb--;
		    upd = 2;
		}
	    }
	    else if( keyCode == K_RIGHT || keyCode == K_DOWN ) {
		if( msb < button->nBtn-1 ) {
		    msb++;
		    upd =2;
		}
	    }
            else if( keyCode == ' '  ) {
		if( button->btn[0].oText ) { /* text button */
		    if( msb < button->nBtn-1 )
			msb++;
		    else
			msb = 0;
		    upd = 2;
		}
		else {
		    if( msb >= button->nBtn )
			msb = 0;    /* falls doch mal ein falscher Wert */
		    lsb = msb;
		    upd = 1;
		}
	    }
	    else
		ex++;
	}
	else if( eventWord & EVT_MSLB ) {
	    int x, y;
	    unsigned bstate;

	    bstate = EventGetMs(& x, &y);
	    if( button->nBtn==1 && button->btn[0].oText ) /*single textButton*/
                ex++; /* we can't change any value, always selected */
	    else if( button->nBtn == 1 ) {  /* Single Button */
		if( bstate & EVT_MS_BT_L ) { /* Change Value */
		    lsb = !lsb;
		    upd = 1;
		    if( bstate & EVT_MS_BT_LD )
			ex++;
		}
		else
		    ex++;
	    }
	    else if( bstate & EVT_MS_BT_L ) {
		if( msb >= button->nBtn )
		    msb = 0;	/* falls doch mal ein falscher Wert */
		lsb = msb;
		upd = 1;
		if( bstate & EVT_MS_BT_LD )
		    ex++;
	    }
	    else
		ex++;
	}
	else
	    ex++;

	if( upd ) {
	    if( button->btn[0].oText )	/* text Buttons */
		lsb = button->nBtn==1? 1 : msb ;
	    button->val = msb << 8 | lsb;
	    Dialog_put10(dlg, button, endCmd ? 0 : upd );
	    ScrUpdate(dlg->whd);
	    upd = 0;
	}
	if( !ex )
	    EventClear( eventWord & EVT_CMD ? EVT_CMD :
			eventWord & EVT_KBD ? EVT_KBD : EVT_MSLB );
	if( endCmd )
	    ex++;
    }

    return 0;
}

/***** bottom of File *****/
