/* [dlgwin2.c wk 5.6.91] Dialog Windows: EditFunc
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * History:
 * 05.07.93 wk	Multiline edit eingebaut.
 */

#include <wk/tailor.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/lib.h>
#include <wk/scr.h>
#define INCL_CTRL_KEYCODES 1
#include <wk/event.h>
#include <wk/cua.h>

#include "dlgwin.h"

/**** constants ***/
/***** types *****/
/**** globals ****/
static int cursorForm = SCR_CRS_FORM_A;     /* Global Cursor Form */
/*** local Protos ***/
/**** def'd Functions ****/
/**** Global Functions ****/

/* [Internal]
 * Editieren im Window, Fieldtype is ALFA
 * Retuns: errorCode
 */

int Dialog_edt01( dlgwin_t *dlg, dlg_item_t *item )
{
    int cx,cy;		/* Cursor Position */
    int x1, y1, x2, y2;
    int upd, ex;	/* Update Flag*/
    int x,y,i;		/* helper */
    char c;
    byte a, attr, attr0;
    int hd, cpsLck, keyCode;
    unsigned eventWord;

    hd = dlg->whd;
    attr = dlg->col[WIN_A_FLD];
    attr0 = dlg->col[WIN_A_FLD0];
    x1 = item->x.field.px;
    x2 = x1 + item->x.field.sx - 1;
    y1 = item->x.field.py;
    y2 = y1 + item->x.field.sy - 1;
    cpsLck = item->x.field.flag.pts == 1;

    upd = 0;
    ScrGetPos( hd, 1, &cx, &cy );
    if( EventPoll() & EVT_CMD )
	if( EventGetCmd() == K_CMD_EDITSTART )
	    upd++;
    if( cx < x1 || cx > x2 || cy < y1 || cy > y2 || upd ) {
	ScrCursor( hd, SCR_CRS_SET, cx=x1, cy=y1 );
	ScrCursor( hd, SCR_CRS_SHOW, 0, 0 );
	upd++;
    }

    for(ex=0; !ex ; ) {
	eventWord = EventWait();
	if( eventWord & EVT_CMD )
	    keyCode = EventGetCmd();
	else if( eventWord & EVT_KBD )
	    keyCode = EventGetKbd();
	else
	    keyCode = K_CMD_DUMMY_0;

	switch( keyCode ) {
	  case K_CMD_DUMMY_0:
	    ex++;
	    break;

	  #if 0
	  case K_MLEFT:
	    ScrMsStat( &i, &x, &y );
	    ret = 0;
	    if( i == hd )  /* left Button pressed inside this window*/
		if( x >= x1 && x <= x2 && y >= y1 && y <= y2 )	 {
		    /* and inside the field */
		    ret = DLGE_KEYUSD;
		    ScrCursor(hd,SCR_CRS_SET, x, y );
		    upd++;
		}
	    break;
	  #endif

	  case K_LEFT:	/* Cursor um eins nach links */
	    if( cx > x1 ) {
		ScrCursor(hd,SCR_CRS_SETREL, -1, 0 );
		cx--;
	    }
	    upd++;
	    break;

	  case K_RIGHT:  /* Cursor um eins nach rechts */
	    if( cx < x2 ) {
		ScrCursor(hd,SCR_CRS_SETREL, 1, 0 );
		cx++;
	    }
	    upd++;
	    break;

	  case K_UP:  /* Cursor um eins nach oben */
	    if( cy > y1 ) {
		ScrCursor(hd,SCR_CRS_SETREL, 0, -1 );
		cy--;
		upd++;
	    }
	    else
		ex++;
	    break;

	  case K_DOWN:	/* Cursor um eins nach unten */
	    if( cy < y2 ) {
		ScrCursor(hd,SCR_CRS_SETREL, 0, 1 );
		cy++;
		upd++;
	    }
	    else
		ex++;
	    break;

	  case K_HOME:	 /* Cursor an Feldanfang */
	    ScrCursor(hd,SCR_CRS_SET, cx = x1, cy = y1 );
	    upd++;
	    break;
	  case K_END :	 /* Cursor anz Feldende */
	    ScrCursor(hd,SCR_CRS_SET, cx = x2, cy = y2 );
	    upd++;
	    break;

	  case K_CLEFT:  /* Ein Wort zurck */
	    for(y=cy,x=cx-1 ; x >= x1 ; x-- ) {   /* Wortende suchen */
		ScrReadCell(hd, x, y, &c, NULL );
		if( c != ' ' )
		    break;
	    }
	    for( ; x >= x1 ; x-- ) {   /* Wort Anfang suchen */
		ScrReadCell(hd, x, y, &c, NULL );
		if( c == ' ' )   /* found */
		    break;
	    }
	    if( x < cx ) {
		ScrCursor(hd,SCR_CRS_SET, cx = x+1, cy = y );
		upd++;
	    }
	    break;

	  case K_CRIGHT:  /* Ein Wort vorwrts */
	    for(i=0,y=y1,x=cx ; x <= x2 ; x++ ) {   /* blank Suchen */
		ScrReadCell(hd, x, y, &c, NULL );
		if( c == ' ' ) {
		    i = x ;
		    break;
		}
	    }
	    for(i=x ; x <= x2 ; x++ ) {   /* Wort Anfang suchen */
		ScrReadCell(hd, x, y, &c, NULL );
		if( c != ' ' ) { /* found */
		    ScrCursor(hd,SCR_CRS_SET, cx = x, cy = y );
		    upd++;
		    i = 0;
		    break;
		}
	    }
	    if( i && i <= x2 ) { /* war letztes wort: hinter dieses gehen */
		ScrCursor(hd,SCR_CRS_SET, cx = i, cy = y);
		upd++;
	    }
	    break;

	  case K_RUBOUT :   /* Delete char left of cursor and move left */
	    for(y=cy,x= cx > x1? cx-1:x1; x < x2; x++ )  {
		ScrReadCell(hd, x+1, y, &c, &a);
		ScrWriteCell(hd, x, y, c, a );
	    }
	    ScrWriteCell(hd, x2, y, ' ', attr0 );
	    if( cx > x1 ) {
		ScrCursor(hd,SCR_CRS_SETREL, -1, 0 );
		cx--;
	    }
	    upd++;
	    break ;

	  case K_DEL:	    /* Delete char under cursor and shift rest of line */
	    for(y=cy,x=cx; x < x2; x++ ) {
		ScrReadCell(hd, x+1, y, &c, &a);
		ScrWriteCell(hd, x, y, c, a );
	    }
	    ScrWriteCell(hd, x2, y, ' ', attr0 );
	    upd++;
	    break;

	  case K_CK   : /* Ctrl-K und Ctrl-End : */
	  case K_CEND : /* lschen bis Feldende  */
	    for(y=cy, x=cx; x <= x2; x++ )
		ScrWriteCell(hd, x, y, ' ', attr0 );
	    upd++;
	    break;



	  case K_CV:
	  case K_INS :
	    ScrCursor(hd, cursorForm = cursorForm == SCR_CRS_FORM_A ?
				       SCR_CRS_FORM_B : SCR_CRS_FORM_A, 0, 0 );
	    upd++;
	    break;

	  case K_CMD_EDITSTART: /* Feld neu anzeigen ( EditAnfang ) */
	    for( y=y1; y <= y2; y++ )
		for( x=x1 ; x <= x2; x++ ) {
		    ScrReadCell(hd, x, y, &c, NULL );
		    ScrWriteCell(hd, x, y, c, attr0 );
		}
	    upd++;
	    break;

	  case K_CMD_EDITEND: /* Feld neu anzeigen ( EditEnde ) */
	    for( y=y1; y <= y2; y++ )
		for( x=x1 ; x <= x2; x++ ) {
		    ScrReadCell(hd, x, y, &c, NULL );
		    ScrWriteCell(hd, x, y, c, attr );
		}
	    ScrCursor( hd, SCR_CRS_HIDE, 0, 0 );
	    upd++;
	    break;

	  default:
	    if( (keyCode < 32 || keyCode > 255)
	      #if MSDOS
		&& keyCode != '\x15'   /* Paragraphenzeichen auf dem PC */
	      #endif
	      )
		ex++;		       /* leave function */
	    else {
		y= cy;
		if( cursorForm == SCR_CRS_FORM_B ) { /* insert mode */
		    /* shift all to the right */
		    for( x=x2 ; x > cx; x-- ) {
			ScrReadCell(hd, x-1, y, &c, &a );
			ScrWriteCell(hd, x, y, c, a );
		    }
		}
		/* Write this character */
		ScrWriteCell( hd, cx, y,
			      cpsLck ? toupper(keyCode) : keyCode, attr0);
		/* and Cursor 1 to the right */
		if( cx < x2 ) {
		    ScrCursor(hd, SCR_CRS_SETREL, 1, 0 );
		    cx++;
		}
		else if( cy < y2 ) { /* one line down */
		    cx = x1;
		    cy++;
		    ScrCursor(hd, SCR_CRS_SET, cx, cy);
		}
		upd++;
	    }
	    break;
	}

	if( !ex ) {
	    EventClear( eventWord & EVT_CMD ? EVT_CMD : EVT_KBD );
	    if( keyCode == K_CMD_EDITEND )
		ex++;
	}
	if( upd ) {
	    ScrUpdate(hd);
	    upd = 0;
	}
    }

    return 0;
}




int DialogPasteString( int handle, ushort itemId, const char *string )
{
    int cx,cy;		/* Cursor Position */
    int x1, y1, x2, y2;
    int x,y;	      /* helper */
    char c;
    byte a, attr, attr0;
    int hd, cpsLck, keyCode;
    dlgwin_t *dlg;
    dlg_item_t *item;

    dlg = Dialog_getdlgptr(handle);
    item = Dialog_getitmptr(handle,itemId);
    hd = dlg->whd;
    attr = dlg->col[WIN_A_FLD];
    attr0 = dlg->col[WIN_A_FLD0];
    x1 = item->x.field.px;
    x2 = x1 + item->x.field.sx - 1;
    y1 = item->x.field.py;
    y2 = y1 + item->x.field.sy - 1;
    cpsLck = item->x.field.flag.pts == 1;

    ScrGetPos( hd, 1, &cx, &cy );
    if( cx < x1 || cx > x2 || cy < y1 || cy > y2 ) {
	cx=x1;
	cy=y1;
    }

    while( (keyCode = *string++) ) {
	/* shift all to the right */
	for(y=cy, x=x2 ; x > cx; x-- ) {
	    ScrReadCell(hd, x-1, y, &c, &a );
	    ScrWriteCell(hd, x, y, c, a );
	}
	/* Write this character */
	ScrWriteCell( hd, cx, y, cpsLck ? toupper(keyCode) : keyCode, attr0);
	/* and Cursor 1 to the right */
	if( cx < x2 )
	    cx++;
	else if( cy < y2 ) { /* one line down */
	    cx = x1;
	    cy++;
	}
    }
    ScrCursor(hd, SCR_CRS_SET, cx, cy);
    ScrUpdate(hd);

    return 0;
}


/***** bottom of File *****/
