/* [dlgwin1.c wk 3.6.91] Dialog Windows
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * History:
 * 12.07.93 wk	LineWrap in PutStr eingebaut
 * 30.07.93 wk	in DialogPutNStr Returncode DLGE_TRUNC eingebaut
 */

#include <wk/tailor.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/lib.h>
#include <wk/string.h>
#include <wk/scr.h>
#include <wk/keys.h>
#include <wk/rcmgr.h>
#include <wk/swn.h>

#include "dlgwin.h"

/**** constants ***/
#define MAX_DIALOGS 10 /* max # of open Dialogs */

/**** types ******/


/**** globals ****/
static dlgwin_t dialogTbl[MAX_DIALOGS];
static int currentDlg = -1;

/*** local Protos ***/
static int DoClose( dlgwin_t *dlg );
static void PutConstants( dlgwin_t *dlg );

static void AbortScr( int line );
static void AbortDlg( int line, const char *t );

/**** def'd Functions ****/
#define EnterCritical()     /* Dummies*/
#define LeaveCritical()     /* Dummies*/
/**** Global Functions ****/

/*
 * ffnet einen Dialog und gibt einen Handle darauf zurck
 */

int DialogOpen( const char *name )
{
    int handle;
    int n, i, rchd;
    dlgwin_t *dlg;
    dlg_item_t *item;
    byte buf[20 *sizeof(short)+8*6];
    size_t reclen;
    ushort hs, nItems;


    dlg = NULL;
    EnterCritical() ;
    for(handle=0; handle < MAX_DIALOGS ; handle++ )
	if( !dialogTbl[handle].useFlag ) {
	    dlg = dialogTbl + handle;
	    dlg->useFlag++ ;
	    break ;
	}
    LeaveCritical() ;
    if( !dlg )
	AbortDlg(__LINE__,"out of handles");

    /* load Dialog from Resourcefile */
    rchd = RcmLoadResource( name , RC_DLGWIN );
    dlg->txtTbl = RcmTransferDlgWin( rchd );
    nItems = RcmReadDlgWin( rchd, 0, NULL, 0 ); /* reset */
    dlg->item = item = xcalloc( nItems+1 , sizeof( *item ) );
    dlg->lastItemId = 0;
    dlg->curItemId = 0;
    for( n=0; n < nItems; n++, item++ ) {
	if( !(reclen = RcmReadDlgWin( rchd, 1, buf, DIM(buf) )) )
	    AbortDlg(__LINE__,"error in RC");
	switch( *buf ) {
	  case DLG_WINDOW:
	    memcpy( &dlg->px , buf+1, 2 );
	    memcpy( &dlg->py , buf+3, 2 );
	    memcpy( &dlg->sx , buf+5, 2 );
	    memcpy( &dlg->sy , buf+7, 2 );
	    memcpy( dlg->col , buf+9, 16 );
	    item-- ;  /* was not written to item Structure */
	    break;

	  case DLG_TEXT:
	    item->type = DLG_TEXT;
	    item->id = 0;
	    memcpy( &item->x.text.px	, buf+1, 2 );
	    memcpy( &item->x.text.py	, buf+3, 2 );
	    memcpy( &item->x.text.oText , buf+5, 2 );
	    break;

	  case DLG_FIELD:
	    item->type = DLG_FIELD;
	    memcpy( &item->x.field.px	 , buf+1, 2 );
	    memcpy( &item->x.field.py	 , buf+3, 2 );
	    memcpy( &item->x.field.sx	 , buf+5, 2 );
	    memcpy( &item->x.field.sy	 , buf+7, 2 );
	    memcpy( &item->id		 , buf+9, 2 );
	    memcpy( &item->x.field.oText , buf+11, 2 );
	    memcpy( &item->x.field.oHelp , buf+13, 2 );
	    memcpy( &hs 		 , buf+15, 2 );
	    item->x.field.flag.type = hs & 0x0f;
	    item->x.field.flag.pts  = (hs & 0xf0) >> 4;
	    item->x.field.flag.autoRet = hs & 0x0100 ? 1 : 0;
	    item->flg.noEdit	     = hs & 0x0200 ? 1 : 0;
	    if( reclen > 16 ) {
		memcpy( &item->x.field.oMin , buf+17, 2 );
		memcpy( &item->x.field.oMax , buf+19, 2 );
	    }
	    break;

	  case DLG_BUTTON:
	    item->type = DLG_BUTTON;
	    memcpy( &item->id		 , buf+1, 2 );
	    memcpy( &item->x.button.nBtn , buf+3, 2 );
	    memcpy( &item->x.button.val  , buf+5, 2 );
	    memcpy( &item->x.button.oHelp, buf+7, 2 );
	    item->x.button.btn = xmalloc( item->x.button.nBtn *
					     sizeof(dlg_text_t) );
	    for(i=0; i < item->x.button.nBtn; i++ ) {
		memcpy( &item->x.button.btn[i].px   , buf+ 9+(i*6), 2 );
		memcpy( &item->x.button.btn[i].py   , buf+11+(i*6), 2 );
		memcpy( &item->x.button.btn[i].oText, buf+13+(i*6), 2 );
	    }
	    break;

	  case DLG_LSTBOX:
	    item->type = DLG_LSTBOX;
	    memcpy( &item->x.lstbox.px	  , buf+1, 2 );
	    memcpy( &item->x.lstbox.py	  , buf+3, 2 );
	    memcpy( &item->x.lstbox.sx	  , buf+5, 2 );
	    memcpy( &item->x.lstbox.sy	  , buf+7, 2 );
	    memcpy( &item->id		 , buf+9, 2 );
	    memcpy( &item->x.lstbox.oHelp , buf+11, 2 );
	    memcpy( &hs 		 , buf+13, 2 );
	    item->x.lstbox.flag.noFrm  = hs & 1 ? 1:0;
	    item->x.lstbox.flag.selCol = hs & 2 ? 1:0;
	    break;

	  default:
	    Fatal("invalid Type %d", *buf );
	    AbortDlg(__LINE__,"error in RC");

	}
    }
    RcmFreeResource( rchd );

    if( ScrOpen( &dlg->whd, 0, dlg->px, dlg->py, dlg->sx, dlg->sy,
		 dlg->col[WIN_A_WIN], SCR_STYLE_FRAME, SCR_MODE_HIDDEN ) )
	AbortScr(__LINE__);
    PutConstants( dlg );

    return handle;
}



/*
 * Eine Dialog wieder schlieen und damit alle Resource freigeben
 * Returns: 0
 */

int DialogClose( int handle )
{
    dlgwin_t *dlg;

    dlg = Dialog_getdlgptr(handle);
    if( handle == currentDlg )
	currentDlg = -1;
    DoClose( dlg );
    ScrUpdate(0);

    return 0;
}


/* [Internal]
 * Alle Dialog schlieen
 */

void Dialog_closeall()
{
    int i;

    for(i=0; i < MAX_DIALOGS; i++ ) {
	if( i == currentDlg )
	    currentDlg = -1;
	if( dialogTbl[i].useFlag )
	    DoClose( dialogTbl + i );
    }
}


/*
 * Eine Dialog wieder schlieen und damit alle Resource freigeben
 * Returns: 0
 */

static int
DoClose( dlgwin_t *dlg )
{
    dlg_item_t *item;

    if( !dlg )
	return 0;
    ScrClose(dlg->whd);
    free( (char *)dlg->txtTbl );   /* <const char *> hier freigeben */
    for( item=dlg->item; item->type; item++ )
	if( item->type == DLG_BUTTON )
	    free( item->x.button.btn );
    free( dlg->item );
    EnterCritical();
    dlg->useFlag = 0;
    LeaveCritical();
    return 0;
}




/*
 * Einen Dialog anzeigen, d.h das Window wie es ist sichtbar machen.
 * Returns 0;
 */

int DialogShow( int handle )
{
    dlgwin_t *dlg;

    dlg = Dialog_getdlgptr(handle);
    if( ScrShow( dlg->whd ) )
	AbortScr(__LINE__);
    ScrUpdate(dlg->whd);
    return 0;
}


/****************
 * Bestimmen, ob das Window den Focus hat.
 * Der Focus hat zur zeit einfach immer das Window, welches
 * am obersten liegt (Z-Order 0)
 * Returns: False, hat keinen Focus (mit DialogShow() kann es den Focus
 *				     erhalten)
 *	    True, hat den Focus
 */

int DialogHasFocus( int handle )
{
    return ScrHasFocus( Dialog_getdlgptr( handle )->whd );
}






/*
 * Einen Dialog verstecken, d.h. das Window unsichtbar machen.
 * Returns 0;
 */

int DialogHide( int handle )
{
    dlgwin_t *dlg;

    dlg = Dialog_getdlgptr(handle);
    if( ScrHide( dlg->whd ) )
	AbortScr(__LINE__);
    ScrUpdate(0);
    return 0;
}


/*
 * Ein Item Editieren.
 * Parameter sind : itemId = ID des Items
 *		    keyCode = TastaturCode
 * Editieren eines Items:
 * Es wird jeweils ein KeyCode bergeben, die entsprechende
 * EditFunktion ( je nach ItemType ) entscheidet selbst, ob
 * sie diesen Tastencode verwendet und eine entsprechende Editierung
 * vornimmt. Anhand des ReturnCodes kann die Anwendung die Verwendung
 * des angegebenen KeyCodes prfen. Fr alle Items vom Typ DLG_FIELD
 * wird nur ein Cursor gefhrt, bei Feldwechsel wird folgich
 * immer am Feldanfang angefangen.
 * Besondere Commandos fr editfunktionen:
 * K_CMD_EDITSTART Editieranfang; z.B. bei ALFA am Feldanfang anfangen.
 * K_CMD_EDITEND    Editierende; z.B. das Feld wieder auf Original Attribut
 * Returns: 0		= Okay
 *	    DLGE_INVTYP = unbekannter ItemTyp
 *	    DLGE_NOITEM = unbekanntes Item
 */

int DialogEdit( int handle, ushort itemId )
{
    dlgwin_t *dlg;
    dlg_item_t *item;
    int ret=0;

    dlg = Dialog_getdlgptr(handle);
    for( item=dlg->item; item->type; item++ )
	if( item->id == itemId ) { /* okay: found */
	    if( item->type == DLG_FIELD ) {
		if( item->flg.noEdit )
		    return DLGE_NOEDIT;
		if( item->x.field.flag.type == DLG_FIELD_ALFA )
		    ret = Dialog_edt01( dlg, item );
		return ret;
	    }
	    else if( item->type == DLG_BUTTON )
		return Dialog_edt10(dlg, &item->x.button);
	    else if( item->type == DLG_LSTBOX )
		return Dialog_edt20(dlg, &item->x.lstbox, 1);
	    return DLGE_INVTYP;
	}
    return DLGE_NOITEM;
}




/*
 * Einen Wert fr ein Item setzen; hier: String
 * Parameter sind : itemId = ID des Items
 *		    string  = String
 * Eine entsprechende Typwandlung findet statt.
 * Returns: 0 = Okay
 *	   !0 = Fehler ( Item not found )
 */

int DialogPutStr( int handle, ushort itemId, const char *string )
{
    dlgwin_t *dlg;
    dlg_item_t *item;
    int whd;
    short px,py,x,y,sx,sy;
    const char *p;
    byte attr;

    dlg = Dialog_getdlgptr(handle);
    whd = dlg->whd;
    attr = dlg->col[WIN_A_FLD];
    for( item=dlg->item; item->type; item++ )
	if( item->id == itemId ) { /* okay: found */
	    if( item->type == DLG_FIELD ) {
		if( item->x.field.flag.type == DLG_FIELD_ALFA ) {
		    px = item->x.field.px;
		    py = item->x.field.py;
		    sx = item->x.field.sx;
		    sy = item->x.field.sy;
		    for( p=string,y=x=0; *p && y < sy ; y++)
			for( x=0; *p && x < sx ; x++)
			    if( *p == '\n' ) {
				p++;
				break; /* turn over to next line */
			    }
			    else
				ScrWriteCell(whd, px+x, py+y, *p++, attr);
		    for( ; y < sy ; y++, x=0 )
			for( ; x < sx ; x++)
			    ScrWriteCell(whd, px+x, py+y, ' ', attr);
		}
		else {
		    /* Konvertierungen */
		}
		return 0;
	    }
	    return DLGE_INVTYP;
	}
    return DLGE_NOITEM;
}

/****************
 * Wie DialogPutStr() aber mit laengenangabe
 * ( kann Fehler DLGE_TRUNC zurueckgeben falls dr text abgeschniten wurde )
 */

int DialogPutNStr( int handle, ushort itemId, const char *string, size_t n )
{
    dlgwin_t *dlg;
    dlg_item_t *item;
    int whd;
    short px,py,x,y,sx,sy;
    const char *p;
    byte attr;
    int trunc;

    trunc = 0;
    dlg = Dialog_getdlgptr(handle);
    whd = dlg->whd;
    attr = dlg->col[WIN_A_FLD];
    for( item=dlg->item; item->type; item++ )
	if( item->id == itemId ) { /* okay: found */
	    if( item->type == DLG_FIELD ) {
		if( item->x.field.flag.type == DLG_FIELD_ALFA ) {
		    px = item->x.field.px;
		    py = item->x.field.py;
		    sx = item->x.field.sx;
		    sy = item->x.field.sy;
		    for( p=string,y=x=0; n && y < sy ; y++)
			for( x=0; n && x < sx ; x++)
			    if( *p == '\n' ) {
				p++;
				n--;
				break; /* turn over to next line */
			    }
			    else  {
				ScrWriteCell(whd, px+x, py+y, *p++, attr);
				n--;
			    }
		    trunc = 1;
		    for( ; y < sy ; y++, x=0 )
			for( ; x < sx ; x++) {
			    ScrWriteCell(whd, px+x, py+y, ' ', attr);
			    trunc = 0;
			}
		}
		else {
		    /* Konvertierungen */
		}
		return trunc ? DLGE_TRUNC : 0;
	    }
	    return DLGE_INVTYP;
	}
    return DLGE_NOITEM;
}

/*
 * Einen Wert von einem Item holen; hier: String
 * Parameter sind : itemId = ID des Items
 *		    buffer  = to hold String
 *		    bufSize = Size of Buffer
 * Eine entsprechende Typwandlung findet statt.
 * Blanks am Ende werden nicht mitkopiert.
 * Returns: 0 = Okay
 *	   !0 = Fehler ( Item not found )
 */

int DialogGetStr( int handle, ushort itemId, char *buffer, size_t n)
{
    dlgwin_t *dlg;
    dlg_item_t *item;
    int whd;
    short px,py,x,y,sx,sy;
    char *p, *lastp;
    size_t lastn=0; /* controlled by lastp */

    xassert( n );
    dlg = Dialog_getdlgptr(handle);
    if( !itemId )
	itemId = dlg->curItemId;
    whd = dlg->whd;
    for( item=dlg->item; item->type; item++ )
	if( item->id == itemId ) { /* okay: found */
	    if( item->type == DLG_FIELD ) {
		if( item->x.field.flag.type == DLG_FIELD_ALFA ) {
		    px = item->x.field.px;
		    py = item->x.field.py;
		    sx = item->x.field.sx;
		    sy = item->x.field.sy;
		    n--;  /* platz fuer 0 freihalten */
		    for( p=buffer,y=0; n && y < sy ; y++) {
			lastp = NULL;
			for( x=0; n && x < sx ; x++) {
			    ScrReadCell(whd, px+x, py+y, p, NULL);
			    if( !*p )
				*p = ' ';
			    if( *p == ' ' ) {
				if( !lastp ) {
				    lastp = p;
				    lastn = n;
				}
			    }
			    else
				lastp = NULL;
			    p++;
			    n--;
			}
			if( lastp ) {
			    p = lastp;
			    n = lastn;
			}
			if( n ) {
			    *p++ = '\n';
			    n--;
			}
		    }
		    *p = 0;
		    StripTrailingWSpaces(buffer);
		}
		else {
		    /* Konvertierungen */
		}
		return 0;
	    }
	    return DLGE_INVTYP;
	}
    return DLGE_NOITEM;
}



/*
 * Einen Wert fr ein Item setzen; hier: Integer
 * Parameter sind : itemId = ID des Items
 *		    value  = zu setzender Wert
 * Eine entsprechende Typwandlung findet statt.
 * z.Z. sind nur Buttons implementiert
 * Returns: 0 = Okay
 *	   !0 = Fehler ( Item not found )
 */

int DialogPutInt( int handle, ushort itemId, int value )
{
    dlgwin_t *dlg;
    dlg_item_t *item;
    int whd, err;

    err = 0;
    dlg = Dialog_getdlgptr(handle);
    if( !itemId )
	itemId = dlg->curItemId;
    whd = dlg->whd;
    for( item=dlg->item; item->type; item++ )
	if( item->id == itemId ) { /* okay: found */
	    if( item->type == DLG_FIELD ) {
	    }
	    else if( item->type == DLG_BUTTON ) {
		if( item->x.button.nBtn == 1 )
		    item->x.button.val = value ? 0 : 1;
		else if( value >= 0 && value < item->x.button.nBtn )
		    item->x.button.val = value;
		else
		    err = DLGE_INVVAL;
		if( !err )  /* Write Button to Screen */
		    err = Dialog_put10(dlg, &item->x.button, 0);
		return err;
	    }
	    return DLGE_INVTYP;
	}
    return DLGE_NOITEM;
}


/*
 * Einen Wert von einem Item hole; hier: Integer
 * Parameter sind : itemId = ID des Items
 *		    value  = Pointer zu Integer Variable
 * Eine entsprechende Typwandlung findet statt.
 * z.Z. sind nur Buttons implementiert
 * und ListBox
 * Returns: ErrorCode
 */

int DialogGetInt( int handle, ushort itemId, int *value )
{
    dlgwin_t *dlg;
    dlg_item_t *item;
    int whd;

    dlg = Dialog_getdlgptr(handle);
    if( !itemId )
	itemId = dlg->curItemId;
    whd = dlg->whd;
    for( item=dlg->item; item->type; item++ )
	if( item->id == itemId ) { /* okay: found */
	    if( item->type == DLG_FIELD ) {
	    }
	    else if( item->type == DLG_BUTTON ) {
		*value = item->x.button.val & 0xff ;
		return 0;
	    }
	    else if( item->type == DLG_LSTBOX ) {
		*value = item->x.lstbox.pos ;
		return 0;
	    }
	    return DLGE_INVTYP;

	}
    return DLGE_NOITEM;
}


/*
 * Einen Wert fr ein Item setzen; hier: Array of Strings
 * Parameter sind : itemId = ID des Items
 *		    text   = Pointer Array
 *		    ntext  = # of Pointers
 *		    pos    = default Cursor
 * Eine entsprechende Typwandlung findet statt.
 * Returns: 0 = Okay
 *	   !0 = Fehler ( Item not found )
 */

int DialogPutStrAry( int handle, ushort itemId,
		     char **text, int ntext, int pos )
{
    dlgwin_t *dlg;
    dlg_item_t *item;
    int whd, err;

    err = 0;
    dlg = Dialog_getdlgptr(handle);
    if( !itemId )
	itemId = dlg->curItemId;
    whd = dlg->whd;
    for( item=dlg->item; item->type; item++ )
	if( item->id == itemId ) { /* okay: found */
	    if( item->type == DLG_LSTBOX ) {
		item->x.lstbox.text  = text;
		item->x.lstbox.nstrgs= ntext;
		item->x.lstbox.pos   = pos;
		item->x.lstbox.wpos  = 0;
		if( !err )  /* Write Box to Screen */
		    err = Dialog_edt20(dlg, &item->x.lstbox, 0 );
		return err;
	    }
	    return DLGE_INVTYP;
	}
    return DLGE_NOITEM;
}


/*
 * Look for Id under Mouse Cursor.
 * Parms: Dialog Handle
 * Returns: 0 = No Item under Mouse Cursor
 *	    Id = Id of item under Cursor
 */

ushort DialogMs2Id( int handle )
{
    dlgwin_t *dlg;
    dlg_item_t *item;
    int i,x,y, sx;
    ushort itemId = 0;
    const char *textTbl;

    dlg = Dialog_getdlgptr(handle);
    itemId = 0;

    textTbl = dlg->txtTbl;
    ScrMsStat( &i, &x, &y );
    if( i == dlg->whd ) {
	for( item=dlg->item; item->type && !itemId ; item++ )
	    if( item->type == DLG_FIELD ) {
		if( x >= item->x.field.px &&
		    x <  item->x.field.px + item->x.field.sx &&
		    y >= item->x.field.py &&
		    y <  item->x.field.py + item->x.field.sy  )
		    itemId = item->id ;
	    }
	    else if( item->type == DLG_BUTTON ) {
		for(i=0; i < item->x.button.nBtn; i++ ) {
		    sx = strlen( textTbl + item->x.button.btn[i].oText );
		    if( x >= item->x.button.btn[i].px &&
			x <= item->x.button.btn[i].px+sx &&
			y == item->x.button.btn[i].py  )  {
			itemId = item->id ;
			item->x.button.val =
			  (i<<8) | (item->x.button.val & 0xff); /*pos merken*/
			break; /* loop over Buttons */
		    }
		}
	    }
	    else if( item->type == DLG_LSTBOX ) {
		if( x >= item->x.lstbox.px-1 &&
		    x <= item->x.lstbox.px + item->x.lstbox.sx &&
		    y >= item->x.lstbox.py-1 &&
		    y <= item->x.lstbox.py + item->x.lstbox.sy	)
		    itemId = item->id ;
	    }
    }

    return itemId;
}


ushort DialogCurItem( int handle )
{
    return Dialog_getdlgptr(handle)->curItemId;
}

int DialogCurDlg()
{
    return currentDlg;
}


void DialogSetFocus( int handle, ushort itemId )
{
    if( handle != -1 ) {
	xassert( handle >= 0 && handle < MAX_DIALOGS );
	currentDlg = handle;
    }
    if( itemId )
	Dialog_getdlgptr(-1)->curItemId = itemId;
    DialogShow( -1 );
}



/*
 * Get type of Item ( DLG_.... )
 * Returns: Type of Item
 *	  or 0 if item not found
 */

ushort DialogItemType( int handle, ushort itemId )
{
    dlg_item_t *item;

    if( !itemId )
	itemId = Dialog_getdlgptr(handle)->curItemId;
    for( item=Dialog_getdlgptr(handle)->item; item->type; item++ )
	if( item->id == itemId )  /* okay: found */
	    return item->type;
    return 0;
}



/*
 * Set EnableFlag of Item to true or false
 * mode: 0 = disable
 *	 1 = enable
 * Returns: old Enablestate ( true == enabled )
 */

int DialogEnDsItem( int handle, ushort itemId, int mode )
{
    dlg_item_t *item;
    int oldState=0 ;

    xassert( handle >= 0 && handle < MAX_DIALOGS );
    for( item=Dialog_getdlgptr(handle)->item; item->type; item++ )
	if( item->id == itemId ) {  /* okay: found */
	    oldState = !item->flg.disabled ;
	    item->flg.disabled = mode ? 0 : 1;
	    break;
	}
    return oldState;
}



/*
 * Retrieves the first/netx/previous itemId, the sequence of the
 * Items is defined by the Sequence in the Resource.
 * only enabled Items will be retrieved
 * mode : -1 = Get previous Item
 *	   0 = Get first Item ( itemId unused )
 *	   1 = Get next Item
 *	  99 = Get Previous Item ( only items where edit is allowed )
 *	 100 = Get first	 ( only items where edit is allowed )
 *	 101 = Get next Item	 ( only items where edit is allowed )
 * Returns: ItemId or 0 if no more Items
 */

ushort DialogWalkItem( int handle, ushort itemId, int mode )
{
    dlg_item_t *item, *firstItem;
    ushort newId;
    int edt;

    if( edt = mode >= 99 )
	mode -= 100;
    newId = 0;
    firstItem = item = Dialog_getdlgptr(handle)->item;
    if( mode ) {
	for(; item->type; item++ )
	    if( item->id == itemId )
		break;
	if( !item->type )
	    ;		/* old Id not found, so there are no more ids */
	else if( mode < 1 ) {	 /* get previous */
	    for( --item; item >= firstItem; item-- )
		if( item->type != DLG_TEXT && !item->flg.disabled &&
		    !( item->flg.noEdit && edt ) ) {
		    newId = item->id;
		    break;
		}
	    if( !newId ) {  /* again from last */
		/* whats the last */
		for(item=firstItem; item->type; item++ )
		    ;
		/* we can assume that there is a min. of 1 item */
		for(--item; item >= firstItem && item->id != itemId ; item-- )
		    if( item->type != DLG_TEXT && !item->flg.disabled &&
					!( item->flg.noEdit && edt )  ) {
			newId = item->id;
			break;
		    }
	    }
	}
	else {	/* get next Item */
	    for( ++item; item->type; item++ )
		if( item->type != DLG_TEXT && !item->flg.disabled &&
					!( item->flg.noEdit && edt )) {
		    newId = item->id;
		    break;
		}
	    if( !newId ) /* again from start */
		for( item=firstItem; item->type && item->id != itemId; item++)
		    if( item->type != DLG_TEXT && !item->flg.disabled &&
					!( item->flg.noEdit && edt )	) {
			newId = item->id;
			break;
		    }

	}
    }
    else {  /* get first item */
	for( ; item->type; item++ )
	    if( item->type != DLG_TEXT && !item->flg.disabled &&
				   !( item->flg.noEdit && edt )  ) {
		newId = item->id;
		break;
	    }
    }


    return newId;
}



/* [Internal]
 *  Get Pointer to Dialog Structure of	handle
 */

dlgwin_t *Dialog_getdlgptr( int handle )
{
    dlgwin_t *dlg ;

    if( handle == -1 )
	handle = currentDlg;

    xassert( handle >= 0 && handle < MAX_DIALOGS );
    dlg = dialogTbl + handle;
    xassert( dlg->useFlag );

    return dlg;
}


/* [Internal]
 *  Get Pointer to Item in Dialog Structure of	handle
 */

dlg_item_t *Dialog_getitmptr( int handle, ushort itemId )
{
    dlgwin_t *dlg ;
    dlg_item_t *item;

    dlg = Dialog_getdlgptr(handle);
    if( !itemId )
	itemId = dlg->curItemId;
    for( item=dlg->item; item->type; item++ )
	if( item->id == itemId )
	    break;
    return item;
}



/******* Local Functions *********/


/*
 * Die Konstanten ins Window schreiben.
 */

static void PutConstants( dlgwin_t *dlg )
{
    dlg_item_t *item;
    const char *t;
    short x,y;
    int whd;
    byte attr;

    whd = dlg->whd;
    attr = dlg->col[WIN_A_STD];
    for( item=dlg->item; item->type; item++ )
	if( item->type == DLG_TEXT ) {
	    x = item->x.text.px;
	    y = item->x.text.py;
	    for( t = dlg->txtTbl + item->x.text.oText; *t; t++ )
		ScrWriteCell(whd, x++, y, *t, attr);
	}
	else if( item->type == DLG_BUTTON )
	    Dialog_put10(dlg, &item->x.button, 0 );
	else if( item->type == DLG_LSTBOX )
	    Dialog_put20(dlg, &item->x.lstbox );

}



/*
 * Abbruch des Systems nach ScreenError
 */

static void AbortScr( int line )
{
    Fatal("%s[%d]: ScreenError: %s", __FILE__ , line, ScrErrorText(-1) );
    exit(4);
}

/*
 * Abbruch des Systems nach DialogError
 */

static void AbortDlg( int line, const char *t )
{
    Fatal("%s[%d]: %s", __FILE__ , line, t );
    exit(4);
}


/***** bottom of File *****/
