/* [dlgwin0.c wk 11.6.91] Dialog Windows (High Level )
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * $Header: /usr/src/master/libs/wkswn/dlgwin0.c,v 1.4 1997/01/07 15:17:58 wk Exp $
 *
 */

#include <wk/tailor.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/lib.h>
#include <wk/scr.h>
#include <wk/event.h>
#include <wk/cua.h>

#include "dlgwin.h"

/**** constants ***/
/**** types ******/
/**** globals ****/
/*** local Protos ***/
/**** def'd Functions ****/
/**** Global Functions ****/


/*
 * Dialog Sequentiell Edit
 * Editieren mehrer Items mit Wechsel zwichen den Items eines Dialogs
 * durch ( TAB , BACKTAB und Mouse Click )
 * An Inital Edit start can be forced by using an itemId of 0.
 * Parms:
 *  handle   = Dialog Handle
 *  itemId   = Pointer auf variable mit dem aktuelle ( ersten Item )
 *	       oder NULL um die interne Verwatung zu nutzen
 * Returns: ErrorCode
 */

int DialogSeqEdit( int handle, ushort *itemIdArg )
{
    dlgwin_t *dlg;
    dlg_item_t *item;
    ushort newId=0, id, itemId; /* newid is controlled by idchg */
    int ex, idchg, err, keyCode;
    unsigned eventWord, bstate=0;

    dlg = Dialog_getdlgptr( handle );
    itemId = itemIdArg? *itemIdArg : dlg->curItemId;


    /* Aktuelles Element bestimmen */
    idchg = 0;
    if( !itemId ) {
	newId = DialogWalkItem( handle, 0, 100 ); /* get first item */
	if( newId ) { /* use only if there is one */
	    itemId = newId;
	    idchg++;
	}
    }

    /* Und verarbeiten */
    for(err=ex=0; !ex && !err; ) {
	if( idchg ) {
	    idchg = 0;
	    if( dlg->lastItemId ) {
		EventPutCmd( K_CMD_EDITEND );
		DialogEdit( handle, dlg->lastItemId ); /* Edit end */
	    }
	    dlg->lastItemId = newId ;
	    itemId = newId;
	    EventPutCmd( K_CMD_EDITSTART );
	}

	/* Sichherstellen das der Dialog auch sichtbar ist - ansonsten */
	/* sind Eingaben wohl sinnlos */
	if( !DialogHasFocus( handle ) )
	    DialogShow( handle );

	err = DialogEdit( handle, itemId ); /* Edit */

	eventWord = EventWait();
	if( eventWord & EVT_CMD )
	    keyCode = EventGetCmd();
	else if( eventWord & EVT_KBD )
	    keyCode = EventGetKbd();
	else if( eventWord & EVT_MSLB ) {
	    int dmy1, dmy2;
	    bstate = EventGetMs( &dmy1, &dmy2 );
	    keyCode = K_CMD_USER_1;
	}
	else {
	    keyCode = K_CMD_DUMMY_0;
	    ex++;
	}

	if( keyCode == K_CMD_DUMMY_0 )
	    ;
	else if( keyCode == K_CMD_USER_1 ) {
	    id = DialogMs2Id(handle);
	    if( id ) {
		if( id != itemId ) {
		    item =  Dialog_getitmptr( handle, id );
		    if( !item->flg.disabled && !item->flg.noEdit ) {
			newId = id;
			idchg++;
		    }
		    EventClear( EVT_MSLB );
		}
		else {
		    if( bstate & EVT_MS_BT_LD )
			ex++;
		    else
			EventClear( EVT_MSLB );
		}
	    }
	}
	else if( keyCode == K_TAB ) { /* Switch to next Item */
	    newId = DialogWalkItem( handle, itemId, 101 );
	    if( newId )   /* use only if there is one */
		idchg++;
	    EventClear( EVT_KBD );
	}
	else if( keyCode == K_BACKTAB ) { /* Switch to prev Item */
	    newId = DialogWalkItem( handle, itemId, 99 );
	    if( newId )    /* use only if there is one */
		idchg++;
	    EventClear( EVT_KBD );
	}
	else if( keyCode == K_CMD_EDITSTART) { /* Start EdiT with first Item */
	    newId = DialogWalkItem( handle, 0, 100 );
	    if( newId )    /* use only if there is one */
		idchg++;
	    EventClear( EVT_CMD );
	}
	else if( keyCode == K_CMD_EDITEND ) { /* force End of edit */
	    dlg = Dialog_getdlgptr( handle );
	    if( dlg->lastItemId )
		DialogEdit( handle, dlg->lastItemId); /* Edit end */
	    else
		EventClear( EVT_CMD );
	    dlg->lastItemId = 0 ;
	    itemId = 0;
	    ex++;
	}
	else
	    ex++;

    }

    if( err )
	Fatal("DialogSeqEdit: Err=%d", err );
    dlg->curItemId = itemId;
    if( itemIdArg )
	*itemIdArg = itemId;
    return 0 ;
}


/*
 * Die Funktion sucht zu einem gegebenen Item den HelpKey heraus.
 * Returns: Pointer auf den HelpKey
 *	or NULL if there is no HelpKey
 */

const char *DialogHelpKey( int handle, ushort itemId )
{
    dlg_item_t *item;
    dlgwin_t *dlg;
    ushort off;

    off = 0;
    dlg = Dialog_getdlgptr(handle);
    for( item = dlg->item; item->type; item++ )
	if( item->id == itemId ) {  /* okay: found */
	    switch( item->type ) {
	      case DLG_FIELD:	off = item->x.field.oHelp; break;
	      case DLG_BUTTON:	off = item->x.button.oHelp; break;
	      case DLG_LSTBOX:	off = item->x.lstbox.oHelp; break;
	    }
	    break;
	}

    return off ? dlg->txtTbl+off : NULL;
}


/***** bottom of File *****/
