/* [dlgwin.h wk ] Defintions for dialogWindow
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 *  This file is part of WkCUA.
 *
 *  WkCUA is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkCUA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


/***** constants ********/
	   /* index in die Attribute table */
#define WIN_A_WIN   0	   /* 3 Window:   Wei auf Blau */
#define WIN_A_STD   1	   /* 2 Standard: Grau auf Blau */
#define WIN_A_FLD   2	   /* 3 Field:	    Wei auf Blau */
#define WIN_A_FLD0  3	   /* 6 Field Edit: Wei auf Trkis */
#define WIN_A_BTN   4	   /* 2 Button:      Grau auf Blau  */
#define WIN_A_BTN0  5	   /* 6 Button Edit: Wei auf Trkis */
#define WIN_A_BTN1  6	   /* 3 Button On:   Wei auf Blau */
#define WIN_A_BTN2  7	   /* 4 Button MarkChar: Gelb auf Blau */
#define WIN_A_SEL   8	   /* 1 Selected: Wei auf Schwarz */
#define WIN_A_MRK   9	   /* 7 MarkChar: Gelb auf Trkis */
#define WIN_A_X10  10	   /* reserviert */
#define WIN_A_X11  11	   /* reserviert */
#define WIN_A_X12  12	   /* reserviert */
#define WIN_A_X13  13	   /* reserviert */
#define WIN_A_X14  14	   /* reserviert */
#define WIN_A_X15  15	   /* reserviert */

/**** types *************/

typedef struct {
	short px,py;	    /* Position in the Window */
	ushort oText;	    /* Offset into TextTable */
    } dlg_text_t;	    /* type for DLG_TEXT */

typedef struct {
	short px,py;	    /* Position in the Window */
	short sx,sy;	    /* Size of field */
	ushort oText;	    /* Offset into TextTable for def. Value */
	ushort oHelp;	    /* offset of helpkey */
	struct {
	    unsigned type:4;	/* type of field (DLG_FIELD_...) */
	    unsigned pts:4;	/* FIX: NKS, ALFA: 1=capslock. FLOAT: n/a*/
	    unsigned autoRet:1; /* Auto return */
	} flag;
	ushort oMin;	    /* Offset to string with max. Value */
	ushort oMax;	    /* Offset to string with max. Value */
    } dlg_field_t;	    /* type for DLG_FIELD */


typedef struct {
	short nBtn;	    /* number of buttons; > 1 means Radio Buttons */
	ushort val;	    /* Value of Button; radio Button: index into */
			    /* Button Array, sonst Value true or false	 */
			    /* Wert ist nur im LSB, MSB intern */
	ushort oHelp;	    /* Helpkey of Button */
	dlg_text_t *btn;    /* dynamic Button array */
			    /* btn.oText==0 : Standard Check Button */
    } dlg_button_t;	    /* type for DLG_BUTTON */

typedef struct {
	short px,py;	    /* Position in the Window */
	short sx,sy;	    /* Size of Box */
	ushort oHelp;	    /* offset of helpkey */
	char **text;	    /* Save pointer to Text Array here */
	int nstrgs;	    /* # of Strings in textarray */
	int pos;	    /* actual Cursor Position */
	int wpos;	    /* actual Window Position of Cursor */
	struct {
	    int noFrm:1;    /* no Frame */
	    int selCol:1;   /* use an array with an select column */
	    int res:7;	    /* fill up to 2 bytes */
	} flag;
    } dlg_lstbox_t;	    /* type for DLG_LSTBOX */

typedef struct {
	ushort	type;	    /* type of item ( DLG_... ); 0 = end of array */
	ushort id;	    /* ID of this Item; 0 = no Id ( e.g. DLG_TEXT ) */
	union {
	    dlg_text_t	text;
	    dlg_field_t field;
	    dlg_button_t button;
	    dlg_lstbox_t lstbox;
	} x;
	struct {
	    int disabled:1; /* for internal use */
	    int noEdit:1;   /* edit not allowed */
	    int dmy:7;	    /* force use of min. 2 bytes */
	} flg;
    } dlg_item_t;




typedef struct {
	int useFlag;	    /* true if slot in use */
	short  px,py;	    /* Position of Window in PS */
	ushort sx,sy;	    /* Size of Window */
	int whd;	    /* Handle of the Window */
	byte col[16];	    /* colors table of window */
	const char *txtTbl; /* TextTable */
	dlg_item_t *item;   /* pointer to item Array */
	ushort lastItemId;  /* internal for SeqEdit */
	ushort curItemId;   /* internal for SeqEdit */
    } dlgwin_t; 	    /* Parameters of the Window */

/**** Internal Protos ******/
void Dialog_closeall(void);
dlgwin_t *Dialog_getdlgptr( int handle );
dlg_item_t *Dialog_getitmptr( int handle, ushort itemId );

int Dialog_edt01( dlgwin_t*, dlg_item_t *); /* Alfa */
int Dialog_put10( dlgwin_t*, dlg_button_t *,int);
int Dialog_edt10( dlgwin_t*, dlg_button_t *);

int Dialog_put20( dlgwin_t*, dlg_lstbox_t *);
int Dialog_edt20( dlgwin_t*, dlg_lstbox_t *, int);


/**** end header ***/
