/* [dlgsig.c wk 15.6.91] Dialog Windows (Signal handling)
 *	Copyright (c) 1991 by Werner Koch (dd9jn)
 * $Header: /usr/src/master/libs/wkswn/dlgsig.c,v 1.2 1996/09/10 12:24:40 wk Exp $
 */



#include <wk/tailor.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <signal.h>
#include <wk/lib.h>

#if MSDOS
#include <int.h>
#include <dos.h>
#include <bios.h>
#include <wk/dos.h>
#endif
#include <wk/scr.h>
#include <wk/keys.h>
#include <wk/cua.h>
#include <wk/event.h>

#include "dlgwin.h"

/**** constants ***/

#define DUMMY_MODULE 1 /* this is a dummy module */


/**** types ******/
/**** globals ****/
#ifndef DUMMY_MODULE
static int hdDlgAb, hdDlgRtAb, hdDlgCnTm;
static char *sigName[] = {
                "Abort",
                "Floating point error",
                "Illegal instruction",
                "Interrupt",
                "Segment violation",
                "Terminate"
			   } ;
static char textBuffer[100+1] ;
static volatile int sigintSentinel;

#if MSDOS
static char *hErrNames[] = {
     "Write protected",
     "Unkown device",
     "Drive not ready",
     "Unkown command",
     "CRC error in data",
     "Invalid DRSL",
     "Positioning error",
     "Unkown media type",
     "Sector not found",
     "Out of paper",
     "Write error",
     "Read error",
     "General error"  } ;

static int int1bIntercepted;	  /* flag for Cleanup */
#endif

/*** local Protos ***/
static void LoadDialogs(void);
static void CtrlBreakHandler(int);
#if MSDOS
static int oldDosCtrlBreakFlag;
static int Int1B_Monitor( struct INT_DATA *pd );
static int Int21_Monitor( struct INT_DATA *pd );
static int Int24_Monitor( struct INT_DATA *pd );
static int CritErrHandler( int drive, int regAX, int errcode );
#endif
static void AbortHandler(int);
#endif
static void Cleanup(void *);

/**** def'd Functions ****/
/**** Global Functions ****/

#ifdef DOCUMENTATION
@Summary DialogSigInit
 #include <wk/cua.h>

 void DialogSigInit(void);
@Description
 This functions installs some Signal handlers:
 We need the these Resource:
    ..
@Notes
 Installed Signal handlers:
    SIGINT ( DOS-CtrlBreak )
	Will open a dialog to ask for Programm termination
    Dos Critical error Handler:
	Will open a dialog to get user response
	A return to DOS with ABORT is not possible, due to the fact
	that there will be no possibility to terminate the program
	in a normal way ( via exit )
    SIGABRT
	Programm will be terminated via exit(6) after a Message

#endif /*DOCUMENTATION*/

void DialogSigInit()
{
#ifdef DUMMY_MODULE
    AddCleanUp( Cleanup, NULL );
    return;
#else
    int err;

    err = 0;
    AddCleanUp( Cleanup, NULL );
    LoadDialogs();

  #if MSDOS
    oldDosCtrlBreakFlag = dos_get_ctrl_break();
    int_setvector( 0x23, FP_OFF( Dummy8086IRET ), FP_SEG( Dummy8086IRET ));
    int_intercept( 0x1b, Int1B_Monitor, 0 );
    int_intercept( 0x21, Int21_Monitor, 0 );
    int1bIntercepted = 1;
    if( _osmajor >= 3 ) /* will only work with DOS >= 3.00 */
	int_intercept( 0x24, Int24_Monitor, 2048); /* will be restored by DOS*/
  #endif

    if( signal(SIGINT, CtrlBreakHandler) == SIG_ERR )
	err = 1;
    else if( signal(SIGABRT, AbortHandler) == SIG_ERR )
	err = 2;
    else if( signal(SIGFPE, AbortHandler) == SIG_ERR )
	err = 3;
    else if( signal(SIGILL, AbortHandler) == SIG_ERR )
	err = 4;
    else if( signal(SIGSEGV, AbortHandler) == SIG_ERR )
	err = 5;
    else if( signal(SIGTERM, AbortHandler) == SIG_ERR )
	err = 6;
    if( err )
        Bug("Error setting Signal (%d)", err );
#endif

}


#ifndef DUMMY_MODULE

/*
 * Alle bentigten Dialog laden
 */

static void LoadDialogs()
{
    hdDlgAb    = DialogOpen( "DlgSig_Abort" );
    hdDlgRtAb  = DialogOpen( "DlgSig_RetryAbort");
    hdDlgCnTm  = DialogOpen( "DlgSig_ContTerm" );
}


void AbortHandler( int sigVal )
{
    ushort id;
    int c;

    signal( sigVal, SIG_IGN );
    sprintf( textBuffer, "Signal \"%s\" detected. "
                         "Further execution is not possible",
		    sigVal == SIGABRT  ? sigName[0] :
		    sigVal == SIGFPE   ? sigName[1] :
		    sigVal == SIGILL   ? sigName[2] :
		    sigVal == SIGINT   ? sigName[3] :
		    sigVal == SIGSEGV  ? sigName[4] :
                    sigVal == SIGTERM  ? sigName[5] : "?"  );
    DialogPutStr( hdDlgAb, 1, textBuffer );
    DialogShow( hdDlgAb );

    id = 0;
    for(;;) {
	if( DialogSeqEdit( hdDlgAb, &id, c=ScrInkey() ) )
	    c = 0;
	if( (c == K_RETURN || c == K_MRIGHT) && id == 2 ) {
	    DialogHide( hdDlgAb );
	    exit(6);
	}
    }

}


/*
 * Dieser SIGINT Handler, wird bei MSDOS
 * nur via Raise aufgerufen , da der INT23 nie erzeugt wird, weil
 * dies schon beim int1b abgefangen wird.
 */

void CtrlBreakHandler( int sigVal )
{
    ushort id;
    int c, val;

  #if MSDOS
    /* we have to set it back to the handler in every case */
    /* because the default would be to exit via _exit() ! */
    /* and that doesn't call the atexit()'s */
    signal(SIGINT, CtrlBreakHandler);
    EventPoll();
  #else
    signal( sigVal, SIG_IGN );
  #endif

    if( sigintSentinel )
	return ;
    sigintSentinel++;

    sprintf( textBuffer, "Signal \"%s\" detected. ", sigName[3] );
    DialogPutStr( hdDlgCnTm, 1, textBuffer );
    DialogShow( hdDlgCnTm );

    id = 0;
    for(;;) {
	if( DialogSeqEdit( hdDlgCnTm, &id, c = ScrInkey() ) )
	    c = 0;
	else if( id == 2 ) {
	    DialogGetInt( hdDlgCnTm, id, &val );
	    if( ((c == K_RETURN || c == K_MRIGHT) && val == 0) ||
						  c == K_ESCAPE ) {
		DialogSeqEdit( hdDlgCnTm, &id, K_APP_1 );
		DialogHide( hdDlgCnTm );
		if( signal(SIGINT, CtrlBreakHandler) == SIG_ERR )
		    raise(SIGABRT);
		EventClear( EVT_SIG );
		sigintSentinel--;
		return ;
	    }
	    else if( (c == K_RETURN || c == K_MRIGHT) && val == 1 ) {
		DialogHide( hdDlgCnTm );
		exit(3);
	    }
	}
    }
}


#if MSDOS
/*
 * This function is to intercept the Bios Ctrl-Break Int 1b
 */

static int Int1B_Monitor( struct INT_DATA *pd )
{
    int bb = 0;
    int_on();
    poke(0x40,0x71,&bb,1);  /* reset the BiosBreakFlag */
    event_Int1BPending = 1;
    return 1;	/* execute IRET */
}

/*
 * This function is to intercept the DOS Function Dispatcher
 */

static int Int21_Monitor( struct INT_DATA *pd )
{
    static int sema;

    sema++;
    int_prev( pd );
    sema--;
    return 1;	/* execute IRET */
}


/*
 *  Monitor to intercept the Critical Error Interrupt
 * This Monitor will reset all Events and will call the
 * Handler to show the Window.
 */

static int Int24_Monitor( struct INT_DATA *pd )
{
    int drive, regAX, errcode;

    sigintSentinel++;
    int_on();
    EventClear( ~0 ); /* clear all pending events */
    drive = (pd->regs.h.ah & 0x80)? 0: pd->regs.h.al+'A';
    regAX = pd->regs.x.ax;
    errcode = pd->regs.x.di;
    pd->regs.h.al = CritErrHandler( drive, regAX, errcode );
    sigintSentinel--;
    return 1;	/* execute IRET */
}

static int CritErrHandler( int drive, int regAX, int errcode )
{
    ushort id;
    int c, val;

    if( drive )
      #if 0
	if( errcode >= 0 && errcode < DIM(hErrNames) )
            sprintf( textBuffer, "Error on Drive %c: %s",
				  drive , hErrNames[errcode] );
	else
            sprintf( textBuffer, "Error on Drive %c: Code: %d",
				  drive , errcode );
      #endif
        sprintf( textBuffer, "Critical error on %c: AX=%X Code=%X",
			      drive , regAX, errcode);
    else
        sprintf( textBuffer, "Critical error: AX=%X Code=%X", regAX, errcode);
    if( regAX & (1<<2) )
        strcat( textBuffer, ", Fail" );
    if( regAX & (1<<3) )
        strcat( textBuffer, ", Retry" );
    if( regAX & (1<<4) )
        strcat( textBuffer, ", Ignore" );
    DialogPutStr( hdDlgRtAb, 1, textBuffer );
    DialogShow( hdDlgRtAb );

    id = 0;
    for(;;) {
	if( DialogSeqEdit( hdDlgRtAb, &id, c = ScrInkey() ) )
	    c = 0;
	else if( id == 2 ) {
	    DialogGetInt( hdDlgRtAb, id, &val );
	    if( c == K_RETURN || c == K_MRIGHT ) {
		DialogSeqEdit( hdDlgRtAb, &id, K_APP_1 );
		DialogHide( hdDlgRtAb );
		return val? 3 : 1; /* fail - retry */
	    }
	}
    }
}
#endif

#endif

/*
 * Cleanup is for the complete Dialog System
 */

static void Cleanup( void * dummy )
{
  #if MSDOS && !DUMMY_MODULE
    if( int1bIntercepted ) {
	int_restore(0x21);
	int_restore(0x1b);
	dos_set_ctrl_break(oldDosCtrlBreakFlag);
	int1bIntercepted = 0;
    }
  #endif
    Dialog_closeall();
    /* restore Original Terminal Screen */
    ScrControl( 0, SCR_CTRL_ORGSCR, 0 , 0 );
}


/***** bottom of File *****/
