# [wklib.mak wk 18.05.95] Includlibor makefiles using wklib
#     Copyright (c) 1988-95 by Werner Koch (dd9jn)
# This file is part of WkLib.
#
# WkLib is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# WkLib is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#--------------------------------------------------
# Include this file from your makefile. we do some argument checking
# here, so there is one drawback: there is no default target for you,
# but you may code "target" as your default target, as argument
# checking ist done for this. if you which to include the argument
# checking, use the target "check-args". you can do your own checking
# and add lines to the variable "args_error" these line. check-args
# will abort the make if this variableis not empty.
#
#  WKLIBS ::= this is required and must point to the directory above
#	      the directory wklib (in which this file here lives)
#	      include this file here with this line:
#		"include $(WKLIBS)/wklib/wklib.mak"
#  CC_I_wklibs ::= should be set to -I$(WKLIBS) if there ist no "include/wk"
#  WKLIBDEFTARGET := is this is defined, we will not guess a target system
#		     but use this value (only if no target is given)
#  PLIB := points to old OS/2 (1.x) libraries (used only for Zortech)
#  OS2_1X_INCLUDE := watcom: points to OS2 1.x headers
#  OS2_2X_INCLUDE := watcom: points to OS2 2.x headers
#  HOST_BIN_DIR   := specifies where to find the tools
#  WORK_IN_SRCDIR := use current directory for objects etc.
#
#  CPU ::= i86, i286 , i386
#  COMPANY ::= wtc, ibm, msc, ztc, gnu, hp
#  SYSTEM  ::= msdos, windoze, linux, hpux, linuxaout
# As a second way, you can use:
#  TARGET  which is CPU-COMPANY-SYSTEM
#
# Additional Flags:
#  DEBUG=1 ::= select debugversion
#  MODEL=n ::= MSDOS + OS/2 1.x only: Select memory model: S M C L
#  TARGET_PREFIX=dir  ::= set the path for target directories
#			  (default is "..")
#  MULTI_THREADED ::= select multi threaded libs etc.
#		      (only used for ibm os/2 and wtc OS/2 2.x)
#  DPMI_AVAILABLE ::= indicates that dpmi is available
#		      (ancient dos host support)
#  DEFAULT_WINDOWING := use default windowing system
#  DO_NOT_OPTIMIZE   := disable optimizing (currently only watcom)
#  CREATE_PIC	     := create position independent code
#  USE_GCC	     := use gcc instead of the standard compiler
#  PROFILE	     := Create profiling version
#  WINDOW_API	     := use the windowing API (cygwin, mingw32)
#  CONSOLE_API	     := use the console API (default)
#
# Special targets:
# check-args	   ::= call it to check for argumnet errors
# default-target   ::= the first target redirects to "default"
# default	   ::= main makefile should code this to setup the default
#		       target  (or use "build=xxx" on the commandline)
#
# Special variables:
# build 	    ::= macro can be used on the commandline to specify a
#			make-target
# buildx	    ::= same as build, but enclosed in $X...$x
# args_error	    ::= to collect error messages
# msdos_like_system ::= defined if its a msdos like system
# host_is_os2	    ::= defined if we are using an os2 system as host
# have_emx_tools    ::= defined if we are using the emx system
# crosscompile	    ::= defined if we do compiling for another target
#
# target	    ::= composed cpu-company-system
# target_dir	    ::= $(target) with appended subdirectory
# target_prefix     ::= prefix for the target direcory
# exe_dir	    ::= where to put the executables (includes target_prefix)
#			( this is: $(target_prefix)/$(target_dir) )
# lib_dir	    ::= where to put the libs ...
# obj_dir	    ::= where to put the object files ...
# wklib_dir	    ::= where to find the wklibs
# wklib_prefix	    ::= where to find the wklib obj tree
#
# Special notes:
# linux: standard object format is ELF, to use aout you must use
#	 linuxaout as SYSTEM and verify that the "-b" option to gcc
#	 is correct for your configuration (search for "i486-linuxaout")
#--------------------------------------------------
# $Id: wklib.mak,v 1.15 1997/06/24 08:59:06 wk Exp $
#############################################################

SUFFIXES += .m


ifndef target
include $(WKLIBS)/wklib/common.mak
endif

wklib_prefix := $(WKLIBS)/obj-wklib

ifdef HOST_BIN_DIR
host_bin_dir := $(HOST_BIN_DIR)
else
ifdef host_is_os2
host_bin_dir := $(HOST_BIN_DIR)
endif
endif

#***** the rest is target specific

# Check CPU, COMPANY and SYSTEM
tmp := $(nullstring)
ifeq ($(findstring "$(CPU)", "i86" "i286" "i386" "hppa"),)
tmp += echo Unknown CPU, try one of: i86 i286 i386 hppa
endif
ifeq ($(findstring "$(COMPANY)", "gnu" "wtc" "ztc" "msc" "emx" "ibm" "hp" ""),)
tmp += echo Unknown COMPANY, try one of: gnu wtc ztc msc ibm emx hp
endif
ifeq ($(findstring "$(SYSTEM)", "os2" "msdos" "windoze" "cygwin"\
			  "linux" "hpux" "netware" "linuxaout" "mingw32"),)
tmp += echo Unknown SYSTEM, try one of: os2 msdos windoze cygwin linux hpux netware linuxaout mingw32

endif
ifneq ($(tmp),)
args_error += $(tmp) echo "$(target)" is an invalid target system
endif

# check for wklib.  Somewhat strange, because we already used it,
# but we can check for some needed files
ifeq ($(WKLIBS),)
args_error += echo WKLIBS not set.
else
ifeq ($(wildcard $(WKLIBS)/wklib/Makefile),)
args_error += echo wklib is not installed
endif
ifeq ($(wildcard $(WKLIBS)/wk/tailor.h),)
args_error += echo header directory for wklib is not installed
endif
endif

# some handy variables
ifneq ($(findstring $(SYSTEM), os2 msdos windoze netware mingw32),)
msdos_like_system := 1
endif


ifeq ($(COMPANY),gnu)
USE_GCC := 1
endif

ifeq ($(SYSTEM),mingw32)
USE_GCC := 1
crosscompile := 1
endif

ifdef CREATE_PIC
ifneq ($(SYSTEM),hpux)
args_error += echo PIC generation is only supported for HPUX
endif
ifdef USE_GCC
args_error += echo PIC generation is not supported for HPUX with gcc
endif
endif


# standard subdirectory for object files
obj_subdirectory := s

# define CFLAGS
ifneq ($(findstring) "$(target)", "i386-gnu-linux" "i386-emx-os2" "i386--mingw32",)
CFLAGS = $(nullstring)
else
CFLAGS = -DWK_CPU=\"$(CPU)\" -DWK_COMPANY=\"$(COMPANY)\" \
	 -DWK_SYSTEM=\"$(SYSTEM)\"
endif

ifdef crosscompile
ifndef CC_I_wklibs
CC_I_wklibs := -I $(WKLIBS)
endif
endif

#--------------------------------------
# special handling for msdos like systems
# company is here the name of the compiler
ifdef host_is_os2

ifneq ($(findstring "$(CPU)", "i86" "i286"),)
# setup a default memory_model
ifndef MODEL
ifeq ($(SYSTEM),windoze)
MODEL := L
else
MODEL := S
endif # not windoze
endif # MODEL

ifeq ($(findstring "$(MODEL)", "S" "M" "C" "L" "Z"),)
args_error += echo Invalid memory mode. MODEL must be one of: S M C L Z
endif
ifeq ($(MODEL),C)
obj_subdirectory := c
endif
ifeq ($(MODEL),M)
obj_subdirectory := m
endif
ifeq ($(MODEL),L)
obj_subdirectory := l
endif
ifeq ($(MODEL),Z)
ifneq ($(COMPANY),ztc)
args_error += echo Model Z can only be used with Zortech ( DOS16RM )
endif
obj_subdirectory := z
endif

endif # 16 bit cpu

ifeq ($(SYSTEM),netware)
#--- netware objects are stored under a subdirectory named 3
# fixme: need a mechanism to specify other versions
obj_subdirectory := 3
endif

#** begin PC compiler selection
ifeq ($(COMPANY),ibm)
#----- IBM C-Set/2 ---------
ifneq ($(target),i386-ibm-os2)
args_error += echo IBM C Set/2 can only be used for OS/2 version 2.x
endif

ifdef MULTI_THREADED
obj_subdirectory := m
CC := icc -Q -Sm -Gm
add_dll_libs := dde4mbso.lib  os2386.lib
else
CC := icc -Q -Sm
add_dll_libs := dde4sbso.lib  os2386.lib
endif

ifdef DEBUG
CFLAGS += -c -DOS20 -DDEBUG -DMEM_DEBUG -Ti -Fo$@
else
CFLAGS += -c -DOS20 -Fo$@    # removed the -O flag; doesn't work correct
			    # e.g. the MemStr() function doesn't work
endif

endif #-- IBM --

ifeq ($(COMPANY),ztc)
#------Zortech 3.0 -----
# fixme: should add some checks for valid targets
# (the only valid i386 target is: i386-ztc-msdos)

ifdef DPMI_AVAILABLE
CC := ztc
else
CC := ztc -b
endif

ifeq ($(SYSTEM),os2)
LIB := $(PLIB);$(LIB)
endif

ifeq ($(CPU),i386)   # 32 bit msdos version: DOS386 is defined by ztc
cflags_1 := -r -R -mX -w2 -w6 -c
else
ifeq ($(SYSTEM),os2)
cflags_1 := -r -R -m$(MODEL) -w2 -w6 -c -DOS2
else
ifeq ($(MODEL),Z)
cflags_1 := -r -R -m$(MODEL) -w2 -w6 -c -DDOS16RM
else
cflags_1 := -r -R -m$(MODEL) -w2 -w6 -c -DMSDOS
endif
endif
endif

ifneq ($(MODEL),Z)
#-- debugging doesn't work with DOS16RM Extender
cflags_1 += -g
endif

ifdef DEBUG
CFLAGS += $(cflags_1) -D -DMEM_DEBUG -o$@
else
CFLAGS += $(cflags_1) -o -o$@
endif
endif #-- Zortech --


ifeq ($(COMPANY),wtc)
#------- Watcom-C 10.0 --------
# fixme: most targets are valid, but we should add some checks

ifeq ($(CPU),i386)
CC := wcc386 -zq
else
CC := wcc -zq
endif

ifeq ($(SYSTEM),msdos)
ifeq ($(CPU),i386)
cflags_1 := -bt=dos4g -DDOS386=1
else
cflags_1 := -bt=DOS -m$(MODEL)
endif
endif #end msdos

ifeq ($(SYSTEM),windoze)
ifneq ($(target),i286-wtc-windoze)
args_error += echo We do only support target i286-wtc-windoze
endif
ifneq ($(MODEL),L)
args_error += echo Windoze versions must use MODEL=L
endif
cflags_1 := -bt=windows -m$(MODEL) -2 -zu
endif # end windoze

ifeq ($(SYSTEM),os2)
ifeq ($(CPU),i286)
export OS2_INCLUDE := $(OS2_1X_INCLUDE)
cflags_1 := -bt=OS2 -m$(MODEL) -DOS2
else
export OS2_INCLUDE := $(OS2_2X_INCLUDE)
ifdef MULTI_THREADED
obj_subdirectory := m
#cflags_1 := -bm -bt=OS2 -mF -s -sg -5s -DOS20 -DMULTI_THREADED
cflags_1 := -bt=OS2 -mF -s -sg -5s -DOS20 -DMULTI_THREADED
else
cflags_1 := -bt=OS2 -mF -DOS20
endif
endif #end i286
endif #end os2

ifeq ($(SYSTEM),winnt)
ifdef MULTI_THREADED
obj_subdirectory := m
cflags_1 := -bt=NT -mF -s -sg -5s -DWINNT -DMULTI_THREADED
else
cflags_1 := -bt=NT -mF -DWINNT
endif
endif #end winnt

ifeq ($(SYSTEM),netware)
cflags_1 := -bt=netware -DNETWARE
endif #end netware

ifdef DEFAULT_WINDOWING
cflags_1 += -bw
endif
ifdef DO_NOT_OPTIMIZE
cflags_1 += -od
endif

ifdef DEBUG
CFLAGS += $(cflags_1) -d2 -dDEBUG=1 -dMEM_DEBUG=1 -fo=$(subst /,\\,$@)
else
ifdef DO_NOT_OPTIMIZE
CFLAGS += $(cflags_1) -fo=$(subst /,\\,$@)
else
CFLAGS += -ort $(cflags_1) -fo=$(subst /,\\,$@)
# Caution: avoid -ol or -ox; these generate bad code with 10.0 or 10.0a.
endif
endif
endif #-- Watcom --

ifeq ($(COMPANY),gnu)
#---- gcc/2 ---------

CC := gcc -Wall -Wno-parentheses
# (-xc : assume source is c, this is because gcc thinks xx.C
#  is a c++ file --- but msdos-filesystems are case insensitive)
ifdef DEBUG
CFLAGS += -g -DDEBUG -DMEM_DEBUG  -c -xc -DOS20 -o $@
else
CFLAGS += -O2 -c -xc -DOS20 -o $@
endif

endif #-- GNU --

ifeq ($(COMPANY),emx)
#---- EMX extender ---
have_emx_tools := 1
ifneq ($(target),i386-emx-os2)
args_error += echo Currently we only support emx for OS/2 version 2.x
endif

CC := gcc -Wall -Wno-parentheses
ifdef MULTI_THREADED
obj_subdirectory := m
cflags_1 := -Zomf -DEMX -c -xc -DOS20 -DMULTI_THREADED -mprobe -Zmt
else
cflags_1 := -Zomf -DEMX -c -xc -DOS20 -mprobe
endif

ifdef DEBUG
CFLAGS += $(cflags_1) -g -DDEBUG -DMEM_DEBUG -o $@
else
ifdef DO_NOT_OPTIMIZE
CFLAGS += $(cflags_1) -o $@
else
CFLAGS += $(cflags_1) -O2 -o $@
endif
endif

endif #--EMX--

ifeq ($(COMPANY),msc)
#---- oops ( C 6.0 I think ) ---

CC := cl -nologo
ifeq ($(SYSTEM),msdos)
cflags_1 := -A$(MODEL) -c -DMSDOS
else # this must be OS/2 1.x
cflags_1 := -A$(MODEL) -c -G2 -UMSDOS -DOS2
endif

ifdef DEBUG
CFLAGS += -qc $(cflags_1) -Zi -DDEBUG -DMEM_DEBUG -Fo$@
else
CFLAGS += $(cflags_1) -Fo$@
endif

endif #-- MSC --
#*** end PC compiler selection
endif # COMPANY is compiler vendor ( host_is_os2 )

ifndef host_is_os2
ifdef USE_GCC	#-- we want the gnu compiler

ifeq ($(SYSTEM),linuxaout)
CC := gcc -b i486-linuxaout -Wall -Wno-parentheses $(CC_I_wklibs)
# (remember: no space between -b and the arg for ldsh)
override LDSH_FLAGS := -bi486-linuxaout $(LDSH_FLAGS)
else
ifeq ($(SYSTEM),mingw32)
# Minimalist Gnu Win32 System (Crosscompiler to Windoze Api 32)
CC := $(TARGET)-gcc -Wall -Wno-parentheses $(CC_I_wklibs)
ifdef WINDOWS_API
CC += -windows -DWINDOWS_API
obj_subdirectory := w
else
ifndef CONSOLE_API
CONSOLE_API := 1
endif
CC += -DCONSOLE_API
obj_subdirectory := c
endif # end mingw32
else
CC := gcc -Wall -Wno-parentheses $(CC_I_wklibs)
endif
endif
ifdef PROFILE
CFLAGS += -pg
endif
ifdef DEBUG
CFLAGS += -g -DDEBUG -DMEM_DEBUG  -c -o $@
else
CFLAGS += -O2 -c -o $@
endif

else  # use standard compiler

ifeq ($(SYSTEM),hpux)
ifdef CREATE_PIC
obj_subdirectory := pic
CC := c89 +z -I$(WKLIBS)
#	   !-- create PIC (beware: -z is a different option)
# does not work with all compilers (some systems are bundled with a
# crippled compiler, which is not able to create position independent
# code) - but gcc 2.6.3 is also not able to create PIC.
else
CC := c89 -I$(WKLIBS)
endif
ifdef DEBUG
CFLAGS += -g -DDEBUG -DMEM_DEBUG  -c -DUNIX -o $@
else
CFLAGS += -O -c -DUNIX -o $@
endif
override LDSH_FLAGS := $(LDSH_FLAGS) -posix

else # use system's compiler

ifdef PROFILE
CFLAGS += -pg
endif
ifdef DEBUG
CFLAGS += -g -DDEBUG -DMEM_DEBUG  -c -I/usr/local/include -DUNIX -o $@
else
CFLAGS += -O -c  -I/usr/local/include -DUNIX -o $@
endif

endif # end standard compiler
endif # end use system compiler
endif # end not host_is_os2

# build the directory variable
ifdef WORK_IN_SRCDIR
tmp := .
target_prefix := .
else
tmp := $(target)/$(obj_subdirectory)
ifdef DEBUG
tmp := $(tmp)-d
override LDSH_FLAGS := $(LDSH_FLAGS) -g
endif
ifdef PROFILE
tmp := $(tmp)p
override LDSH_FLAGS := $(LDSH_FLAGS) -pg
endif
target_dir := $(tmp)
wklib_dir := $(wklib_prefix)/$(tmp)
ifdef TARGET_PREFIX
tmp := $(TARGET_PREFIX)/$(tmp)
target_prefix := $(TARGET_PREFIX)
else
tmp := ../$(tmp)
target_prefix := ..
endif
endif

obj_dir := $(tmp)
lib_dir := $(tmp)
exe_dir := $(tmp)


# we need some variables to cope with the different extensions
x := $(nullstring)
o := .o
a := .a
s := .so
i := .sa
# redefine for non-standard OS
ifdef crosscompile
ifeq ($(SYSTEM),mingw32)
x := .exe
o := .o
a := .a
s := .dll
i := .imp
endif
else # not crosscompile
ifdef msdos_like_system
ifeq ($(SYSTEM),netware)
x := .nlm
else
x := .exe
endif
o := .obj
a := .lib
s := .dll
i := .imp
endif # msdos alike
endif # not crosscompile



wklib	   := libwk1$a

ifdef msdos_like_system # this is OS/2, NT or windows

wklib_4dll  := libwk1$i
ifeq ($(COMPANY),emx)
# library_path is set by emxinit.cmd
LDSH_OBJS := $(LIBRARY_PATH)/crt0$o
LDSH_OBJS_4DLL := $(LIBRARY_PATH)/dll0$o
ifdef MULTI_THREADED
LDSH_LIBS := $(LIBRARY_PATH)/mt/c_import$a
else
LDSH_LIBS := $(LIBRARY_PATH)/st/c_import$a
endif
LDSH_LIBS += $(LIBRARY_PATH)/emx2$a $(LIBRARY_PATH)/os2$a
LDSH_LIBS_4DLL := $(LDSH_LIBS)
else # not emx
ifeq ($(COMPANY),wtc)
LDSH_FLAGS_4DLL :=
else
LDSH_FLAGS_4DLL := -jn
endif
endif

else # UNIX shared libraries
# fixme: this is under construction

ifeq ($(SYSTEM),hpux)
wklib_4dll  := libwk1i$a
LDSH_FLAGS_4DLL := "-Wl,-E,+s,-b -v"
else
wklib_4dll  := libwk1i$a
LDSH_FLAGS_4DLL := -jn
endif #end !hpux

endif # end UNIX shared libs


# vpath declarations
vpath %$o   $(obj_dir)
vpath %.res $(obj_dir)
vpath %.map $(exe_dir)
vpath %$x   $(exe_dir)
vpath %$s   $(exe_dir)
vpath %$a   $(lib_dir)

ifdef host_bin_dir
LDSH := $(host_bin_dir)/ldsh
ifdef host_is_os2
LDSH := $(subst /,\\,$(LDSH))
endif
else
LDSH := ldsh
endif

ifdef host_is_os2
CPP := cpp
RM  := rm -q
endif

ifdef crosscompile
AR     := $(TARGET)-ar
RANLIB := $(TARGET)-ranlib
else
AR     := ar
RANLIB := ranlib
endif

# Some default targets
.PHONY: check-args default-target default force

ifdef buildx
override build := $(exe_dir)/$(buildx)$x
endif

ifdef build
default-target: check-args $(build)
else
default-target: check-args default
endif

force:


ifeq ($(args_error),)
check-args: force
else
check-args: force
ifdef host_is_os2
	@xecho make: commandline error. $(args_error:echo=\\nmake:)
else
	@echo -e make: commandline errors. $(args_error:echo=\\nmake:)
endif
	@false
endif

#--------- some pattern rules ---------------

$(obj_dir)/%$o	 :: %.l
	flex -t -8 $*.l >$*.c
	$(CC) $(ADD_CFLAGS) $(CFLAGS) $*.c


$(obj_dir)/%$o	 :: %.c
	$(CC) $(ADD_CFLAGS) $(CFLAGS) $*.c

$(obj_dir)/%$o	 :: %.m
	$(CC) $(ADD_CFLAGS) $(CFLAGS) $*.m

$(obj_dir)/%.res :: %.rc
ifeq ($(COMPANY),wtc)
	rc -r -D DEBUG -I $(subst /,\\,$(WATCOM)/h/os2) $*.rc $@
else
ifdef EMX_INSTALL_DIR
	rc -r -D DEBUG -I $(EMX_INSTALL_DIR)/h/os2 $*.rc $@
else
	rc -r -D DEBUG -I c:/usr/emx/h/os2 $*.rc $@
endif
endif

%$o   :: %.m
	$(CC) $(ADD_CFLAGS) $(CFLAGS) $*.m


%$x : %$o
	$(LDSH) $(LDSH_FLAGS) $(LDSH_OBJS) $(ADD_LDSH_MACROS) \
	TARGET=$(target) $*$x $^ $(ADD_LIBS_1) $(wklib_dir)/$(wklib) \
					$(ADD_LIBS)  $(LDSH_LIBS)


%$s : %$o
	$(LDSH) $(LDSH_FLAGS) $(LDSH_FLAGS_4DLL) $(LDSH_OBJS_4DLL) \
	$(ADD_LDSH_MACROS) TARGET=$(target) $*$s $^ \
	$(wklib_dir)/$(wklib_4dll) $(ADD_DLL_LIBS) $(LDSH_LIBS_4DLL)


#### end of file ####
