/* [video16.c wk 26.11.93] Access to 16 bit VIO-Functions
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: video16.c,v 1.7 1995/10/29 18:26:53 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <wk/bios.h>
#include <wk/environ.h>

#ifndef OS20
    #error This Module is only for OS/2 2.0
#endif

#if defined(MAKE_WK16WRAP)
  #ifndef __IBMC__
    #error Must use IBM CSet/2 to build the Wrapper-DLL
  #endif
    #define INCL_DOSMODULEMGR	  /* Module Manager values */
    #define FName(a) _dllapi WK16Wrap_##a
    #define INCL_SUB 1
    #include <os2.h>
    short FName(VideoSetBlinking)( short on_off );
#else
    #define FName(a) WK##a

    static int dllAvailable = 0;
    static volatile ushort *(* _dllapi VideoGetBuffer)( ulong *bufferSize );
    static void (* _dllapi VideoShowBuffer)( ulong bufferSize );
    static void (* _dllapi VideoWriteCellString)( ushort *c,
						ulong len, ulong x, ulong y);
    static void (* _dllapi VideoWriteNCell)( ushort c,
						ulong len, ulong x, ulong y);
    static short (* _dllapi VideoSetBlinking)( short on_off );
    static void LoadDll(void);
#endif





volatile ushort * FName(VideoGetBuffer)( ulong *bufferSize )
{
  #ifndef MAKE_WK16WRAP
    if( !dllAvailable )
	LoadDll();
    return VideoGetBuffer( bufferSize );
  #else
    USHORT * _Seg16 vBuffer;
    ULONG vioBufferSize;

    WK16Wrap_VideoSetBlinking(0);
    if( VioGetBuf( (PULONG)&vBuffer, (PUSHORT)&vioBufferSize, 0) )
	vBuffer = NULL;
    else if( bufferSize )
	*bufferSize = vioBufferSize;
    return  (volatile ushort *)vBuffer;
  #endif
}


void FName(VideoShowBuffer)( ulong bufferSize )
{
  #ifndef MAKE_WK16WRAP
    if( !dllAvailable )
	LoadDll();
    VideoShowBuffer( bufferSize );
  #else
    VioShowBuf( 0, bufferSize, 0 );
  #endif
}


void FName(VideoWriteCellString)( ushort *c, ulong len, ulong x, ulong y)
{
  #ifndef MAKE_WK16WRAP
    if( !dllAvailable )
	LoadDll();
    VideoWriteCellString( c, len, x, y);
  #else
    UCHAR * _Seg16 c16;

    c16 = (byte*)c;
    VioWrtCellStr( c16, len, x, y, 0 );
  #endif
}



void FName(VideoWriteNCell)( ushort c, ulong len, ulong x, ulong y)
{
  #ifndef MAKE_WK16WRAP
    if( !dllAvailable )
	LoadDll();
    VideoWriteNCell( c, len, x, y);
  #else
    VioWrtNCell( (PCH)&c, len, x, y, 0 ) ;
  #endif
}


short FName(VideoSetBlinking)( short on_off )
{
  #ifndef MAKE_WK16WRAP
    if( !dllAvailable )
	LoadDll();
    return VideoSetBlinking( on_off );
  #else
    short old_state;
    ushort buf[3];

    buf[0] = 6; /* length of structure */
    buf[1] = 2; /* viointenstity */
    VioGetState( (USHORT * _Seg16)&buf, 0);
    old_state = buf[2]? 0 : 1;

    buf[0] = 6; /* length of structure */
    buf[1] = 2; /* viointenstity */
    buf[2] = on_off? 0 : 1;
    VioSetState( (USHORT * _Seg16)&buf, 0);
    return  old_state;
  #endif
}



#ifndef MAKE_WK16WRAP
/****************
 * Load the DLL on Demand
 */


static void LoadDll(void)
{
    static char name[] = "WK16WRAP";
    int rc;
  #ifndef __IBMC__
    int i;
    struct { void **proc; char *name; } tbl[] = {
	{  &VideoGetBuffer	,"WK16Wrap_VideoGetBuffer"       },
	{  &VideoShowBuffer	,"WK16Wrap_VideoShowBuffer"      },
	{  &VideoWriteCellString,"WK16Wrap_VideoWriteCellString" },
	{  &VideoWriteNCell	,"WK16Wrap_VideoWriteNCell"      },
	{  &VideoSetBlinking	,"WK16Wrap_VideoSetBlinking"     },
	{ NULL }
    };

    for(i=0; tbl[i].proc; i++ )
	if( !(*tbl[i].proc = WKLoadModule(name,tbl[i].name,&rc)) )
	    goto failure;

  #else
    if( !(VideoGetBuffer = (volatile ushort *(* _dllapi)(ulong*))
			  WKLoadModule(name,"WK16Wrap_VideoGetBuffer" ,&rc)))
	goto failure;
    if( !(VideoShowBuffer= (void (* _dllapi)(ulong))
			  WKLoadModule(name,"WK16Wrap_VideoShowBuffer" ,&rc)))
	goto failure;
    if( !(VideoWriteCellString=(void (* _dllapi)(ushort*,ulong,ulong,ulong))
		     WKLoadModule(name,"WK16Wrap_VideoWriteCellString" ,&rc)))
	goto failure;
    if( !(VideoWriteNCell=(void (* _dllapi)(ushort,ulong,ulong,ulong))
		     WKLoadModule(name,"WK16Wrap_VideoWriteNCell" ,&rc)))
	goto failure;
    if( !(VideoSetBlinking=(short (* _dllapi)(short))
		     WKLoadModule(name,"WK16Wrap_VideoSetBlinking" ,&rc)))
	goto failure;
  #endif
    dllAvailable = 1;
    return;
  failure:
    Error(4,"error loading module '%s': rc=%d", name, rc);
}


#endif

/*** bottom of file ***/
