/* [time2.c wk 20.5.92]
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: time2.c,v 1.7 1995/03/08 16:58:25 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wk/lib.h>
#include <time.h>


/***** constants ****/
#define JD_DIFF 1721060L

/**** protos ****/
static int DaysPerYear( int ) ;
static int DaysPerMonth( int y, int m ) ;

/***** functions *****/

#ifdef DOCUMENTATION
@Summary Date2JD	   Convert a date to a julian date
 #include <wk/lib.h>

 long Date2JD( d, m, y );
 int	d, m, y ;	tag (1..31), monat (1..12), jahr(jjjj)

@Description
 Wandelt Kalenderdatum in Julianisches Datum um.  Es wird keine Prfung
 auf Gltigkeit vorgenommen.  Julianische Datumsberechnung vor dem
 15.10.1582 z.Z. noch nicht implementiert.
 Der Wochentag wird einfach ermittelt durch:
		t = jd % 7 , wobei Montag 0 ist
@Return Value
 Tage seit Beginn der julianischen Periode
#endif

long Date2JD( int day, int month, int year )
{
    long jd ;

    jd = 365L*year+31*(month-1)+day+JD_DIFF ;
    if( month < 3 )
	year-- ;
    else
	jd -= (4*month+23)/10 ;

    jd += year/4 - ((year/100+1)*3)/4 ;

    return jd ;
}




#ifdef DOCUMENTATION
@Summary JD2Date	   Convert a julian date to a date
 #include <wk/lib.h>

 int JD2Date( jd, d, m, y );
 long	jd ;		Julianische Periode
 int	*d, *m, *y ;	Pointer auf tag, monat, jahr
@Description
 Wandelt Julianisches Datum in Kalenderdatum um hat die Julianische
 Periode einen ungltigen Wert (z.B.: -1), so wird 0 zurueckgegeben
 und tag, monat Jahr nicht veraendert. wenn einer der Werte nicht
 benoetigt wird, so kann NULL angegeben werden.
@Return Value
 Tag im Jahr (1..366) oder 0 falls JD ungueltig ist.
#endif


int JD2Date( long jd, int *day, int *month, int *year )
{
    int y , m , d ;
    long  dif ;

    if( !jd )
	return 0 ;
    else if( jd < 1721425L || jd > 2843085L )
	return 0;

    y = (int)((jd - JD_DIFF) / 366L) ;
    d = m = 1 ;

    while( (dif=jd - Date2JD( d,m,y )) > DaysPerYear(y) )
	y++ ;
    m = (int)(dif / 31L) + 1 ;
    while( (dif=jd - Date2JD( d,m,y )) > DaysPerMonth(y,m) )
	if(++m > 12 )
	    { m = 1 , y++ ; }
    d = (int)dif + 1 ;
    if( d > DaysPerMonth( y,m ) )
	{ d = 1 ; m++ ; }
    if( m > 12 )
	{ m = 1 , y++ ; }

    if( year )
	*year = y;
    if( month )
	*month = m;
    if( day )
	*day = d ;

    return (int)(jd - Date2JD( 1,1,y )) + 1 ;
}



long TodaysJD()
{
    time_t  tim ;
    struct  tm	*t ;

    time( &tim ) ;
    t = localtime( &tim ) ;
    return Date2JD( t->tm_mday, t->tm_mon+1, t->tm_year+1900 ) ;
}


#ifdef DOCUMENTATION
@Summary CheckDate	   Checks for a valid date
 #include <wk/lib.h>

 int CheckDate( d, m , y );
 int	d, m, y ;	tag, monat, jahr
@Description
 Prft ein Datum auf Gltigkeit
@Return Value
  0 - gltiges Datum
  1 - fehler im tag
  2 - fehler im monat
  3 - fehler im jahr ( < 1 )
  4 - sonstiger Fehler
 -1 - nicht vorhandenes datum (5.-14.10.1582)
#endif

int CheckDate( int d, int m, int y )
{
    if( y < 1 )
	return 3 ;
    if( m < 1 || m > 12 )
	return 2 ;
    if( d < 1 || d > DaysPerMonth( y,m ) )
	return 1 ;

    if( y == 1582 )
	if( m == 10 )
	    if( d > 4 && d < 15 )
		return -1 ;

    return 0 ;
}


static int DaysPerYear( int y )
{
    int s ;

    s = !(y%4) ;
    if( !(y%100) )
	if( (y%400) )
	    s = 0 ;
    return s ? 366 : 365 ;
}



static int DaysPerMonth( int y, int m )
{
    int s ;

    switch( m )
    {
	case 1: case 3: case 5: case 7: case 8: case 10: case 12:
	    return 31 ;
	case 2:
	    s = !(y%4) ;
	    if( !(y%100) )
		if( (y%400) )
		    s = 0 ;
	    return s? 29: 28 ;
	case 4: case 6: case 9: case 11:
	    return 30 ;
    }
    BUG();  return 0; /* NEVER REACHED */
}



/*** bottom of file ****/
