/* [srchenv.c wk 16.10.90] Search filenames along EnvVars
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /usr/src/master/libs/wklib/srchenv.c,v 1.9 1995/10/29 18:26:52 wernerk Exp $
 *
 * uses filename_compress() function, because DOS doesn't accept
 * a filename like: "B:\\.\name.ext"
 * History:
 * 20.06.93 wk	Changes for UNIX
 */


#include <wk/tailor.h>
RCSID("$Id: srchenv.c,v 1.9 1995/10/29 18:26:52 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if __ZTC__
#include <direct.h>
#endif
#include <wk/io.h>
#include <wk/environ.h>
#include <wk/file.h>

/***** protoytpes ****/
static const char *CopyPath( const char *src, char *dst);

/**** functions *****/

#ifdef DOCUMENTATION
@Summary SearchEnv
 #include <wk/environ.h>

 char *SearchEnv( fname, envVar, pathBuf )
 const char *fname;	name of file to search for
 const char *envVar;	name of the Environment Variable
 char pathBuf[F_MAX_PATH]; Return Buffer
@Description
 Sucht zuerst in dem aktuellen Diretory, dann in allen Diretories
 die in der EnvVar angegeben Sind nach dem Filenamen.
 die EnvVar hat den Aufbau:
 NAME={<dir>;}
 bzw: bei UNIX:
 NAME={<dir>:}
 das letzte semikolon kann entfallen, leere Dirangaben sind
 erlaubt. Ist eine einzelne Dirangabe lnger als F_MAX_DIR-1 oder sind blanks
 in der DIR-Angabe vorhanden, so
 werden die folgenden Diretories u.U. nicht mehr richtig interpretiert.
 fname muss kleiner als F_MAX_FNAME+F_MAX_DIR sein, was aber normalerweise
 immer gegeben ist. (z.B. via FilenameSplit gewonnen)
 Alle Backslahes in dem konstruierten Path sind durch slashs ersetzt und
 unntige Teile entfernt ( durch FilenameCompr() )
 Wird fr NAME ein leerer String angegeben, so wird nicht getenv()
 benutzt, sondern der Wert is direkt die Pfadangabe.
 Bei UNIX wird nicht im aktuellen Diretory gesucht, es sei denn, es ist
 im pfad angegeben.
@Return Value
 Ptr to pathBuf or NULL if not found
#endif /*DOCUMENTATION*/


char *
SearchEnv( const char *fname, const char *env_var, char *path )
{
    char *p;
    int c;
    const char *env_p;

    *path = '\0' ;  /* default: not found */
  #ifndef UNIX
    if( !access( (char*)fname, 0) ) {
	/* if exists in cwd - get cwd and catenate file name */
	getcwd(path, F_MAX_DIR);
	strcat(path, "/");
	strcat(path, fname);
    }
    else
  #endif
	 if( env_p = *env_var=='='? (env_var+1) : getenv(env_var) ) {
	while( env_p = CopyPath( env_p, path ) ) {
	    /* path now holds a path from env_p, catenate the file name */
	    p = path + strlen(path);
	    c = p[-1] ;
	  #if MSDOSFILESYSTEM
	    if( c != '/' && c != '\\' && c != ':' )
	  #else
	    if( c != '/' )
	  #endif
		*p++ = '/';

	    /* p now points to character following trailing '/' or ':' */
	    strcpy( p, fname);
	    if( !access(path, 0) )
		break ;     /* found: break while loop */
	}
    }

  #if MSDOSFILESYSTEM
    FilenameCompr(path);
  #endif
    return  *path ? path : NULL ;
}




/*
 * extract path  from env. var. and return a copy
 * src - ptr to a string of 0 or more path specs., separated by ';'s
 * dst - ptr to the buffer where the next path specification is to
 *	 be copied (size must be F_MAX_DIR )
 * an empty string is copied to dst if there are no more paths available
 * Returns: dst or NULL
 * F_MAX_DIR-2 is ues, because a '/' may be appended by calling function
 */

static const char *CopyPath( const char *src, char *dst)
{
    const char *saveSrc;
    int i ;

    saveSrc = src;
  #if MSDOSFILESYSTEM
    for( i=0; *src && *src != ';' && i < F_MAX_DIR-2 ; i++ )
  #else
    for( i=0; *src && *src != ':' && i < F_MAX_DIR-2 ; i++ )
  #endif
	*dst++ = *src++;
    *dst = '\0';

    if( *src )
	src++;	/* skip the ';' or  ':' */
    return saveSrc == src ? NULL : src ;
}

/*** bottom of file ***/
