/* [kbd16.c wk 30.11.93] Access to 16 bit KBD-Functions
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * History:
 * 07.03.95 wk added K_FLAG_COMPOSE
 */

#include <wk/tailor.h>
RCSID("$Id: kbd16.c,v 1.6 1995/03/08 16:56:16 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <wk/bios.h>
#include <wk/environ.h>
#include <wk/keys.h>

#ifndef OS20
    #error This Module is only for OS/2 2.0
#endif

#if defined(MAKE_WK16WRAP)
  #ifndef __IBMC__
    #error Must use IBM CSet/2 to build the Wrapper-DLL
  #endif
    #define INCL_DOSMODULEMGR	  /* Module Manager values */
    #define FName(a) _dllapi WK16Wrap_##a
    #define INCL_KBD 1
    #include <os2.h>
#else
    #define FName(a) WK##a

    static int dllAvailable = 0;
    static unsigned (* _dllapi KeyboardGetToggle)(void);
    static int (* _dllapi KeyboardGetChar)(int,ushort*,ushort*,unsigned*);


    static void LoadDll(void);
#endif




/****************
 * Ermittelt die aktuellen Togglekey states:
 * Returns:
 * Bit 0 = Scroll Lock
 *     1 = Num Lock
 *     2 = Caps Lock
 */

unsigned FName(KeyboardGetToggle)()
{
  #ifndef MAKE_WK16WRAP
    if( !dllAvailable )
	LoadDll();
    return KeyboardGetToggle();
  #else
    KBDINFO kbi;

    kbi.cb = sizeof kbi;
    if( !KbdGetStatus( &kbi, 0 ) )
	return (kbi.fsState >> 4) & 0x07;
    else
	return 0;
  #endif
}


/****************
 * Get a character from the keyboard
 * mode 0 ::= no wait
 *	1 ::= wait
 *
 * Returns: 0 = Character available
 *	    !0 = no Character or error
 */

int FName(KeyboardGetChar)(int mode, ushort *chr, ushort *scan, unsigned *state)
{
  #ifndef MAKE_WK16WRAP
    if( !dllAvailable )
	LoadDll();
    return KeyboardGetChar(mode,chr,scan,state);
  #else
    KBDKEYINFO kbci;

    if( KbdCharIn( &kbci, mode ? IO_WAIT:IO_NOWAIT, 0 ) )
	return 1; /* fehler (z.B. kein focus */
    if( !(kbci.fbStatus & ~(
			    KBDTRF_SHIFT_KEY_IN | KBDTRF_INTERIM_CHAR_IN |
			    KBDTRF_CONVERSION_REQUEST
			    )))
	return 2;
    if( scan )
	*scan = kbci.chScan;
    if( chr )
	*chr  = kbci.chChar;
    if( state ) {
	*state	= 0;
	if( kbci.fsState & (KBDSTF_RIGHTSHIFT| KBDSTF_LEFTSHIFT) )
	    *state |= K_FLAG_SHIFT;
	if( kbci.fsState & KBDSTF_CONTROL )
	    *state |= K_FLAG_CTRL;
	if( kbci.fsState & KBDSTF_ALT )
	    *state |= K_FLAG_ALT;
	if( kbci.fsState & KBDSTF_RIGHTALT )
	    *state |= K_FLAG_COMPOSE;
    }
    return 0;
  #endif
}






#ifndef MAKE_WK16WRAP
/****************
 * Load the DLL on Demand
 */


static void LoadDll(void)
{
    static char name[] = "WK16WRAP";
    int rc;
  #ifndef __IBMC__
    if(!(KeyboardGetToggle=WKLoadModule(name,"WK16Wrap_KeyboardGetToggle",&rc)))
	goto failure;
    if( !(KeyboardGetChar=WKLoadModule(name,"WK16Wrap_KeyboardGetChar" ,&rc)))
	goto failure;
  #else
    if( !(KeyboardGetToggle = (unsigned (* _dllapi)(void))
		    WKLoadModule(name,"WK16Wrap_KeyboardGetToggle" ,&rc)))
	goto failure;
    if( !(KeyboardGetChar = (int (* _dllapi)(int,ushort*,ushort*,unsigned*))
		    WKLoadModule(name,"WK16Wrap_KeyboardGetChar" ,&rc)))
	goto failure;
  #endif
    dllAvailable = 1;
    return;
  failure:
    Error(4,"error loading module '%s': rc=%d", name, rc);
}


#endif

/*** bottom of file ***/
