/* [hw_mem1.c wk  2.01.93] Hardware access to memory
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 */


#include <wk/tailor.h>
RCSID("$Id: hw_mem1.c,v 1.8 1996/12/03 18:16:59 wk Exp $")
#if EMX && !OS20
   #include <sys/emx.h>
#endif
#include <stdio.h>
#include <wk/hwacc.h>
#if EMX && !OS20
  #include <os2.h>
#elif OS2
  #define INCL_DOSMEMMGR 1
  #include <os2.h>
#elif MSDOS
  #include <dos.h>
#elif DOS386
  #include <dos.h>
#elif DOS16RM
  #include <zpmapi.h>
  #include <dos.h>
#endif

#if UNIX

ulong HW_QueryFreeMemory(void)
{
    return 0;
}

#endif

#if WINNT

void *HW_MakePtrToMemory( ulong base, ulong range )
{
    return (void*)base;
}

void HW_FreePtrToMemory( void *p )
{
    return;  /* no need */
}

ulong HW_QueryFreeMemory(void)
{
    return 0;
}

#endif


#if OS2

ulong HW_QueryFreeMemory(void)
{
    ulong n;
  #if OS20
    n = 0; /* must look up the function ... */
  #else
    if( DosMemAvail( &n ) )
	n = 0; /* error : return 0 */
  #endif
    return n;
}

#endif


#if EMX && !OS20

void *HW_MakePtrToMemory( ulong base, ulong range )
{
    void *p;

    p = __memaccess (base, base + range);
    if( !p )
	Bug("Error accessing memory at location %#lx\n"
	    "try: \"set EMXOPT=-am\"", base );
    return p;
}

void HW_FreePtrToMemory( void *p )
{
    return;  /* no function available for EMX */
}


ulong HW_QueryFreeMemory(void)
{
    int n;

    n = __memavail(); /* no dox ... lets simply try this */
    if( n < 0 )
	n = 0;
    return n;
}


#endif /* EMX */


#if MSDOS

void _far *HW_MakePtrToMemory( ulong base, ulong range )
{
    return MK_FP( (base >> 4) , 0 );
}

void HW_FreePtrToMemory( void _far *p )
{
    return;  /* not needed for MSDOS */
}


ulong HW_QueryFreeMemory(void)
{
  #if __ZTC__
    return farcoreleft();
  #else
    return 0; /* don't know the function */
  #endif
}

#endif /* MSDOS  */


#if DOS386 && __ZTC__

void _far *HW_MakePtrToMemory( ulong base, ulong range )
{
    return _x386_mk_protected_ptr( base );
}

void HW_FreePtrToMemory( void _far *p )
{
    _x386_free_protected_ptr( p );
}


ulong HW_QueryFreeMemory(void)
{
    return 0; /* there is no function */
}

#endif /* DOS386 */


#if DOS386 && __WATCOMC__

void *HW_MakePtrToMemory( ulong base, ulong range )
{
    if( base > 0xfffff )
	Bug("can't access memory above 1 meg");
    return (void*)base;
}

void HW_FreePtrToMemory( void _far *p )
{
    return;  /* no need */
}


ulong HW_QueryFreeMemory(void)
{
    struct meminfo {
	unsigned LargestBlockAvail;
	unsigned MaxUnlockedPage;
	unsigned LargestLockablePage;
	unsigned LinAddrSpace;
	unsigned NumFreePagesAvail;
	unsigned NumPhysicalPagesFree;
	unsigned TotalPhysicalPages;
	unsigned FreeLinAddrSpace;
	unsigned SizeOfPageFile;
	unsigned Reserved[3];
    } MemInfo;
    union REGS regs;
    struct SREGS sregs;

    regs.x.eax = 0x00000500;
    memset( &sregs, 0, sizeof(sregs) );
    sregs.es = FP_SEG( &MemInfo );
    regs.x.edi = FP_OFF( &MemInfo );

    /* call DPMI */
    int386x( 0x31 , &regs, &regs, &sregs );
  #if 0
    printf( "Largest available block (in bytes): %lu\n",
	    MemInfo.LargestBlockAvail );
    printf( "Maximum unlocked page allocation: %lu\n",
	    MemInfo.MaxUnlockedPage );
    printf( "Pages that can be allocated and locked: "
	    "%lu\n", MemInfo.LargestLockablePage );
    printf( "Total linear address space including "
	    "allocated pages: %lu\n",
	    MemInfo.LinAddrSpace );
    printf( "Number of free pages available: %lu\n",
	     MemInfo.NumFreePagesAvail );
    printf( "Number of physical pages not in use: %lu\n",
	     MemInfo.NumPhysicalPagesFree );
    printf( "Total physical pages managed by host: %lu\n",
	     MemInfo.TotalPhysicalPages );
    printf( "Free linear address space (pages): %lu\n",
	     MemInfo.FreeLinAddrSpace );
    printf( "Size of paging/file partition (pages): %lu\n",
	     MemInfo.SizeOfPageFile );
  #endif
    return MemInfo.LargestBlockAvail;
}

#endif /* DOS386 */


#if DOS16RM

void _far *HW_MakePtrToMemory( ulong base, ulong range )
{
    void _far *p;

    p = ZPMProtectedPtr( MK_FP( (base >> 4) , 0 ), range );
    if( !p )
	Bug("Error accessing memory at location %#lx; "
	    "could not allocate new selector", base );
    return p;
}

void HW_FreePtrToMemory( void _far *p )
{
    return;  /* don't know how to do it */
}


ulong HW_QueryFreeMemory(void)
{
    return  ZPMExtAvail() + ZPMLowAvail();
}

#endif /* DOS16RM */

/*** bottom of file ***/
