/* [file9.c wk 3.6.91] ScanOffsetTbl()
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 02.01.93 wk	Unused vars removed
 */


#include <wk/tailor.h>
RCSID("$Id: file9.c,v 1.5 1995/03/08 16:55:48 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/io.h>
#include <wk/file.h>


#ifdef DOCUMENTATION
@Summary ScanOffsetTbl...    Scan through a files offset Tbl
 #include <wk/file.h>

 long ScanOffsetTbl( key, stream );
 long ScanOffsetTbl2( keyNr, stream );
 const char   *key ;	String to be searched
 ushort keyNr;		Number of keyentry
 FILE	*stream ;	Filepointer of binary opened file
@Description
 Sucht ab der momentanen Fileposition durch eine Standardliste mit
 folgendem Aufbau:  4 Byte Offset, ASCIIZ string.  Ende der liste
 gekennzeichnet durch Offset von -1.  Der File mu zum binren
 Lesen geffnet sein.
 Bei der ersten Funktion wird nach dem Key gesucht, bei der 2. Funktion
 nach dem n-ten Key ( Keys sin von 0 an durchnumeriert ).
@Return Value
 Offset aus der Liste oder -1L wenn nicht gefunden oder Lesefehler.
#endif

long ScanOffsetTbl( const char *key, FILE *st )
{
    ushort dmy;
    return ScanOffsetTbl1( key, st, &dmy );
}

long ScanOffsetTbl1( const char *key, FILE *st, ushort *keyNr )
{
    long off ;
    const char *p ;
    int c ;
    ushort number;

    off = -1L ;
    number = 0;
    for(;;number++) {
	if( !fread( &off, sizeof off, 1, st )  )
	    off = -1L ;
	if( off == -1L )
	    break ;
	for( p=key ; (c=getc(st))==*p  ; p++ )
	    if( !*p )
		break ;
	if( !*p && !c ) {
	    *keyNr = number;
	    break ;
	}
	if( c )
	    while( (c=getc(st)) != EOF )
		if( !c )
		    break ;
    }
    return off ;
}


long ScanOffsetTbl2( ushort keyNr, FILE *st )
{
    long off ;
    int c ;

    for( off=-1L; ;keyNr--) {
	if( !fread( &off, sizeof off, 1, st )  )
	    off = -1L ;
	if( !keyNr || off == -1L )
	    break; /* found or End of list */
	while( (c=getc(st)) != EOF )
	    if( !c )
		break ;
    }
    return off ;
}

/******* bottom of file *******/
