/* [file5.c wk 16.10.90] Filename Split/Make
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /usr/src/master/libs/wklib/file5.c,v 1.7 1995/03/30 12:12:18 wernerk Exp $
 */

#include <wk/tailor.h>
RCSID("$Id: file5.c,v 1.7 1995/03/30 12:12:18 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wk/file.h>
#include <wk/string.h>


#ifdef DOCUMENTATION
@Summary FilenameSplit
 #include <wk/file.h>

 void FilenameSplit( path, drive, dir, fname, ext)
 const char *path;	aufzuspaltener Pfad
 char *drive;		Buffer der Lnge F_MAX_DRIVE oder NULL
 char *dir;		Buffer der Lnge F_MAX_DIR   oder NULL
 char *fname;		Buffer der Lnge F_MAX_FNAME oder NULL
 char *ext;		Buffer der Lnge F_MAX_EXT   oder NULL
@Description
 Teilt eine vollstndigen Pfadnamen in seine Bestandteile auf.
@See Also
 FilenameMake
#endif /*DOCUMENTATION*/


void FilenameSplit( const char *path,
		    char *drive, char *dir, char *fname, char *ext)
{
    const char *lastSlash , *lastDot, *p ;

    /* get drive letter and colon */
    if( path[F_MAX_DRIVE-2] == ':' ) {
	if(drive)
	    mem2str(drive, path, F_MAX_DRIVE );
	path += F_MAX_DRIVE - 1;
    }
    else if( drive)
        *drive = '\0';

    /* get the dir; path will now point to the 1. char in dir */

    for( lastDot = lastSlash = NULL, p = path; *p; p++ )
        if( *p == '/' || *p == '\\' )
	    lastSlash = p + 1;
        else if( *p == '.' )
	    lastDot = p;

    if( lastSlash ) {
	if( dir )
	    mem2str(dir, path, min((lastSlash - path), (F_MAX_DIR - 1))+1 );
	path = lastSlash;
    }
    else if(dir)
        *dir = '\0';

    /* get the filename; path will now point to the 1. char in filename */
    /* lastDot points to last dot in the path; this may not be an */
    /* extension, so check it */

    if( lastDot && ( lastDot >= path ) ) {
	if( fname )
	    mem2str(fname, path, min((lastDot - path), (F_MAX_FNAME-1))+1);
	/* get the extension */
	if( ext )
	    mem2str(ext, lastDot, min((p - lastDot), (F_MAX_EXT-1))+1);
    }
    else { /* no extension found */
	if( fname )
	    mem2str(fname, path, min((p - path), (F_MAX_FNAME-1))+1);
	if( ext )
            *ext = '\0';
    }

}



#ifdef DOCUMENTATION
@Summary FilenameMake
 #include <wk/file.h>

 void FilenameMake( path, drive, dir, fname, ext);
 char *path;		Buffer der Lnge F_MAX_PATH
 const char *drive;     Drivekomponete mit oder ohne ':' oder NULL
 const char *dir;       Dirkompontete mit oder ohne '/' am ende oder NULL
 const char *fname;	Filenamekomponente  oder NULL
 const char *ext;       Extension mit oder ohne '.' am anfang oder NULL
@Description
 Baut eine vollstndigen Pfadname aus den einzelnen Komponeten auf.
 Die einezelnen Komponenten werden nciht auf Gltigkeit berprft.
 (z.B.: fname leer )
@See Also
 FilenameSplit
#endif /*DOCUMENTATION*/


void FilenameMake( char *path, const char *drive, const char *dir,
			       const char *fname, const char *ext)
{
    const char *p;

    /* copy drive */
    if( drive )
	if( *drive ) {
	    *path++ = *drive;	/* take only the first character */
            *path++ = ':';
	}

    /* copy dir */
    if( p = dir )
	if( *p ) {
	  #if MSDOSFILESYSTEM
            if( (*p=='/'||*p=='\\') && p[1]=='.' && !p[2] )
                *path++ = '/';
	    else {
	  #endif
		do {
		    *path++ = *p++;
		} while( *p ) ;
                if( p[-1] != '/' && p[-1] != '\\' )
                    *path++ = '/';
	  #if MSDOSFILESYSTEM
	    }
	  #endif
	}

    /* copy fname */
    if( p = fname )
	while( *p )
	    *path++ = *p++;

    /* copy ext */
    if( p = ext ) {
        if( *p && *p != '.' )
            *path++ = '.';
	while( *path++ = *p++ )
	    ;
    }
    else /* no extension, add o terminator */
        *path = '\0';
}



/*** bottom of file ***/
