/* [file4.c wk 4.11.88] Filename...()
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *  Absoluten filenamen erzeugen ( mit laufwerk und Pfad )
 * History:
 * 02.01.93 wk	EMX Support
 * 20.06.93 wk	Changed for UNIX
 */

#include <wk/tailor.h>
RCSID("$Id: file4.c,v 1.13 1997/05/21 14:46:04 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wk/lib.h>
#if __ZTC__  || __IBMC__ || __WATCOMC__
   #include <direct.h>
#endif
#include <ctype.h>
#if EMX
  #include <os2.h>
#elif MSDOS || DOS386 || DOS16RM
  #include <dos.h>
#elif OS2
  #include <os2.h>
#else
  #include <wk/io.h>
#endif
#include <wk/file.h>
#include <wk/string.h>
#include <wk/direc.h>

#ifdef DOCUMENTATION
@Summary  FilenameMkAbs     Convert relative to absolute pathname
 #include <wk/file.h>

 char *FilenameMkAbs( base, name );
 char	*base ; 	Laufwerk und aktuelles Directory
			oder NULL fr das aktuelle Directory
			wird evntl. Komprimiert
 char	*name ; 	Filename / Return: Converted Filename
@Description
 Diese Funktion baut aus einem relativen Filenamen einen absoluten
 Pfadamen auf (.z.B.:  "c:\tools\datei.dat" ).  base besteht aus
 Laufwerksbuchstaben, ':', und vollem Pfadname.  Besteht der Filename
 bereits aus einem absoluten Pfadnamen und einem Lauwfwerk, so wird base
 nicht bentigt.  base und name werden durch die Funktion
 filename_compress komprimiert.

@Return Value
 Pointer to name
@See Also
 FilenameCompr
@Notes
 name mu gengend gro sein, (^uF_MAX_PATH^u in wklib.h).
 Falls nicht gengend Speicher allokiert werden kann,
 wird das Programm mit einer Fehlermeldung abgebrochen.
@Example

 #include <stdlib.h>
 #include <direc.h>
 #include <wk/wklib.h>

 char name[F_MAX_PATH] , orgdir[F_MAX_PATH] ;
 .
 .
 /* erzeuge absoluten Filenamen */

 strcpy( name, "../test/abc/text.dat" ) ;
 filename_mkabs( getcwd( orgdir ) , name ) ;

 /*
  *  falls aktuelles Directory = "C:\user\meindir", ist dann
  *  name = "c:/user/test/abc/text.dat"
  */

#endif


char *FilenameMkAbs( char *base, char *relname )
{
    char *buf , *p , *rp;
    int baseFlag;
  #if MSDOSFILESYSTEM
  #if __WATCOMC__
    unsigned drive;
  #else
    ushort drive;
  #endif
  #endif

    if( !base ) {
	base = xmalloc( F_MAX_PATH );
      #if MSDOSFILESYSTEM
	if( FileDrvCheck( relname ) ) {
	    char *orgDir;

	    orgDir = xmalloc( F_MAX_PATH );
	    getcwd( orgDir, F_MAX_PATH	);
	    drive = toupper( *relname ) - 'A' + 1 ;
	  #if EMX && !OS20
	    _chdrive( 'A' + drive - 1 );
	  #elif WINNT
	    _chdrive( 'A' + drive - 1 ); /*FIXME: use the win32 api */
	  #elif OS2
	    DosSelectDisk( drive ) ;
	  #elif __MSC__ || __WATCOMC__
	    {  unsigned dummy;
	       _dos_setdrive( drive , &dummy ) ;
	    }
	  #else
	    bdos( 0x0e /* Select Disk */, drive-1 , 0 );
	  #endif
	    p = getcwd( base, F_MAX_PATH  );
	    ChangeDirectory( orgDir );
	    free( orgDir );
	}
	else
	    p = getcwd( base, F_MAX_PATH  );
      #else
	p = getcwd( base, F_MAX_PATH  );
      #endif
	baseFlag = 1;
	if( !p )  /* there was an error retrieving the cwd */
	    strcpy( base, "/__Inv_Dir__/");
    }
    else
	baseFlag = 0;
    buf = xmalloc( F_MAX_PATH ) ;
    FilenameCompr( base ) ;
    FilenameCompr( relname ) ;
    p = buf ;
    rp = relname ;
  #if MSDOSFILESYSTEM
    if( rp[1] == ':' ) {
	*(p++) = *rp ;
	rp += 2 ;
    }
    else
	*(p++) = *base ;
    *(p++) = ':' ;
  #endif
    if( *rp != '/' )  {
      #if MSDOSFILESYSTEM
	strcpy( p, base+2 );
      #else
	strcpy( p , base );
      #endif
	p += strlen( p ) ;
	*(p++) = '/' ;
    }
    strcpy( p, rp ) ;
    FilenameCompr( buf ) ;
    strcpy( relname, buf ) ;
    free( buf ) ;
    if( baseFlag )
	free( base );
    return relname ;
}


#ifdef DOCUMENTATION
@Summary FilenameCompr	   compress a filename
 #include <wk/file.h>

 char *FilenameCompr( name );
 char	*name ; 	Filename
@Description
 Die Funktion filename_compress komprimiert Pathnamen.	Grobuchstaben
 werden in Kleinbuchstaben gewandelt ( nur bei MSDOS oder OS2-FAT).
 Alle  \  werden durch '/' ersetzt.
 Doppelte '/' werden entfernt.  Innere relative Pfadangaben werden
 substituiert.
@Return Value
 Pointer to name
@See Also
 FilenameMkAbs
#endif

char *FilenameCompr( char *name )
{
    register char *s ;
    int cnt, flg, fsType;

    fsType = FileQryFS( name );
    for( s = name ; *s ; s++ )
	*s = *s == (char)'\\' ? (char)'/' : *s;

    s = name ;
    if( fsType == F_FS_FAT )
	strlwr(name);
    if( *s == '.' && s[1] == '/' )
	StrNShift( s, -2, 0 ) ;
    cnt = flg = 0;    /* counter for path components and flag */
    for( ; *s ; s++ )
	if( *s == '/' ) {
	    flg = 0 ;
	    if( s[1] == '/' )
		StrNShift( s-- , -1, 0 ) ;
	    else if(  s[1] == '.' )
		if( s[2] == '/' )
		    StrNShift( s-- , -2, 0 ) ;
		else if( s[2] == '.' && cnt ) {
		    register char *t ;

		    cnt--;
		    for( t = s - 1 ; t > name && *t != '/' ; t-- )
			;
		    if( *t == '/' )
			strcpy( t + 1, s + 2 ) ;
		    else
			StrNShift( t + 3 , -1, 0 ) ;
		    s = t - 1 ;
		}
		else if( !s[2] ) { /* thats:  "<path>/." */
		    s[1] = '\0';
		    break;
		}
	}
	else if( *s != '.' ) {
	    if( !flg ) {
		cnt++;
		flg++;
	    }
	}

    if( !*name )
	strcpy(name, "/");  /* somewhat strange, but who knows */

    /* special handling, because root is strange on FAT Systems */
    if( strlen( name ) == 4 )	/* is it like: "?:/." */
	if( name[1] == ':' && name[2] == '/' && name[3] == '.' )
	    if( fsType == F_FS_FAT )  /* and on FAT */
		name[3] = '\0';
    return name ;
}



#ifdef DOCUMENTATION
@Summary Filename2Str
 #include <wk/file.h>

 char *Filename2Str( name, buffer, bufLen );
 const char *name;	Name of file
 char *buffer;		Buffer to receive filename
 size_t bufLen; 	length of buffer ( > 10 )
@Description
 This function copies name to buffer, buffer will be terminated with
 0 (included in bufLen). Use this function to make a string representation of
 a filename, which ist too long to fir into a given buffer.
@Return Value
 buffer
#endif /*DOCUMENTATION*/

char *Filename2Str( const char *name, char *buffer, size_t bufLen )
{
    size_t nameLen, i;
    const char *s;
    char *d;

    xassert( bufLen > 10 );
    nameLen = strlen( name );
    if( nameLen < bufLen )
	strcpy( buffer, name );
    else {  /* is too long */
	/* copy from end to begin ( start with the terminators ) */
	for( d = buffer+bufLen, s = name+nameLen, i=0; i < bufLen; i++ )
	    *d-- = *s--;
	/* and insert the begining */
	s = name;
	d = buffer;
	for(i=0; i < 3; i++ ) /* e.g. "c:/" */
	    *d++ = *s++ ;
	for(i=0; i < 5 ; i++ )
	    *d++ = "<...>"[i] ;
    }
    return buffer;
}

/**** bottom of file ****/
