/* [file10.c wk 5.6.91] Extension funktions
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /usr/src/master/libs/wklib/file10.c,v 1.6 1995/03/30 12:12:16 wernerk Exp $
 */


#include <wk/tailor.h>
RCSID("$Id: file10.c,v 1.6 1995/03/30 12:12:16 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/io.h>
#include <wk/file.h>

#ifdef DOCUMENTATION
@Summary FileExtCheck
 #include <wk/file.h>

 int FileExtCheck( name );
 const char *name;	zu untersuchender Dateiname
@Description
 Untersucht Dateinamen auf Vorhandensein einer Extension.
 Ein Punkt alleine ist bereits eine Extension.
@Return Value
 0 wenn keine Extension vorhanden ist;
 sonst Lnge der Extesion incl. '.'
@See Also
 FileExtAppend
#endif /*DOCUMENTATION*/

int FileExtCheck( const char *nam )
{
    int i, j ;
    const char *p;

    i = j = FileDrvCheck( nam ) ;
    if( nam[j] == '.' ) {
        if( nam[j+1] == '/' || nam[j+1] =='\\' )
	    i = j+1 ;
        if( nam[j+1] == '.' && ( nam[j+2] == '/' || nam[j+2] =='\\' ) )
	    i = j+2 ;
    }

    if( p = strrchr( nam+i, '.' ) )  /* changed from strchr to strrchr to */
	return strlen(p);	     /* support UNIX and HPFS */
    else
	return 0;

}


#ifdef DOCUMENTATION
@Summary FileDrvCheck
 #include <wk/file.h>

 int FileDrvCheck( name );
 const char *name;	zu untersuchender Dateiname
@Description
 Untersucht Dateinamen auf Vorhandensein eines Laufwerkbuchstabens.
 Ein Laufwerk kann 3-stelligsein und muss durch einen Doppelpunkt
 gekennzeichnet sein. (wegen Novell-Volumenames)
@Return Value
 Gibt 0 zurck wenn kein Laufwerk im Dateinamen
 sonst die Lnge der Laufwerkangabe ("SYS:PUBLIC" ergibt 4)
@See Also
 FileExtCheck
#endif /*DOCUMENTATION*/

int FileDrvCheck( const char *nam )
{
  int j ;

  for( j = 0 ; nam[j] && nam[j] != ':' && j < 4 ; j++ )
	;
  return  nam[j] == ':' ? j + 1 : 0 ;
}




#ifdef DOCUMENTATION
@Summary FileExtAppend
 #include <wk/file.h>

 int FileExtAppend( name, ext );
 char *name;		Filename
 const char *ext;	Extension; mit oder ohne Punkt
@Description
 Diese Funktion hngt an einen Filenamen eine max. 3-stellige Extension
 an, bzw. berschreibt eine bereits Vorhandene. Der Buffer fr Filename
 muss noch gengend Platz fr die Extension aufweisen
@Return Value
 Offset des Punktes im Filenamen
@See Also
 FileExtCheck
#endif /*DOCUMENTATION*/


int FileExtAppend( char *name, const char *ext )
{
    int extPos;

    extPos = strlen(name) - FileExtCheck( name );
    name += extPos;
    if( *ext != '.' )
        *name = '.';
    strcpy( name+1, ext );

    return extPos;
}



/****************
 * retrieve the fname from a path
 * returns a pointer to path
 */

const char *FileGetFName( const char *path )
{
    const char *p;

    p = path + strlen(path);
    if( p != path )
	for( p--; p != path; p-- )
            if( *p == '/' || *p == '\\' || *p == ':' )
		return p+1;
    return path;
}



/******* bottom of file *******/
