/* [wk/direc3.c wk 31.8.91] ChangeDirectory()
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * 02.01.93 wk	EMX Support
 * 19.07.94 wk	a trailing slash is now allowed.
 */

#include <wk/tailor.h>
RCSID("$Id: direc3.c,v 1.12 1997/05/21 14:46:01 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <wk/lib.h>
#if __ZTC__
   #include <direct.h>
#endif
#ifdef __MINGW32__
   #include <direct.h>
#endif
#if EMX
  #include <os2.h>
#elif MSDOS || DOS386 || DOS16RM
  #include <dos.h>
#elif OS2
  #include <os2.h>
#endif
#include <wk/file.h>
#include <wk/direc.h>
#include <wk/string.h>
#include <wk/io.h>


#ifdef DOCUMENTATION
@Summary ChangeDirectory
 #include <wk/direc.h>

 int ChangeDirectory( path );
 const char *path;	    full new pathname with drive !
@Description
 Same as chdir, but if a drive is specified, this drive will be the
 new default drive
@Return Value
 Returns 0 if successfull ( errno undefined on error )
#endif



int ChangeDirectory( const char *dir )
{
  #ifdef MSDOSFILESYSTEM
  #if __WATCOMC__
    unsigned drive, dummy ;
  #else
    ushort drive, dummy ;
  #endif
    int i,j;
    char *p;


    if( (i = FileDrvCheck( dir )) ) {
	drive = toupper( *dir ) - 'A' + 1 ;
	if( i > 2 )   /* only single letter drive spec supported */
	    dummy = drive+1; /* so force error */
	else {
	    if( strlen( dir ) == 2 )
		dir = ""; /* no need to change directory */
	  #if EMX && !OS20
	    _chdrive( 'A' + drive - 1 );
	    dummy = _getdrive();
	    dummy = toupper( dummy ) - 'A' + 1 ;
	  #elif WINNT /* FIXME: ue win32 api */
	    _chdrive( 'A' + drive - 1 );
	    dummy = drive;	  /* FAKED! */
	  #elif OS20
	    dummy = DosSetDefaultDisk( drive ) ? drive+1 : drive ;
	  #elif OS2
	    dummy = DosSelectDisk( drive ) ? drive+1 : drive ;
	  #elif __MSC__ || __WATCOMC__
	    _dos_setdrive( drive , &dummy ) ;
	    _dos_getdrive( &dummy ) ;
	  #else
	    bdos( 0x0e /* Select Disk */, drive-1 , 0 );
	    dummy = (bdos( 0x19 /* get current Disk */, 0, 0)&0xff) + 1 ;
	  #endif
	}
    }
    else
	dummy = drive = 0;

    if( dummy!=drive )
	return -1;
    if( !*dir )
	return 0;
    i = dir[(j=strlen(dir))-1];
    if( i == '/' || i =='\\' ) { /* remove trailing slash */
	if( !((drive && j==3) || (!drive && j==1)) ) {
	    /* but only if it is not the root */
	    p = xstrdup(dir);
	    p[strlen(p)-1] = 0;
	    i = chdir(p)? -2 : 0;
	    free(p);
	    return i;
	}
    }
    return chdir( (char*)dir ) ? -2 : 0;

  #else /* no drive letters; we hope it is correctly as const char * defined*/
    return *dir? chdir(dir) : 0;
  #endif
}


/*** bottom of file ****/
