/* [wk/wam.h wk 12.12.92] Defs for WAM
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *	     "Werners Application Model"
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: wam.h,v 1.20 1996/09/25 16:20:32 wk Exp $
 */

#ifndef HDR_WK_WAM
#define HDR_WK_WAM 1
#include <stdarg.h>
#include <wk/lib.h>
#include <wk/string.h>
#if __cplusplus
extern "C" {
#endif

#define _wamapi _dllapi  /* wamapi was used in old source files */

#define E_WAM_NOERROR	    0	/* dummy: kein error */
#define E_WAM_MEMORY	    1	/* out of memory */
#define E_WAM_RESOURCE	    2	/* out of other resources */
#define E_WAM_THREAD	    3	/* thread error (creating thread) */
#define E_WAM_INVTID	    4	/* invalid thread id */
#define E_WAM_NOTTERM	    5	/* not terminated(e.g. no threads terminated)*/
#define E_WAM_NOTRUN	    6	/* not running(e.g. no other threads running)*/
#define E_WAM_TIMEOUT	    7	/* timeout */
#define E_WAM_FRCDTERM	    8	/* forced termination */
#define E_WAM_AQFULL	    9	/* ASend queue is full */
#define E_WAM_NOGUI	   10	/* no (G)UI available */
#define E_WAM_GUIINV	   11	/* (G)UI invalid */
#define E_WAM_GUIFOUND	   12	/* (G)UI not found */

/* Errors returned by i_msg(Database,sym_getLastError) */
#define WAMDB_E_NO_CORE     1	/* out of core in wam interface */
#define WAMDB_E_INV_HANDLE  2	/* invalid WamSQL handle */
#define WAMDB_E_DB_BUG	    3	/* Wam detected a bug in the DB driver */
#define WAMDB_E_WAM_BUG     4	/* Wam detected a bug in itself */
#define WAMDB_E_NO_CONNECT  5	/* no connection to database */
#define WAMDB_E_DT_NOT_SUP  6	/* Datentyp wird von Wam nicht untersttzt */

#define WAMDB_E_CANCELED    10	/* command was canceled */
#define WAMDB_E_NO_DATA     11	/* no (more) data found */
#define WAMDB_E_MISSING_VAL 12	/* ein mandatory feld ist nicht gefllt */
#define WAMDB_E_INV_DBNAME  13	/* invalid database name */
#define WAMDB_E_INV_USER    14	/* invalid user name */
#define WAMDB_E_INV_PASS    15	/* invalid password */
#define WAMDB_E_DUP_KEY     16	/* duplicate key */

#define WAMDB_E_PROT_FAILED   70  /* sql string was protected and this failed */
#define WAMDB_E_VAR_MISMATCH  71  /* host variable mismatch */
#define WAMDB_E_UNCLOSED_STR  72  /* unclosed string constant */

#define WAMDB_E_MOD_NOT_AVAIL 80  /* DB-Module not available */
#define WAMDB_E_MOD_NOT_FOUND 81  /* DB-Module not found */
#define WAMDB_E_MOD_INVALID   82  /* DB-Module is invalid */
#define WAMDB_E_MOD_INV_VER   83  /* DB-Module with invalid version */
#define WAMDB_E_MOD_DUP_LOAD  84  /* duplicate load */

#define WAMDB_E_EXECUTING   91	/* other return codes from DB functions */
#define WAMDB_E_NEED_DATA   92
#define WAMDB_E_DB_ERROR    93
#define WAMDB_E_DB_HANDLE   94
#define WAMDB_E_DB_INV_ARG  95

#define WAMDB_E_UNKNOWN_RC 100	/* unknown rc from sql function */
#define WAMDB_E_NOT_MAPPED 101	/* Unmapped SQL Error */


/* Message Box Types */
#define WAM_INFO	1   /* Info */
#define WAM_WARNING	2   /* Warning */
#define WAM_ERROR	3   /* Error */
#define WAM_FATAL	4   /* Fatal Error */
#define WAM_ABORT	5   /* Fatal Error - Application will be aborted */
#define WAM_QUERY	6   /* query with YES and NO Button */
#define WAM_VERIFY	7   /* query with OKAY anc CANCEL Button */
#define WAM_DEBUG	8   /* Show Debugging informations */
#define WAM_MSGBOX_NOWAIT 128

/* Message Box return Codes */
#define WAM_CANCEL	0   /* Cancel or No-Button (in 2-Button box) pressed */
#define WAM_NOTOKAY	1   /* No Button pressed */
#define WAM_OKAY	2   /* Okay or Yes Button pressed */

/* Internal datatypes */
#define WAM_DT_VOID	0   /* undefined datatype - must be 0 */
#define WAM_DT_STRING	1   /* asciiz String (max len=255 ) */
#define WAM_DT_INTEGER	2   /* Integer (always signed long) */
#define WAM_DT_FLOAT	3   /* really a C-Double */
#define WAM_DT_DATE	4   /* Date (julian) */
#define WAM_DT_TIME	5   /* Time (microseconds) */
#define WAM_DT_TSTAMP	6   /* TimeStamp (Date and Time in Microseconds) */
#define WAM_DT_SYMBOL	7   /* Symbol */


/****** types ********/

typedef struct s_objPRIVATE *id;
typedef struct s_objSHARED  *isa_t;

typedef struct s_objPRIVATE *symbol_t;
#define DCLSYM extern symbol_t
typedef unsigned long wamSemaphore_t;
typedef struct {
	long d; /* julian date */
	long t; /* timeofDay in milliseconds */
    } timeStamp_t;


/* type for generic functions and declaration macros */
typedef id  (*objfnc_t)(id,va_list);  /* self, arg_ptr */

#define DCLFMTHD(a)  WamCreateFMethod( self->isa, #a, (objfnc_t)F_##a );
#define DCLMTHD(a)   WamCreateIMethod( self->isa, #a, (objfnc_t)I_##a );

#define DCLFOBJFNC(a)	 static id F_##a( id self, va_list arg_ptr)
#define DCLFOBJFNC_i(a)  static int F_##a( id self, va_list arg_ptr)

#define DCLOBJFNC(a)   static id I_##a( id self, va_list arg_ptr)
#define DCLOBJFNC_i(a) static int I_##a( id self, va_list arg_ptr)
#define DCLOBJFNC_I(a) static unsigned I_##a( id self, va_list arg_ptr)
#define DCLOBJFNC_p(a) static char *I_##a( id self, va_list arg_ptr)
#define DCLOBJFNC_P(a) static const char *I_##a( id self, va_list arg_ptr)
#define DCLOBJFNC_s(a) static symbol_t	  I_##a( id self, va_list arg_ptr)
#define DCLOBJFNC_v(a) static void *I_##a( id self, va_list arg_ptr)
#define DCLOBJFNC_d(a) static double I_##a( id self, va_list arg_ptr)
#define DCLOBJFNC_a(a) static id *I_##a( id self, va_list arg_ptr)

#define sym(a)	WamCreateSymbol( #a )
#define sel(a)	WamCreateSymbol( #a )  /* only for brevity; same as sym() */
#define symName(a) WamQuerySymbolName( a, NULL, 0 )

#define msg(r,s)      WamSendMsg((r),(s))
#define i_msg(r,s)   (int)WamSendMsg((r),(s))
#define I_msg(r,s)   (unsigned)WamSendMsg((r),(s))
#define p_msg(r,s)   (char*)WamSendMsg((r),(s))
#define P_msg(r,s)   (const char*)WamSendMsg((r),(s))
#define s_msg(r,s)   (symbol_t)WamSendMsg((r),(s))
#define v_msg(r,s)   (void *)WamSendMsg((r),(s))
#define a_msg(r,s)   (id *)WamSendMsg((r),(s))

#define msg1(r,s,a)	WamSendMsg((r),(s),(a))
#define p_msg1(r,s,a)	(char*)WamSendMsg((r),(s),(a))
#define s_msg1(r,s,a)	(symbol_t)WamSendMsg((r),(s),(a))

#define msg2(r,s,a,b)	  WamSendMsg((r),(s),(a),(b))
#define msg3(r,s,a,b,c)   WamSendMsg((r),(s),(a),(b),(c))
#define msg4(r,s,a,b,c,d) WamSendMsg((r),(s),(a),(b),(c),(d))

#define i_msg1(r,s,a)	  (int)WamSendMsg((r),(s),(a))
#define i_msg2(r,s,a,b)   (int)WamSendMsg((r),(s),(a),(b))
#define i_msg3(r,s,a,b,c) (int)WamSendMsg((r),(s),(a),(b),(c))

#define msgSuper(s)	 WamSendMsgSuper(factory,self,(s))
#define msgSuper1(s,a)	 WamSendMsgSuper(factory,self,(s),(a))
#define msgSuper2(s,a,b) WamSendMsgSuper(factory,self,(s),(a),(b))
#define msgSuper3(s,a,b,c) WamSendMsgSuper(factory,self,(s),(a),(b),(c))

/* Shorthands */

#define newObj(r)	WamSendMsg((r),sym_new)
#define freeObj(r)	do { if((r)) { WamSendMsg((r),sym_free); \
						(r) = nil;}  } while(0)

#define newString(v)	WamSendMsg(String,sym_create,(v))
#define newSymbol(v)	WamSendMsg(Symbol,sym_create,(v))
#define newInteger(v)	WamSendMsg(Integer,sym_create,(v))
#define newFloat(v)	WamSendMsg(Float,sym_create,(v))
#define newDate(v)	WamSendMsg(Date,sym_create,(v))
#define newTime(v)	WamSendMsg(Time,sym_create,(v))
#define newTimestamp(v) WamSendMsg(Timestamp,sym_create,(v))

#define getString(r)	(char*)WamSendMsg((r),sym_getValue)
#define putString(r,s)	       WamSendMsg((r),sym_putValue,(s))
#define getSymbol(r) (symbol_t)WamSendMsg((r),sym_getValue)
#define getInteger(r)	 (long)WamSendMsg((r),sym_getValue)
#define putInteger(r,s)        WamSendMsg((r),sym_putValue,(s))
#define getFloat(r)  *(double*)WamSendMsg((r),sym_getValue)
#define putFloat(r,s)	       WamSendMsg((r),sym_putValue,(s))




/*****	  *******/
#define nil (id)0
#define Nil (isa_t)0

struct s_objSHARED {
    char  eye[32];  /* eye catcher: nur zum debuggen */
    isa_t super;
    /* Dies ist ein ptr auf die superclass; wird durch Aufruf
     * von WamSUC_...() zur Runtime gesetzt. Die einzige Ausnahme ist
     * die Class Object, welche eine Sonderbehandlung hat und hier immer
     * NULL stehen hat.
     */

    symbol_t name;
    /* Name des Shared Parts */


    isa_t nameLink;
    /* Dies ist eine Verbindung zur naechsten Class, diese kann irgendwo
     * in der Hierachie liegen; hiermit wird eine einfach verkettete
     * Liste ueber alle dem System bekannten Classes implementiert.
     * Dies ist notwendig um z.B. anhand eines ClassNames eine Class
     * auffinden zu koennen. Die Class Object legt die Classes an
     * und pflegt auch diese Linked-List
     */

    id	   selfLink;	/* backlink to my Private Part */
			/* needed to find the id of a class by Name */

    size_t privateSize; /* = sizeof(struct s_objPRIVATE) of all classes*/
    size_t privateOff;	/* offset to selfs own s_objPRIVATE */

    void  *fMthTbl;	/* pointer to the factory-method table */
    void  *iMthTbl;	/* pointer to the instance-method table */
    struct {
	void  *list;
	size_t used;
	size_t limit;
    } attic;		/* infos about freed instances */
    ulong   icount;	/* number of instances */
    void   *data;	/* optional transient data area */
};

#define CREATECLASS(n) do { xassert( !self->isa->name ); \
	     xassert(factory); /* to avoid "unused static var" cc warning */ \
	     mem2str( self->isa->eye, n, 32 ); \
	     self->isa->name = WamCreateSymbol( n ); \
	     self->isa->selfLink = self; \
	     self->isa->privateSize = sizeof(struct s_objPRIVATE); } while(0)

/* Aufbau des PrivateParts
 *  isa_t isa;	   unused in instances of super classes
 *   [ Der Zugriff auf die Variablen darf nur via DCL_var() und var->xxx
 *     erfolgen; var->isa ist in keinem Fall gueltig; self->var ist gueltig;
 *     self->xxx ist nie gueltig! ]
 *    variables of Class Object
 *    variables of SubClass A of Object
 *    variables of SubClass of Subclass A
 *    etc.
 */
#define BEGIN_DCLPRIVATEPART  struct s_objPRIVATE { isa_t isa;
#define END_DCLPRIVATEPART    };


/****************
 * Den shared part aufbauen:
 * es wird eine Variabel mit dem Namen der Class  und eine identische
 * aber static und mit dem namen factory angelegt.
 */
#define DCLSHAREDPART(a)  static struct s_objSHARED  objSharedPart;    \
			  static struct { isa_t isa;		       \
			  } factoryPrivateData = { &objSharedPart };   \
				       id a = (id)&factoryPrivateData; \
			  static id factory = (id)&factoryPrivateData;

#ifndef CLASS_IMPLEMENTATION /* each class has its own structure */
BEGIN_DCLPRIVATEPART   /* must resolve the typedef for "id" */
END_DCLPRIVATEPART
#endif


#if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7 )
#define DCL_arg(t,a)	t a __attribute__ ((unused)) = va_arg(arg_ptr,t)
#else
#define DCL_arg(t,a)	t a = va_arg(arg_ptr,t)
#endif
#define DCL_var() id var = (id)((char*)self + factory->isa->privateOff)
#define SET_var(a) do {var=(id)((char*)(a)+factory->isa->privateOff);} while(0)
#define SET_varx(v,a) do {(v)=(id)((char*)(a)+factory->isa->privateOff);} while(0)

/****** some special types *****/


/****************
 * Zum erzeugen eines Tableobjects ist ein Array der folgenden Struktur
 * zu benutzen. Das Ende des Arrays wird durch .name==NULL gekennzeichnet.
 */

typedef struct {
    const char *name;  /* Name der Column */
    int   type;        /* DatenType (WAM_DT_....) */
    size_t len;        /* laenge der column (nur be String) */
} tableDefinition_t;

/* Ein type for the gui filter feature */
typedef const char *(*itemFilterFnc_type)(id,char*,size_t);


/**** some often used symbols ****/
/*(initialized by WamInitialized)*/

DCLSYM	 sym_ChildClosed, sym_ChildOpened, sym_Database,
	 sym_ItemValueChange, sym_TimerTick, sym_groupItems,
	 sym_False, sym_Float, sym_Form, sym_FormItem, sym_FormItemInteger,
	 sym_FormItemKey, sym_FormItemNumber, sym_FormItemText,
	 sym_FormItemToggle, sym_FormItemMenu, sym_FormItemCheckMenu,
	 sym_Integer, sym_Message, sym_Object, sym_isNull,
	 sym_getCheckedItem,
	 sym_String, sym_True, sym_View, sym_abortTran, sym_add,
	 sym_addAsDBString, sym_addItem, sym_addRow, sym_allocAsDBString,
	 sym_args, sym_asArray, sym_asDictionary,sym_at,sym_atPut,sym_atPutAF,
	 sym_attachActionTo, sym_attachForm, sym_createForm, sym_beginBlock,
	 sym_beginTran, sym_cancel, sym_cancelChild, sym_cancelChildren,
	 sym_car, sym_cdr, sym_changed, sym_class, sym_clear, sym_close,
	 sym_closeRequested, sym_command, sym_copy, sym_create, sym_debug,
	 sym_deepFree, sym_disable, sym_display, sym_doesNotRecognize,
	 sym_enable, sym_setEnablement, sym_setEditable, sym_atIndex,
	 sym_endBlock, sym_endTran, sym_enumClose, sym_enumGet,
	 sym_enumOpen, sym_error, sym_errorMsg, sym_errorNoSuperClass,
	 sym_event, sym_fatalMsg, sym_focus, sym_form, sym_formatTable,
	 sym_free, sym_get, sym_getSymbol, sym_getValue, sym_gotFocus,
	 sym_hideWindow, sym_iClear, sym_iCopy, sym_iDelete, sym_iEnd,
	 sym_iList, sym_iOkay, sym_iPass, sym_iSave, sym_iSearch,
	 sym_iSelect, sym_iUser, sym_user, sym_infoMsg, sym_initialize,
	 sym_insert, sym_isEqual, sym_item, sym_lockParent, sym_lockWindow,
	 sym_lostFocus, sym_maximize, sym_messageBox, sym_minimize,
	 sym_name, sym_new, sym_newItem, sym_notify, sym_open,
	 sym_openInitializationForForm, sym_openInitialization,
	 sym_openSingle, sym_position, sym_postOpenInitialization,
	 sym_put, sym_putAF, sym_putSymbol, sym_putValue, sym_clearValue,
	 sym_putFromTable, sym_getToTable, sym_putLabel,
	 sym_queryBox, sym_remove, sym_removeAt, sym_reopen, sym_restore,
	 sym_seekTo, sym_sendToParent, sym_parent, sym_setFocus,
	 sym_setFocusTo, sym_setLength, sym_setPrecision,
	 sym_setSelection, sym_setTitle, sym_setView, sym_show,
	 sym_showWindow, sym_size, sym_sql, sym_sqlFailure,
	 sym_subclassResponsibility, sym_terminated, sym_asDBString,
	 sym_unlockWindow, sym_update, sym_verifyBox, sym_view, sym_modified,
	 sym_resetModify,
	 sym_today, sym_now, sym_asShortString, sym_Nil, sym_isKindOf,
	 sym_isMemberOf, sym_isEmptyOrNil, sym_readOnly, sym_readWrite,
	 sym_setAutoFree, sym_contains, sym_fieldValues, sym_argsFromChild,
	 sym_registerProtection, sym_deRegisterProtection, sym_Array,
	 sym_lock, sym_unlock, sym_argAt, sym_isGT, sym_isGE,sym_isLT,sym_isLE,
	 sym_next, sym_previous, sym_isTrue, sym_asString, sym_asNumber,
	 sym_addString, sym_getSelection, sym_insertMode, sym_overtypeMode,
	 sym_registerAs, sym_existsColumn, sym_warningMsg, sym_date, sym_time;


/*** other globals ****/
extern const char *wamApplicationName;

/***** prototypes *****/

const char * _wamapi WamDLLInfo(int);
const char * _wamapi WamDLLInfoDB(int);
const char * _wamapi WamDLLInfoGUI(int);

/* --- init.c --- */
void WamInitialize(void);
void WamSUCStdClasses(void);

/* --- process.c --- */
void WamEnterProcess( int (*fnc)(long), long parm);
void WamLeaveProcess( int r, int cc );
int  WamCreateThread( int *rTid, int (*fnc)(long), long parm, size_t stk );
int  WamSetReleaseThreadFlag( int tid );
int  WamWaitThread( int *tid, int *rCC );
int  WamCheckThread( int *ptid, int *rcc );
int  WamSuspendThread( int tid );
int  WamResumeThread( int tid );
int  WamGetMyTID(void);
int  WamSemaphore( wamSemaphore_t *sem, int opCode, ulong timeout );

#define DCL_SERIALIZE(a)    static wamSemaphore_t a
#define BEGIN_SERIALIZE(a)  WamSemaphore( &a, 1, -1L )
#define BEGIN_SERIALIZE2(a,t)  WamSemaphore( &a, 1, (t) )
#define END_SERIALIZE(a)    WamSemaphore( &a, 2, 0 )

#define RESET_SEMAPHORE(a)  WamSemaphore( &a, 3, 0 )
#define POST_SEMAPHORE(a)   WamSemaphore( &a, 4, 0 )
#define WAIT_SEMAPHORE(a)   WamSemaphore( &a, 5, -1L )
#define WAIT_SEMAPHORE2(a,t)  WamSemaphore( &a, 5, (t) )

/* --- symbols.c --- */
symbol_t WamCreateSymbol( const char *name );
symbol_t WamCreateSymbolWithLen( const char *name, size_t len );
symbol_t WamFindSymbol( const char *name );
char	*WamQuerySymbolName( symbol_t sym, char *buf, size_t buflen );
symbol_t WamCapitalizeSymbol( symbol_t name );

/* --- syminit.c --- (generated during link phase) */
  /* these functions are generated by symcllct.c for each DLL- and EXE */
void SymbolInitialization(void);
void BindAppClasses(void);

/* --- gui.c ---*/
int  _wamapi WamLoadGUI( const char *moduleName );
void _wamapi WamSetGUIOption( const char *option, int val );
void _wamapi WamStartupGui(void);
int  _wamapi WamWaitForEvent(int);
void _wamapi WamRegisterForm( id form, int dlg );
void _wamapi WamAddWindowMenu( id form,int parent,int pos, char **textArr, int *idArr);

int WamUserAttention( int attNr );
int WamRegAttentionFlag( volatile int *flag );



/****** class oriented functions *****/

/* --- messager.c ---*/
void WamInitializeMessager(void);
symbol_t WamCreateFMethod( isa_t isa, const char *nane, objfnc_t fnc );
symbol_t WamCreateIMethod( isa_t isa, const char *name, objfnc_t fnc );
void WamRehashMethodTables(void);
id WamSendMsg( id receiver, symbol_t selector, ...);
id WamVSendMsg( id receiver, symbol_t selector, va_list arg_ptr );
id WamSendMsgSuper( id myFact, id receiver, symbol_t selector, ...);
objfnc_t WamRespondsTo( id receiver, symbol_t aSelector );
int WamASend( id receiver, symbol_t selector, id args);
void WamMessageLoop( int (*termfnc)(int,void*), void *parm );
void WamSetMessagerOption( int option, int value );
int  WamGetMessagerOption( int option );


/* --- object.c --- */
void WamSUCFinish(void);
void WamSUC_Object(void);
void WamSubclassClass( symbol_t parentName, id anID );
id   WamGetFactoryByName( symbol_t name );
int WamIsMemberOf( id self, id aClass );
int WamIsKindOf( id self, id aClass );
void WamSetAtticLimit( id self, size_t newLimit );

extern id Object;
extern id True;  /* predefined Instance of Object */
extern id False;  /* predefined Instance of Object */
extern id Null;   /* predefined Instance of Object */

/**** SetUpClass prototypes for some standard classes ****/

void WamSUC_String(void);  /* string.c */
extern id String;

void WamSUC_Symbol(void);  /* symbol.c */
extern id Symbol;

void WamSUC_Message(void); /* message.c */
extern id Message;

void WamSUC_Integer(void); /* integer.c */
extern id Integer;

void WamSUC_Float(void); /* float.c */
extern id Float;

void WamSUC_Date(void); /* date.c */
extern id Date;
void WamSUC_Time(void); /* time.c */
extern id Time;
void WamSUC_Timestamp(void); /* timestamp.c */
extern id Timestamp;

void WamSUC_IdArray(void); /* IdArray.c */
extern id IdArray;
extern id Array;    /* preferred name of Class */
void WamSUC_StringArray(void); /* StrgArry.c */
extern id StringArray;
void WamSUC_WordArray(void); /* wordarray.c */
extern id WordArray;

void WamSUC_SymbolSet(void); /* SymbSet.c */
extern id SymbolSet;

void WamSUC_Dictionary(void); /* Dctnry.c */
extern id Dictionary;
void WamSUC_SymbolDictionary(void); /* SymblDct.c */
extern id SymbolDictionary;


void WamSUC_Form(void); /* form.c */
extern id Form;
void WamSUC_AutomaticForm(void); /* autoform.c */
extern id AutomaticForm;

void WamSUC_FormItem(void); /* formitem.c */
extern id FormItem;
void WamSUC_FormItemText(void); /* fitext.c */
extern id FormItemText;
void WamSUC_FormItemNumber(void); /* finumber.c */
extern id FormItemNumber;
void WamSUC_FormItemInteger(void); /* fiint.c */
extern id FormItemInteger;
void WamSUC_FormItemDate(void); /* fidate.c */
extern id FormItemDate;
void WamSUC_FormItemKey(void); /* fikey.c */
extern id FormItemKey;
void WamSUC_FormItemMenu(void); /* fimenu.c */
extern id FormItemMenu;
void WamSUC_FormItemToggle(void); /* fitoggle.c */
extern id FormItemToggle;
void WamSUC_FormItemCheckMenu(void); /* fimenu2.c */
extern id FormItemCheckMenu;
void WamSUC_FormItemRadio(void); /* fitoggle.c */
extern id FormItemRadio;
void WamSUC_FormItemNumericSpin(void); /* finspin.c */
extern id FormItemNumericSpin;
void WamSUC_FormItemValueSet(void); /* fivalset.c */
extern id FormItemValueSet;
void WamSUC_FormItemList(void); /* filist.c */
extern id FormItemList;

void WamSUC_View(void); /* view.c */
extern id View;

void WamSUC_Database(void); /* database.c */
extern id Database;

void WamSUC_Table(void); /* table.c */
id   WamDescribeTableColumns( id self, symbol_t name, int type, size_t len );
void WamDestroyTable( id self );
void WamCreateTableRow( id self,int mode,void *data,size_t dataLen);
extern id Table;
void WamSUC_TableRow(void); /* tablerow.c */
extern id TableRow;




#if __cplusplus
}
#endif
#endif /* HDR_WK_WAM */
