/* [wk/sema.h wk 27.7.90] Defs for Semaphore functions
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 * $Id: sema.h,v 1.4 1995/03/08 16:51:45 wk Exp $
 * History:
 * 06.05.93 wk	Added QuickSemaphore
 */

#ifndef HDR_WK_SEMA
#define HDR_WK_SEMA 1
#ifndef HDR_WK_LIB
    #include <wk/lib.h>
#endif

#if __cplusplus
extern "C" {
#endif

/****** constants *********/
#define SEMA_MAXLEN	128

#define ESEMA_GENERAL_ERROR	1
#define ESEMA_INVALID_NAME	2
#define ESEMA_INVALID_HANDLE	3
#define ESEMA_INVALID_VALUE	4
#define ESEMA_TIMEOUT		5
#define ESEMA_OUT_OF_HANDLES	6

/******** typedefs ********/
typedef unsigned long quickSemaphore_t;
/****** prototypes ********/

#if 0 /* untested */
int SemaOpen( const char *, short, int *);
int SemaClose(int);
int SemaCount(int,ushort*);
int SemaValue(int,short*);
int SemaSignal(int);
int SemaWait(int,long);
const char *SemaErrorText(int);
#endif

int QuickSemaphore( quickSemaphore_t *sem, int opCode, ulong timeout );


#define DCL_SERIALIZE(a)      static quickSemaphore_t a
#define BEGIN_SERIALIZE(a)    QuickSemaphore( &a, 1, -1L )
#define BEGIN_SERIALIZE2(a,t) QuickSemaphore( &a, 1, (t) )
#define END_SERIALIZE(a)      QuickSemaphore( &a, 2, 0 )

#define RESET_SEMAPHORE(a)    QuickSemaphore( &a, 3, 0 )
#define POST_SEMAPHORE(a)     QuickSemaphore( &a, 4, 0 )
#define WAIT_SEMAPHORE(a)     QuickSemaphore( &a, 5, -1L )
#define WAIT_SEMAPHORE2(a,t)  QuickSemaphore( &a, 5, (t) )


#if __cplusplus
}
#endif
#endif /* HDR_WK_SEMA */
