/* [scr.h wk 5.3.91] Defs for Screen Manager
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 * $Header: /usr/src/master/libs/wk/scr.h,v 1.5 1995/03/30 12:12:45 wernerk Exp $
 *
 * define SCR_ONLY_REDIRECTED to include only the functions
 * which will work without the Screen; if the screen is not initialized
 * $Id: scr.h,v 1.5 1995/03/30 12:12:45 wernerk Exp $
 */

#ifndef HDR_WK_SCR
#define HDR_WK_SCR 1
#ifndef HDR_WK_LIB
    #include <wk/lib.h>
#endif

#if __cplusplus
extern "C" {
#endif


/***** constants ********/
#define SCR_STYLE_NOFRAME   0	  /* keinRahmen*/
#define SCR_STYLE_FRAME     1	  /* Rahmen aus einfacher Linie*/
#define SCR_STYLE_DBLFRAME  2	  /* Rahmen aus doppelter Linie*/
#define SCR_STYLE_NOSHADOW  0	  /* Window ohne Schatten*/
#define SCR_STYLE_SHADOW    4	  /* Window mit Schattem*/

#define SCR_MODE_HIDDEN     1	  /* Window is hidden (not on PS) */

#define SCR_CRS_SET	    0	  /* Set Cursor Absolute*/
#define SCR_CRS_SETREL	    1	  /* Set Curosr relative*/
#define SCR_CRS_SHOW	    2	  /* Show Cursor*/
#define SCR_CRS_HIDE	    3	  /* Hide Cursor*/
#define SCR_CRS_FORM_A	    4	  /* Set Cursoform to 1. Form*/
#define SCR_CRS_FORM_B	    5	  /* Set Cursoform to 2. Form*/
#define SCR_MCRS_SHOW	    6	  /* Show Mouse Cursor */
#define SCR_MCRS_HIDE	    7	  /* Hide Mouse Cursor */

#define SCR_CRS_UPDATE	   10	  /* update cursor on phy. screen */

#define SCR_CTRL_REPAINT    1	  /* Set Flag to Repaint Screen */
#define SCR_CTRL_ORGSCR     2	  /* restore Original termianl screen */
#define SCR_CTRL_CLOSEALL   3	  /* Close all Screens */
#define SCR_CTRL_DEINIT     4	  /* Free the whole Screen system */
#define SCR_CTRL_SAVEORGSCR 5	  /* save the original screen */

#define SCR_MSG_FULL	    0	  /* open, show, wait, close*/
#define SCR_MSG_NOCLOSE     1	  /* open, show, wait*/
#define SCR_MSG_WCLOSE	    2	  /* wait, close*/
#define SCR_MSG_WAIT	    3	  /* wait*/
#define SCR_MSG_OPEN	    4	  /* open*/


#define ESCR_GENERAL_ERROR  1
#define ESCR_INVALID_HANDLE 2
#define ESCR_INVALID_VALUE  3
#define ESCR_OUT_OF_RANGE   4
#define ESCR_OUT_OF_HANDLES 5
#define ESCR_OUT_OF_MEMORY  6
#define ESCR_NOT_SUPPORTED  7
#define ESCR_INVALID_ATABLE 8

/******** types *********/
/******* globals ********/
extern int scrErrno;   /* last scr errorcode; defined in scrmod0.c */

/***** Prototypes *******/
const char *ScrDriver(void);
int ScrOpen(int*,int,int,int,int, int,byte,ushort, ushort);
int ScrClose(int);
int ScrHide(int);
int ScrShow(int);
int ScrIsVisible(int);
int ScrHasFocus(int);
int ScrUpdate(int);
int ScrPrintF( int, const char*,...);
void ScrBeep(void);

void ScrGetStringSize( int, const char *,int*, int*, int*);
int  ScrCalcGlider( long,long,int,int,int*);
int ScrScrollBar(int,int,int,unsigned,long,long,int,int,byte,byte,int*);

int ScrInitialize( int, int, int, int, int, ushort, ushort);
int ScrControl( int, int, int, int );
int ScrInitDriverStd(int, int);     /*Module: scrdrv0.c */
int ScrInitDriverCurses(int, int);  /*Module: scrdrv1.c */
void ScrGetSize( int, int *, int * );
void ScrGetPos( int, int, int *, int * );
int ScrWriteCell( int, int, int, char, byte);
int ScrReadCell( int , int, int, char *, byte *);
int ScrCursor( int, int, int, int);
int ScrMsStat( int *, int *, int *);
int ScrSetAttr( int, byte);
const char *ScrErrorText(int);

#if __cplusplus
}
#endif
#endif /* HDR_WK_SCR */
