/* [wk/regexp.h wk 03.08.93] Definitions etc. for regexp(3) routines.
 *	Copyright (c) 1986 by University of Toronto.
 *	Written by Henry Spencer.  Not derived from licensed software.
 *
 *	Permission is granted to anyone to use this software for any
 *	purpose on any computer system, and to redistribute it freely,
 *	subject to the following restrictions:
 *
 *	1. The author is not responsible for the consequences of use of
 *		this software, no matter how awful, even if they arise
 *		from defects in it.
 *
 *	2. The origin of this software must not be misrepresented, either
 *		by explicit claim or by omission.
 *
 *	3. Altered versions must be plainly marked as such, and must not
 *		be misrepresented as being the original software.
 *** THIS IS AN ALTERED VERSION.  It was altered by John Gilmore,
 *** hoptoad!gnu, on 27 Dec 1986, to add \n as an alternative to |
 *** to assist in implementing egrep.
 *** THIS IS AN ALTERED VERSION.  It was altered by John Gilmore,
 *** hoptoad!gnu, on 27 Dec 1986, to add \< and \> for word-matching
 *** as in BSD grep and ex.
 *** THIS IS AN ALTERED VERSION.  It was altered by John Gilmore,
 *** hoptoad!gnu, on 28 Dec 1986, to optimize characters quoted with \.
 *** THIS IS AN ALTERED VERSION.  It was altered by James A. Woods,
 *** ames!jaw, on 19 June 1987, to quash a regcomp() redundancy.
 *** THIS IS AN ALTERED VERSION.  It was altered by Werner Koch (dd9jn)
 ***	       on 3 Aug 1993, to work with WkLib
 * This file is part of WkLib. See wk/lib.h for details.
 *
 * Caveat:  this is V8 regexp(3) [actually, a reimplementation thereof],
 * not the System V one.
 *
 * $Header: /usr/src/master/libs/wk/regexp.h,v 1.4 1995/03/30 12:12:44 wernerk Exp $
 */

#ifndef HDR_WK_REGEXP
#define HDR_WK_REGEXP 1
#if __cplusplus
extern "C" {
#endif


#define NSUBEXP  10
typedef struct regexp {
	char *startp[NSUBEXP];
	char *endp[NSUBEXP];
	char regstart;		/* Internal use only. */
	char reganch;		/* Internal use only. */
	char *regmust;		/* Internal use only. */
	int regmlen;		/* Internal use only. */
	char program[1];	/* Unwarranted chumminess with compiler. */
} regexp;

regexp *RegComp(const char *exp);
int RegExec(const regexp *prog, const char *string );
#ifdef DEBUG
void RegDump(const regexp *r);
extern int  regNarrate;
#endif
void RegSub( const regexp *prog, const char *source, char *dest );
void RegError(const char *s);

#define RegFree(a) do { free(a); (a)=NULL; } while(0)
#define RegPTR(a)  ((a)->startp[0])
#define RegSTART(a) ((a)->startp[0])
#define RegEND(a)  ((a)->endp[0])
#define RegLEN(a)  ((a)->endp[0] - (a)->startp[0] )

char *RegCopy( const regexp *prog, char *dest , size_t n );

#if __cplusplus
}
#endif

#endif /* HDR_WK_REGEXP */
