/* [wk/rcmgr.h wk 3.6.91] Resource Manager
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 * $Header: /usr/src/master/libs/wk/rcmgr.h,v 1.4 1995/03/30 12:12:43 wernerk Exp $
 */

#ifndef HDR_WK_RCMGR
#define HDR_WK_RCMGR 1
#ifndef HDR_WK_LIB
    #include <wk/lib.h>
#endif
#if __cplusplus
extern "C" {
#endif

/****** constants ******/
#define RC_STRBLK   40
#define RC_STRMSG   41
#define RC_PLAIN    42
#define RC_PDMENU   43
#define RC_DLGWIN   44

/***** globals *****/
extern int rcmInitialized;	   /* true if RCMGR is initialized */

/****** prototypes *****/
void RcmInitialize( const char *exeName );
int  RcmLoadResource( const char *name, int type );
void RcmFreeResource( int handle );
const char *RcmGetStrBlk( int handle, ushort number);
char *RcmTransferStrBlk( int handle );
const char *RcmGetStrMsg( int handle, ushort number);
size_t RcmReadPlain( int handle, void *buffer, size_t nbytes );
long RcmSeekPlain( int handle, long offset, int origin );
const char *RcmQryPDMenu( int handle, ushort *entries );
void RcmGetPDMenu( int handle, ushort number, ushort *buffer );
char *RcmTransferDlgWin( int handle );
size_t RcmReadDlgWin( int handle, int mode, void *buffer, size_t bufSize );


#if __cplusplus
}
#endif
#endif /* HDR_WK_RCMGR */
