/* [wk/mouse.h wk 25.6.91] My own mouse functions
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 * $Header: /usr/src/master/libs/wk/mouse.h,v 1.6 1995/03/30 12:12:42 wernerk Exp $
 */

#ifndef HDR_WK_MOUSE
#define HDR_WK_MOUSE 1

#if __cplusplus
extern "C" {
#endif

    /* mouse button states (bitmasks) */
#define MOUSE_LEFT	1   /* left button is down */
#define MOUSE_RIGHT	2   /* right button is down */
#define MOUSE_LEFTDBL	4   /* left button was double down */
#define MOUSE_RIGHTDBL	8   /* right button was double down */


int MouseInitialize(void);
void MouseTerminate(void);
unsigned MouseGet( int *x, int *y );
void MousePut( int x, int y );
void MouseShow(void);
void MouseHide(void);
void MouseHideCond( int x1, int y1, int x2, int y2 );
long MouseSpeed( int mode, long value );


#if __cplusplus
}
#endif
#endif /* HDR_WK_MOUSE */
