/* [wk/memdbg.h wk 9.1.90] Defs for memdbg package
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 * This file is part of WkLib. See wk/lib.h for details.
 *
 * Heap debug Functions [internal to wk/wklib.h]
 * This will only Work if MEM_DEBUG is defined
 *
 * $Id: memdbg.h,v 1.7 1995/03/08 16:51:24 wk Exp $
 */

#ifndef HDR_WK_DBGMEM
#define HDR_WK_DBGMEM 1
    #include <string.h>  /* because we will redefine some functions */
#ifndef HDR_WK_LIB
    #error this include file must be included from wk/lib.h
           /* so we don't need the c++ stuff */
#endif
#ifdef MEM_DEBUG    /* must be defined */

/**********************************
 *  Public Functions
 **********************************
 */

/***************************
 * Resets memory debug module and
 * checks for not freed pointers and does a consistency check.
 */

void memdbg_reset(void);

/***************************
 * Consistency check over the complete heap.
 */

void memdbg_check(void);

/***************************
 * Checks one pointer.
 */

void memdbg_checkptr(void *ptr);

/****************
 * Informationen ber den Heap zurckgeben
 * level 0 = aktuelle Anzahl der allokierten Bytes
 *	 1 = max allokierte Anzahl von Bytes
 */

long memdbg_info( int level );




/***********************************************
 * Redfinitions of functions
 */


#define strdup(p)   strdup_debug((p),__FILE__,__LINE__)
#if __GNU_LIBRARY__
#undef malloc
#undef calloc
#endif
#define malloc(u)   malloc_debug((u),__FILE__,__LINE__)
#define calloc(u,n) calloc_debug((u),(n),__FILE__,__LINE__)

#define realloc(p,u) realloc_debug((p),(u),__FILE__,__LINE__)
#define free(p)     free_debug((p),__FILE__,__LINE__)
#define FREE(a)     free_debug(a,__FILE__,__LINE__),(a)=NULL

#define xstrdup(p)  xstrdup_debug((p),__FILE__,__LINE__)
#define xmalloc(u)  xmalloc_debug((u),__FILE__,__LINE__)
#define xcalloc(u,n)  xcalloc_debug((u),(n),__FILE__,__LINE__)
#define xrealloc(u,n)  xrealloc_debug((u),(n),__FILE__,__LINE__)

#define reAllocFit(p,n) realloc_debug((p),(n),__FILE__,__LINE__)

char *strdup_debug(const char *,char *,int);
void *calloc_debug(unsigned,unsigned,char *,int);
void *malloc_debug(unsigned,char *,int);
void *realloc_debug(void *,unsigned,char *,int);
void free_debug(void *,char *,int);

char *xstrdup_debug(const char *,char *,int);
void *xrealloc_debug(void *,unsigned,char *,int);
void *xcalloc_debug(unsigned,unsigned,char *,int);
void *xmalloc_debug(unsigned,char *,int);


#endif /* MEM_DEBUG */
#endif /* HDR_WK_DBGMEM */
