/* [wk/lib.h wk 20.1.88] Global Defs
 *	Copyright (c) 1988-93 by Werner Koch (dd9jn)
 *  This file is part of WkLib.
 *
 *  WkLib is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WkLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * $Id: lib.h,v 1.35 1997/06/17 18:07:27 wk Exp $
 *
 * History:
 * 29.12.92 wk	EMX Support
 *  2.01.93 wk	Macros defining a block are now inside a dummy-do-while-loop
 * 26.01.93 wk	IBM C Set/2 Support
 * 06.02.93 wk	BUG,xassert etc fuer C Set erweitert
 * 04.08.93 wk	added DIMof() macro
 * 04.07.94 wk	added WATCOM-C support
 * 20.02.95 wk	exit() redefined
 */

/* Caution: Always assign a nonzero value to a macro.
 * Sometimes we test the value and not the definition.
 */

#ifndef HDR_WK_LIB
#define HDR_WK_LIB 1

#if __cplusplus
extern "C" {
#endif

/*******************************************************************
 * Control directives
 *******************************************************************/
#ifndef HDR_WK_TAILOR
  #error Please use #include <wk/tailor> as first header file
#endif
#if __GNUC__
    #ifndef EMX
	#if defined(OS2) || defined(OS20)
	   #define GNU_C_LIB 1	/* this is the OS/2 port, should be changed*/
	   #define GNU_C_LIB_OS2 1  /* to this constant */
	#endif
    #endif
    #define _dllapi
#elif __IBMC__
    #define _dllapi _System
#elif __WATCOMC__
    #define _dllapi _System
#elif __ZTC__
    #if __ZTC__ < 0x0218    /* Bug prior to Version 2.18 : */
	#ifndef M_I8086     /* M_I286 ist nicht definiert bei -2 */
	    #ifndef M_I286  /* so we will define it here */
		#define M_I286 1
	    #endif
	#endif
    #endif
    #define _dllapi
#elif __MSC__		/* manualy inserted in stdio.h and stdlib.h */
    #define _dllapi
#elif __TURBOC__
    #define _dllapi
#elif _MSC_VER
   #define __MSC__  _MSC_VER  /* __MSC__ is used in a lot of files */
    #define _dllapi
#elif HPUX
    #define _dllapi
#elif POSIX
    #define _dllapi
#else
    #error unknown Compiler
#endif



#ifdef GNU_C_LIB_OS2
    #include <limits.h>     /* CLK_TCK is in limits and not in time.h */
    #ifndef CLOCKS_PER_SEC  /* and this is not defined */
	#define CLOCKS_PER_SEC CLK_TCK
    #endif
#endif

#if __WATCOMC__
#elif __MINGW32__
    #define _far
    #define _near
    #define _cdecl
    #define _pascal
#elif __STDC__ || EMX
    #define _far
    #define _near
    #define _cdecl
    #define _pascal
#elif __IBMC__
    #ifdef __MIG__
       #ifndef NULL
	   #define NULL ((void *)0)
       #endif
    #else
       #define _far
       #define _near
       #define _cdecl
       #define _pascal
    #endif
#elif __MSC__ || __TURBOC__
	#define _far far
	#define _near near
	#define _cdecl cdecl
	#define _pascal pascal
#elif POSIX
    #define _far
    #define _near
    #define _cdecl
    #define _pascal
#endif


#ifdef OS20_PM
    #ifndef OS20
	#define OS20 1
    #endif
    #ifndef OS2_PM
	#define OS2_PM 1
    #endif
#endif


#ifdef OS20	/* OS/2 Version 2.0 includes OS/2 Version 1.x */
    #if OS20 == 0
	#undef OS20
	#define OS20 1
    #endif
    #ifndef OS2
	#define OS2 2
    #endif
#endif

#ifdef OS2_PM
    #ifndef OS2
	#define OS2 1
    #endif
#endif

#if defined(OS2)
    #if defined(DOS386) || defined(DOS16RM) || defined(MSDOS)
       #error more than one OS defined
    #endif
    #if !defined(__OS2__) && __ZTC__
      #define __OS2__ 1     /* Zortech needs this */
    #endif
    #ifndef OS2_PM
	#define INCL_NOPM 1
	#define INCL_NOPMAPI 1 /* for version 2.0 */
    #endif
    #define MULTI_THREADED_OS 1
#elif defined(WINNT)
    #if defined(OS2) || defined(DOS386) || defined(DOS16RM) || defined(MSDOS) \
	|| defined(NETWARE)
       #error more than one OS defined
    #endif
    #define MULTI_THREADED_OS 1
#elif defined(NETWARE)
    #if defined(OS2) || defined(DOS386) || defined(DOS16RM) || defined(MSDOS)
       #error more than one OS defined
    #endif
#elif defined(DOS386)
    #if defined(DOS16RM) || defined(MSDOS)
       #error more than one OS defined
    #endif
#elif defined(DOS16RM)
    #if defined(MSDOS)
       #error more than one OS defined
    #endif
#elif defined(EMX)
    #if defined(OS2) || defined(DOS386) || defined(DOS16RM) || defined(MSDOS)
       #error more than one OS defined
    #endif
#elif defined(HPUX)
    #define M_UNIX 1
    #define UNIX 1
#elif defined(UNIX)
    #if !UNIX
      #undef UNIX
      #define UNIX 1
    #endif
#elif defined(MSDOS)
    #if MSDOS < 1
       #undef MSDOS
       #define MSDOS 1
    #endif
#endif

/* #define WKLIB_BIG_ENDIAN 1 <--- uncomment this for appropiate machines (4321) */
/* #define WKLIB_PDP_ENDIAN 1 <--- uncomment this for a byte order 3412 */
/* or use this Codefragment:
 *  union { long l; char c[sizeof (long)]; } u;
 *  u.l = 1;
 *  bigEndian = u.c[sizeof(long) - 1];
 *
 * Oops: BSD defines BIG_ENDIAN , LITLE_ENDIAN etc. so I should change
 * everything here to WKLIB_BIG_ENDIAN etc,
 */
#if defined(BYTE_ORDER) && defined(BIG_ENDIAN) && defined(LITTLE_ENDIAN)
  #if BYTE_ORDER == BIG_ENDIAN
    #define WKLIB_BIG_ENDIAN 1
  #endif
#elif defined(HPUX)
    #define WKLIB_BIG_ENDIAN 1
#endif

#if SUN || MOTOROLA || defined(HPUX)
  #define ALIGNMENT_REQUIRED  4
#endif

/*******************************************************************
 * Constants
 *******************************************************************/
#if defined(OS20) || defined(EMX) || defined(DOS386) \
    || defined(NETWARE) || defined(WINNT)
	#define NULLF 0L
	#define SIZEOFCODEPTR 32
	#define SIZEOFDATAPTR 32
#elif HPUX
	#define NULLF 0L
	#define SIZEOFCODEPTR 32
	#define SIZEOFDATAPTR 32
#elif __DECC  /* Vax or Axp */
	#define NULLF 0L
	#define SIZEOFCODEPTR 32
	#define SIZEOFDATAPTR 32
#elif __TURBOC__ || __WATCOMC__
    #if defined(__TINY__) || defined(__SMALL__)
	#define NULLF 0
	#define SIZEOFCODEPTR 16
	#define SIZEOFDATAPTR 16
    #elif defined(__COMPACT__)
	#define NULLF 0
	#define SIZEOFCODEPTR 16
	#define SIZEOFDATAPTR 32
    #elif defined(__MEDIUM__)
	#define NULLF 0L
	#define SIZEOFCODEPTR 32
	#define SIZEOFDATAPTR 16
    #else
	#define NULLF 0L
	#define SIZEOFCODEPTR 32
	#define SIZEOFDATAPTR 32
    #endif
    #define MALLOC_CHUNK_LIMIT 65500
#else  /* Microsoft or Zortech */
    #if defined(M_I86SM)
	#define NULLF 0
	#define SIZEOFCODEPTR 16
	#define SIZEOFDATAPTR 16
    #elif defined(M_I86CM)
	#define NULLF 0
	#define SIZEOFCODEPTR 16
	#define SIZEOFDATAPTR 32
    #elif defined(M_I86MM)
	#define NULLF 0L
	#define SIZEOFCODEPTR 32
	#define SIZEOFDATAPTR 16
    #elif defined(M_I86LM) || defined(M_I86HM) || defined(M_I86VM)
	#define NULLF 0L
	#define SIZEOFCODEPTR 32
	#define SIZEOFDATAPTR 32
    #else
	#define NULLF NULL  /* z.B. falls __STDC__ */
    #endif
    #define MALLOC_CHUNK_LIMIT 65500
#endif

/*******************************************************************
 * Typedefs
 *******************************************************************/
typedef unsigned char	byte ;	    /* we assume char is signed */
#if defined(HAVE_USHORT_TYPEDEF) || defined(HAVE_ULONG_TYPEDEF)
#elif __GNU_LIBRARY__ || HPUX || POSIX
  #include <sys/types.h>  /* may define ushort, ulong for sysv compatibility*/
  #if HPUX
    typedef unsigned long  ulong;
  #elif POSIX
    #if  !(__linux__ && defined(_LINUX_TYPES_H))
       typedef unsigned short ushort;
       typedef unsigned long  ulong;
    #endif
  #else
    typedef unsigned short ushort;
    typedef unsigned long  ulong;
  #endif
#elif NETWARE
  #include <sys/types.h>  /* defines ushort, ulong etc. */
#else
    typedef unsigned long   ulong;
  #if !defined(GNU_C_LIB_OS2) || !defined(_STDLIB_H_)
    typedef unsigned short  ushort ;  /* ushort ist dort in stdlib.h definiert*/
  #endif
#endif


/* some more types so we can later support LP64 (Alpha, etc ) */
#if 0 /* LP64 not yet used */
    typedef	     short  int16;
    typedef unsigned short uint16;
    typedef	     int    int32;
    typedef unsigned int   uint32;
    typedef	     long   int64;
    typedef unsigned long  uint64;
#else
    typedef	     short  int16;
    typedef unsigned short uint16;
    typedef	     long   int32;
    typedef unsigned long  uint32;
  #if __GNUC__ > 1
    typedef	     long long	int64;
    typedef unsigned long long uint64;
  #endif
#endif


typedef struct {
     int  *argc;	    /* pointer to argc (value subject to change) */
     char ***argv;	    /* pointer to argv (value subject to change) */
     unsigned flags;	    /* Global flags (DO NOT CHANGE) */
     int err;		    /* print error about last option */
			    /* 1 = warning, 2 = abort */
     int r_opt; 	    /* return option */
     int r_type;	    /* type of return value (0 = no argument found)*/
     union {
	 int   ret_int;
	 long  ret_long;
	 ulong ret_ulong;
	 char *ret_str;
     } r;		    /* Return values */
     struct {
	 int index;
	 int inarg;
	 int stopped;
	 const char *last;
     } internal;	    /* DO NOT CHANGE */
} ARGPARSE_ARGS;

typedef struct {
    int 	short_opt;
    const char *long_opt;
    unsigned flags;
    const char *description; /* optional option description */
} ARGPARSE_OPTS;


/*******************************************************************
 * Global Vars
 *******************************************************************/

extern int syserrno ;
extern int btrvStatus;
extern const char xassertstring[]; /* def'd in bug.c */
extern int (*XAllocFailureHook)( size_t );
extern const char *wklibApplicationName;

/*******************************************************************
 * Prototypes
 *******************************************************************/
const char *CopyRight(int); /* defined in the main module of each Program */
void ShowCopyRight( int level );
const char *WklibCopyRight(int);
const char *WklibDLLInfo(int); /* dllmain.c */
int ArgExpand( int *, char ***, unsigned);
int ArgParse( ARGPARSE_ARGS *args, ARGPARSE_OPTS *opts);
ulong crc_32( int, const char *, size_t, ulong *);
void crc_32AppChar( int c, ulong *crcmerk );
FILE *ErrorStream(FILE*);
int ErrorSnoop( int mode );
int AddCleanUp( void (*)(void*), void*);
void RegisterCleanup( void (*NewFnc)(void) );
int WklibInExit( int *ret_rc );
#if __GNUC__ > 1 && !OS2
    /* this only works with GNU-C 2.5 or higher */
    void wklib_exit( int rc )  __attribute__ ((noreturn));
    void Errorx(int)	       __attribute__ ((noreturn));
    void Bug(const char *,...) __attribute__ ((noreturn, format (printf,1,2)));
    void Bug0(const char*,int) __attribute__ ((noreturn));
    void Bug1(const char*, const char*,int) __attribute__ ((noreturn));
    void Error(int,const char *,...) __attribute__ ((format (printf,2,3)));
    void Fatal(const char *,...)     __attribute__ ((format (printf,1,2)));
    void Info( const char *, ... )   __attribute__ ((format (printf,1,2)));
#else
    void wklib_exit( int rc );
    void Errorx(int);
    void Bug(const char *,...);
    void Bug0(const char*,int);
    void Bug1(const char*,const char*,int);
    void Error(int,const char *,...);
    void Fatal(const char *,...);
    void Info( const char *s, ... );
#endif
const char *GetStr(int);
void *xmalloc(size_t);
void *xcalloc(size_t,size_t);
void *xrealloc( void *, size_t );
char *xstrdup( const char * );
int  CheckDate( int d, int m, int y );
long Date2JD( int day, int month, int year );
int  JD2Date( long jd, int *day, int *month, int *year );
long TodaysJD(void);
long TimeOfDay(void);
long GetDateAndTime( long *ms );
long GetUTCDateAndTime( long *ms );
char *JD2Str( long jd, int mode, char *buf );
char *JD2Str2( long jd, int dmode, long tm, int tmode, char *buf );
int  Str2JD( const char *string, long *ret_jd, size_t *ret_n );
int  Str2Time( const char *string, long *ret_tm, size_t *ret_n );
#define Sleep(a)  wklib_sleep(a)
void Sleep(long);
const char *ShowGPLCopy( int mode, const char *pgm, FILE *fp);
char *IdentStr( char *s );
const char *WklibInfoString( const char *module, const char *name );

#if __STDC__  && !__WATCOMC__  /* einige ANSI Erweiterungen (for MSC)*/
   #ifdef HPUX
     #undef ltoa
   #endif
    char *ltoa(long val, char *buf, int base);	/* strg6.c */
#endif

void *wklib_orig_malloc(size_t);
void *wklib_orig_calloc(size_t,size_t);
void *wklib_orig_realloc( void *, size_t );
void wklib_orig_free( void * );


/************** fixes ********************/
#if __WATCOMC__
  int wklib_vprintf(const char *format, __va_list arg_ptr);
  int wklib_vfprintf(FILE *stream, const char *format, __va_list arg_ptr);
  int wklib_vsprintf(char *buf, const char *format, __va_list arg_ptr);
  #define vprintf(a,b)	   wklib_vprintf((a),(b))
  #define vfprintf(a,b,c)  wklib_vfprintf((a),(b),(c))
  #define vsprintf(a,b,c)  wklib_vsprintf((a),(b),(c))
#endif

/**************** defines ****************/

#define exit(a)   wklib_exit(a)

#define STRING(v) #v
#if __IBMC__
  #define BUG() Bug( NULL, __FUNCTION__, __FILE__ , __LINE__ )
  #ifndef NDEBUG
    #define xassert(exp) do { if(!(exp)) Bug( xassertstring, \
			      #exp, __FUNCTION__ ,__FILE__,__LINE__);} while(0)
  #else
    #define xassert(exp)
  #endif
  #if DEBUG
  #define DbgPoint()  do { printf( "DbgPoint %s : %s[%d]\n", \
			   __FUNCTION__ , __FILE__, __LINE__ );\
			   fflush(stdout) ; } while(0)
  #else
  #define DbgPoint()
  #endif
#elif __GNUC__
  /* note: __FUNCTION__ is a "predefined string" and not a macro! */
  #define BUG() Bug1( __FUNCTION__, __FILE__ , __LINE__ )
  #ifndef NDEBUG
    #define xassert(exp) do { if(!(exp)) Bug( xassertstring, \
			      #exp, __FUNCTION__ ,__FILE__,__LINE__);} while(0)
  #else
    #define xassert(exp)
  #endif
  #if DEBUG
  #define DbgPoint()  do { printf( "DbgPoint %s : %s[%d]\n", \
			   __FUNCTION__ , __FILE__, __LINE__ );\
			   fflush(stdout) ; } while(0)
  #else
  #define DbgPoint()
  #endif
#else
  #define BUG() Bug0( __FILE__ , __LINE__ )
  #ifndef NDEBUG
    #define xassert(exp) do { if(!(exp)) Bug( xassertstring, \
			      #exp,__FILE__,__LINE__);} while(0)
  #else
    #define xassert(exp)
  #endif
  #if DEBUG
  #define DbgPoint()  do { printf( "DebugPoint %s[%d]\n", __FILE__, __LINE__ );\
			   fflush(stdout) ; } while(0)
  #else
  #define DbgPoint()
  #endif
#endif


#define DIM(v) (sizeof(v)/sizeof((v)[0]))
#define DIMof(type,member)   DIM(((type *)0)->member)


#ifdef MEM_DEBUG
    #include <wk/memdbg.h>
#else
    #define FREE(a)	    do { free(a); (a)=NULL; } while(0)
    #define memdbg_term()
    #define memdbg_check()
    #define memdbg_checkptr(a)
    #define memdbg_info(a)  0L
#endif


#if !__MSC__	/* min() and max() not def. by ANSI */
    #define max(a,b)	(((a) > (b)) ? (a) : (b))
    #define min(a,b)	(((a) < (b)) ? (a) : (b))
#endif

#if __MSC__ || __ZTC__
  #define CHKSTACK() _chkstack()
#else
  #define CHKSTACK()
#endif


#define Enter_Main()  wklibApplicationName = CopyRight(13);
#define Leave_Main(a) wklib_exit(a); /*make the compiler happy:*/ return 0;

#define Initialize_Main() Enter_Main() /* old */

#ifdef MULTI_THREADED
  #define Wklib_Serializer(a) static ulong ser_sema_ ## a
  #define Wklib_BeginSerialize(a)  wklib_serialize( 1, &ser_sema_ ## a )
  #define Wklib_EndSerialize(a)    wklib_serialize( 0, &ser_sema_ ## a )
  void wklib_serialize(int level, ulong *a);
#else
  #define Wklib_Serializer(a)
  #define Wklib_BeginSerialize(a)
  #define Wklib_EndSerialize(a)
#endif

#if __cplusplus
}
#endif
#endif /* HDR_WK_LIB */
