/* [wam/wordarray.c wk 05.01.96] Class WordArray
 *	Copyright (c) 1995 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 * This class can be used to store arbitrary 32 bit values.
 *
 * This is a Subclass of array and inherits most methods.
 */

#include <wk/tailor.h>
RCSID("$Id: wordarray.c,v 1.1 1996/01/10 19:02:23 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>

DCLSHAREDPART(WordArray)

BEGIN_DCLPRIVATEPART
END_DCLPRIVATEPART


/****************
 * never do a deep free (we do not store objects ).
 */

DCLOBJFNC( deepFree )
{
    return msgSuper( sym_free );
}


/****************
 * Erzeugt eine StringArray mit den Objekten in self
 * bereit um in eine Datenbank eingesetzt zu werden
 */

DCLOBJFNC( asDBStringArray )
{
    return newObj(StringArray);
}



void
WamSUC_WordArray()
{
    id self = WordArray;
    CREATECLASS("WordArray");
    WamSubclassClass( sym_Array, self );

    DCLMTHD( deepFree );
    DCLMTHD( asDBStringArray );

}


/**** end of file ****/
