/* [wammain.h wk 01.04.93] Internal WAM Header
 *	Copyright (c) 1992 by Werner Koch (dd9jn)
 *	     "Werners Application Model"
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: wammain.h,v 1.9 1996/05/05 10:13:55 wernerk Exp $
 */

#ifndef HDR_WAMMAIN
#define HDR_WAMMAIN 1


/****** constants ******/

#define ITEMTYPE_MENU	  1
#define ITEMTYPE_ENTRY	  2
#define ITEMTYPE_BUTTON   3
#define ITEMTYPE_LIST	  4
#define ITEMTYPE_VALUESET 5

#define POINTER_STD   0
#define POINTER_WAIT  1
#define POINTER_READ  2
#define POINTER_WRITE 3



#ifdef WAM_PM_MODULE
  #define IDM_HELP	       15090
  #define IDM_HELPHELPFORHELP  15091
  #define IDM_HELPEXTENDED     15092
  #define IDM_HELPINDEX        15093
  #define IDM_HELPABOUT        15094
  #define IDM_HELPTUTORIAL     15099
  #define  ID_HELPTABLE        15100
  #define IDS_HELPLIBNAME      15101
  #define IDS_HELPLOADERR      15102
  #define IDS_HELPTITLE        15110
#endif

/****** prototypes *****/

void	 WamInitializeSymbols(void);


/* --- messager.c ---*/
id WamSendMsgToNil( symbol_t selector, va_list arg_ptr, int traceFlag, int rl);

/* --- object.c ---*/
void WamSetupRawObject( id Class, id obj );

/* --- table.c ---*/
void WamSetTableScrollFnc( id tbl, int (*ScrollFnc)(id,void*,int), void* );

/*--- gui.c ---*/
void WamSUC_GUI(void);

/***********************/

DCLSYM	sym_renewText,
	sym_view,
	sym_valueChanged,
	sym_linkItemToItem,
	sym_addSymbol;




#if __cplusplus
}
#endif
#endif /* HDR_WAMMAIN */
