/* [wamgui.h wk 29.09.93] Internal WAM Header for GUIs
 *	Copyright (c) 1992 by Werner Koch (dd9jn)
 *	     "Werners Application Model"
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: wamgui.h,v 1.4 1996/05/05 10:13:53 wernerk Exp $
 */

#ifndef HDR_WAMGUI
#define HDR_WAMGUI  1


#define WAMGUI_INTERFACE_VERSION "1.32"


#ifdef WAM_PM_MODULE
   /* --- pmmain.c --- */
   void _wamapi WamRegisterFormItem( id form, id fItem, int dlgItem, int iType);
   void _wamapi WamOpenWindow(id form, int subId, void *reserved);
   void _wamapi WamCloseWindow( id form );
   void _wamapi WamGetItemText( id form, id fitem, char *buffer, size_t buflen );
   void _wamapi WamPutItemText( id form, id fitem, char *buffer );
   void _wamapi WamEnableItem( id form, id fitem, int state );
   void _wamapi WamSetWindowFocus( id form, id fitem );
   id	_wamapi WamQueryWindowFocus( id form );
   void _wamapi WamSetWindowTitle( id form, const char *string );
   void _wamapi WamInsertListItem( id form, id fitem, int mode, char *string );
   int	_wamapi WamShowMessageBox( id form, int msgType, const char *text );
   int	_wamapi WamGetListSelection( id form, id fitem, int start );
   void _wamapi WamPutListSelection( id form, id fitem, int index );
   int	_wamapi WamGetPutCheckState( id form, id fitem, int state );
   int	_wamapi WamSpinButtonControl( id form, id fitem, int mode, int lower, int upper);
   int	_wamapi WamWindowVisibility( id form, int mode );
   void _wamapi WamSetWindowPointer( int nr );
   void _wamapi WamSetWindowTimer( id form, ulong milliseconds );
   int	_wamapi WamSetGridValue( id form, id fitem, int x, int y,
			 int datatype, const void *data, size_t datalen );

   /* --- pmsup1.c --- */
   const char *WamWindowStrMessage( ushort n );

   /* --- pmsup2.c --- */
   void WamPMInitializeHelp( HAB habMain, HWND mainFrame);
   void WamPMTerminateHelp(void);
   void WamPMDisplayHelp(HWND hwnd, int itemId);
#else
    /* Initialized in gui.c */
    void (*_wamapi WamRegisterFormItem)( id form, id fItem, int dlgItem, int iType);
    void (*_wamapi WamOpenWindow)(id form, int subId, void *reserved );
    void (*_wamapi WamCloseWindow)( id form );
    void (*_wamapi WamGetItemText)( id form, id fitem, char *buffer, size_t buflen );
    void (*_wamapi WamPutItemText)( id form, id fitem, char *buffer );
    void (*_wamapi WamEnableItem)( id form, id fitem, int state );
    void (*_wamapi WamSetWindowFocus)( id form, id fitem );
    id	 (*_wamapi WamQueryWindowFocus)( id form );
    void (*_wamapi WamSetWindowTitle)( id form, const char *string );
    void (*_wamapi WamInsertListItem)( id form, id fitem, int mode, char *string );
    int  (*_wamapi WamShowMessageBox)( id form, int msgType, const char *text );
    int  (*_wamapi WamGetListSelection)( id form, id fitem, int start );
    void (*_wamapi WamPutListSelection)( id form, id fitem, int index );
    int  (*_wamapi WamGetPutCheckState)( id form, id fitem, int state );
    int  (*_wamapi WamSpinButtonControl)( id form, id fitem, int mode, int lower, int upper);
    int  (*_wamapi WamWindowVisibility)( id form, int mode );
    void (*_wamapi WamSetWindowPointer)( int nr );
    void (*_wamapi WamSetWindowTimer)( id form, ulong ms );
    int  (*_wamapi WamSetGridValue)( id form, id fitem, int x, int y,
			 int datatype, const void *data, size_t datalen );
#endif


#if __cplusplus
}
#endif
#endif /* HDR_WAMGUI */
