/* [wam/vmain.c wk 25.02.93] Test View Class
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: vtest.c,v 1.3 1993/09/15 21:18:13 wk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>

#include "app.h"

/**************************************************
 *************	Constants  ************************
 **************************************************/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(ViewTest)

BEGIN_DCLPRIVATEPART
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

/**************************************************
 *************	Local Functions  ******************
 **************************************************/


/**************************************************
 ******************  Methods  *********************
 **************************************************/


DCLOBJFNC( initialize )
{
    msg1(self, sym_attachForm, FormTest );
    msg2(self, sym_attachActionTo, sym_iSearch, sym(doSearch) );
    msg2(self, sym_attachActionTo, sym_iEnd, sym(shutdown) );
    msg2(self, sym_attachActionTo, sym_iSelect, sym(actionOk) );
    return self;
}




DCLOBJFNC( doSearch )
{
    id tbl;
    id values;
    char *s;

    Info( "Building search command");
    values = newObj(IdArray);
    s = p_msg1(self, sym_getValue, sym(iName));
    Info("Name='%s'", s );
    msg1(values , sym_add,  newString(s) );
    Info( "Passing command to database engine");
    tbl = msg2(Database, sym_sql,
                "SELECT * FROM TPartner WHERE Name1 LIKE :",
							    values );
    if( !tbl )
        msg1(self, sym_infoMsg, "SQL failed!");
    else
	msg1( msg1(self, sym_item, sym(iList)), sym_put, tbl );
}




void WamSUC_ViewTest()
{
    id self = ViewTest;
    CREATECLASS("ViewTest");
    WamSubclassClass( sym_View, self );

    DCLMTHD( initialize );
    DCLMTHD( doSearch );
}


/**** end of file ****/
