/* [wam/vsqlwndw.c wk 27.02.93] ViewSQLWindow
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 * SQL - Kommandos interaktiv eingeben und resulta darstellen
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: vsqlwndw.c,v 1.3 1993/09/15 21:18:10 wk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>

#include "app.h"

/**************************************************
 *************	Constants  ************************
 **************************************************/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(ViewSQLWindow)

BEGIN_DCLPRIVATEPART
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

/**************************************************
 *************	Local Functions  ******************
 **************************************************/


/**************************************************
 ******************  Methods  *********************
 **************************************************/


DCLOBJFNC( initialize )
{
    msg1(self, sym_attachForm, FormSQLWindow );
    msg2(self, sym_attachActionTo, sym_iEnd, sym(shutdown) );
    msg2(self, sym_attachActionTo, sym_iOkay, sym(actionOk) );
    return self;
}




DCLOBJFNC( actionOk )
{
    id tbl;
    char *s;

    s = p_msg1(self, sym_getValue, sym(iCmd));
    Info("Cmd='%s'", s );
    tbl = msg2(Database, sym_sql, s, nil );
    if( !tbl )
        msg1(self, sym_infoMsg, "SQL failed!");
    else
	msg1( msg1(self, sym_item, sym(iList)), sym_put, tbl );
}




void WamSUC_ViewSQLWindow()
{
    id self = ViewSQLWindow;
    CREATECLASS("ViewSQLWindow");
    WamSubclassClass( sym_View, self );

    DCLMTHD( initialize );
    DCLMTHD( actionOk );
}


/**** end of file ****/
