/* [wam/vmain.c wk 10.2.93] Example Main View Class
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: vmain.c,v 1.3 1993/09/15 21:18:07 wk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>

#include "app.h"

/**************************************************
 *************	Constants  ************************
 **************************************************/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(ViewMain)

BEGIN_DCLPRIVATEPART
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

/**************************************************
 *************	Local Functions  ******************
 **************************************************/


/**************************************************
 ******************  Methods  *********************
 **************************************************/


DCLOBJFNC( initialize )
{
    id f;

    msg1(self, sym_attachForm, FormLogon );
    return self;
}



DCLOBJFNC( event )
{
    DCL_arg(symbol_t,item);
    int rc, i;
    id tbl, o;
    long ta, tb;
    symbol_t sa, sb;

    if( item == sym_iOkay ) { /* default action for this item */
	rc = i_msg2(Database, sym(logon),
		   p_msg1( self, sym_getValue, sym_iUser ),
		   p_msg1( self, sym_getValue, sym_iPass )   );
	if( rc )
            msg2(self, sym_errorMsg,"Logon Error: rc=%d", rc ) ;
	else {
            msg1(self, sym_infoMsg, "Successfully\r logged on!");
	  #if 0
            tbl = msg1(Database, sym_sql, "SELECT * FROM TPartner");
	    if( !tbl )
                msg1(self, sym_infoMsg, "SQL failed!");
	    else {

		msg(tbl, sym_show );
		o = msg1(tbl, sym_at, sym(Name1) );
                printf("Name1='%s'\n", getString(o) );
		freeObj(o);
		o = msg1(tbl, sym_at, sym(PartnerId) );
                printf("PartnerId='%d'\n", getInteger(o) );
		freeObj(o);
		o = msg1(tbl, sym_at, sym(PLZ) );
                printf("PLZ='%s'\n", getString(o) );
		freeObj(o);

                o = newString("Dies ist der neue Name");
		msg2(tbl, sym_atPut, sym(Name1), o );
		freeObj(o);

		o = msg1(tbl, sym_at, sym(Name1) );
                printf("Name1='%s'\n", getString(o) );
		freeObj(o);




	      #if 0
		ta = TimeOfDay();

		for(i=0; i < 10000; i++ ) {
		    o = msg1(tbl, sym_at, sym(Name2) );
		    getString(o);
		    freeObj(o);
		}
		tb = TimeOfDay();
                msg2(self, sym_infoMsg, "execution time: %ld", (tb - ta ) );

		ta = TimeOfDay();
		for(i=0; i < 100000; i++ )
		    s = p_msg1(tbl, sym(at), sym(Name2) );
		tb = TimeOfDay();
                msg2(self, sym_infoMsg, "execution time: %ld", (tb - ta ) );

		sa = sym(at);
		sb = sym(Name2);
		ta = TimeOfDay();
		for(i=0; i < 100000; i++ )
		    s = p_msg1(tbl, sa, sb );
		tb = TimeOfDay();
                msg2(self, sym_infoMsg, "execution time: %ld", (tb - ta ) );
	      #endif
	    }
	  #endif
	    msg( ViewTest, sym_open );
	    msg( ViewSQLWindow, sym_open );

	}
	return self;
    }
    return msgSuper1( sym_event, item );
}



DCLOBJFNC( openInitialization )
{
    msg1(Database, sym(access), "GATTTEST");
    return self;
}


DCLOBJFNC( postOpenInitialization )	/* nur zum testen dieser methode */
{
    msg2(self, sym_putValue, sym_iUser, "SYSADM" );
    return self;
}













void WamSUC_ViewMain()
{
    id self = ViewMain;
    CREATECLASS("ViewMain");
    WamSubclassClass( sym_View, self );

    DCLMTHD( initialize );
    DCLMTHD( openInitialization );
    DCLMTHD( postOpenInitialization );
    DCLMTHD( event );
}


/**** end of file ****/
