/* [wam/timestamp.c wk 18.12.95] Class Timestamp
 *	Copyright (c) 1995 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Dies ist eine subclass von date oder time, da dies ein
 * grundlegendes Objekt ist, und deswegen hohe Performance sinnvoll ist.
 */

#include <wk/tailor.h>
RCSID("$Id: timestamp.c,v 1.3 1996/02/23 18:11:05 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>

#include "wamdb.h"

/**************************************************
 *************	Constants  ************************
 **************************************************/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(Timestamp)

BEGIN_DCLPRIVATEPART
    timeStamp_t ts;
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

/**************************************************
 *************	Local Functions  ******************
 **************************************************/

/**************************************************
 ******************  Methods  *********************
 **************************************************/

DCLFOBJFNC( create )
{
    DCL_arg(timeStamp_t, val);
    id obj;
    id var;

    obj = msgSuper( sym_new );
    SET_var(obj);
    var->ts.d = val.d;
    var->ts.t = val.t;
    return obj;
}

DCLFOBJFNC( now )
{
    id obj;
    id var;
    long val;

    obj = msgSuper( sym_new );
    SET_var(obj);
    var->ts.d = GetDateAndTime( &val );
    var->ts.t = val;
    return obj;
}


DCLOBJFNC( copy )
{
    id obj;
    long v1, v2;
    DCL_var();

    obj = msg(factory, sym_new );
    v1 = var->ts.d;
    v2 = var->ts.t;
    SET_var(obj);
    var->ts.d = v1;
    var->ts.t = v2;
    return obj;
}


DCLOBJFNC( date )
{
    DCL_var();
    return newDate(var->ts.d);
}

DCLOBJFNC( time )
{
    DCL_var();
    return newTime(var->ts.t);
}


/****************
 * ACHTUNG:
 * Wir geben hier einen pointer auf eine Struktur
 * timestamp zurck, da es nicht mglich ist, auf eine derart
 * einfache struktur zu casten (eventuell long-long oder double benutzen)
 */
DCLOBJFNC_v( getValue )
{
    DCL_var();
    return &var->ts;
}

DCLOBJFNC( putValue )
{
    DCL_arg(timeStamp_t, val);
    DCL_var();

    var->ts.d = val.d;
    var->ts.t = val.t;
    return self;
}


DCLOBJFNC_p( allocAsDBString )
{
    char buf[40];
    int day,month,year;
    DCL_var();

    if( !JD2Date( var->ts.d, &day, &month, &year ) )
	strcpy(buf,"NULL");
    else {
	int h,m,s,mil;
	long tm;

	tm  = var->ts.t;
	mil = tm % 1000;
	tm /= 1000;
	h = tm / 3600;
	m = (tm % 3600) / 60;
	s = tm % 60;

	if( WamSQLType() == 2 ) /* odbc */
	    sprintf(buf,"{ts '%04d-%02d-%02d %02d:%02d:%02d.%03d'}",
				    year, month, day, h,m,s,mil);
	else
	    sprintf(buf,"'%04d-%02d-%02d %02d:%02d:%02d.%03d'",
			 year, month, day, h,m,s,mil );
    }
    return xstrdup(buf);
}


DCLOBJFNC( asString )
{
    char buf[40];
    int h,m,s,mil;
    int day,month,year;
    long tm;
    DCL_var();

    if( !JD2Date( var->ts.d, &day, &month, &year ) )
	day = month = year = 0;
    tm	= var->ts.t;
    mil = tm % 1000;
    tm /= 1000;
    h = tm / 3600;
    m = (tm % 3600) / 60;
    s = tm % 60;
    sprintf(buf,"%04d-%02d-%02d %02d:%02d:%02d.%03d",
		 year, month, day, h,m,s,mil );

    return newString(buf);
}


DCLOBJFNC( asShortString )  /* t.mm.jj hh:mm */
{
    char buf[40];
    int h,m;
    int day,month,year;
    long tm;
    DCL_var();

    if( !JD2Date( var->ts.d, &day, &month, &year ) )
	*buf = 0;
    else {
	tm  = var->ts.t;
	tm /= 1000;
	h = tm / 3600;
	m = (tm % 3600) / 60;
	year %= 100;
	sprintf(buf,"%d.%d.%02d %d:%02d", day, month, year, h,m );

    }
    return newString(buf);
}


DCLOBJFNC_i( isEmptyOrNil )
{
    return 0; /* always valid */
}

DCLOBJFNC_i( isEqual )
{
    DCL_arg(id, other );
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->ts.d == var2->ts.d && var->ts.t == var2->ts.t;
    }
    else if( WamIsKindOf( other, factory ) ) { /* a subclass */
	timeStamp_t ts = *(timeStamp_t*)v_msg(other, sym_getValue);
	return	  var->ts.d == ts.d  && var->ts.t == ts.t;
    }
    else
	return 0;   /* from other class - cannot be compared */
}


DCLOBJFNC_i( isGT )
{
    DCL_arg(id, other );
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	if( var->ts.d == var2->ts.d )
	    return  var->ts.t > var2->ts.t;
	else
	    return  var->ts.d > var2->ts.d;
    }
    else if( WamIsKindOf( other, factory ) ) { /* a subclass */
	timeStamp_t ts = *(timeStamp_t*)v_msg(other, sym_getValue);
	if( var->ts.d == ts.d )
	    return  var->ts.t > ts.t;
	else
	    return  var->ts.d > ts.d;
    }
    else
	return 0;   /* from other class - cannot be compared */
}

DCLOBJFNC_i( isGE )
{
    DCL_arg(id, other );
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	if( var->ts.d == var2->ts.d )
	    return  var->ts.t >= var2->ts.t;
	else
	    return  var->ts.d >= var2->ts.d;
    }
    else if( WamIsKindOf( other, factory ) ) { /* a subclass */
	timeStamp_t ts = *(timeStamp_t*)v_msg(other, sym_getValue);
	if( var->ts.d == ts.d )
	    return  var->ts.t >= ts.t;
	else
	    return  var->ts.d >= ts.d;
    }
    else
	return 0;   /* from other class - cannot be compared */
}


DCLOBJFNC_i( isLT )
{
    DCL_arg(id, other );
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	if( var->ts.d == var2->ts.d )
	    return  var->ts.t < var2->ts.t;
	else
	    return  var->ts.d < var2->ts.d;
    }
    else if( WamIsKindOf( other, factory ) ) { /* a subclass */
	timeStamp_t ts = *(timeStamp_t*)v_msg(other, sym_getValue);
	if( var->ts.d == ts.d )
	    return  var->ts.t < ts.t;
	else
	    return  var->ts.d < ts.d;
    }
    else
	return 0;   /* from other class - cannot be compared */
}


DCLOBJFNC_i( isLE )
{
    DCL_arg(id, other );
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	if( var->ts.d == var2->ts.d )
	    return  var->ts.t <= var2->ts.t;
	else
	    return  var->ts.d <= var2->ts.d;
    }
    else if( WamIsKindOf( other, factory ) ) { /* a subclass */
	timeStamp_t ts = *(timeStamp_t*)v_msg(other, sym_getValue);
	if( var->ts.d == ts.d )
	    return  var->ts.t <= ts.t;
	else
	    return  var->ts.d <= ts.d;
    }
    else
	return 0;   /* from other class - cannot be compared */
}


void
WamSUC_Timestamp()
{
    id self = Timestamp;
    CREATECLASS("Timestamp");
    WamSubclassClass( sym_Object, self );
    WamSetAtticLimit(self, 500 );

    DCLFMTHD( create );
    DCLFMTHD( now );

    DCLMTHD( copy );
    DCLMTHD( date );
    DCLMTHD( time );
    DCLMTHD( getValue );
    DCLMTHD( putValue );
    DCLMTHD( allocAsDBString );
    DCLMTHD( asString );
    DCLMTHD( asShortString );
    DCLMTHD( isEmptyOrNil );
    DCLMTHD( isEqual );
    DCLMTHD( isGT );
    DCLMTHD( isGE );
    DCLMTHD( isLT );
    DCLMTHD( isLE );
}


/**** end of file ****/
