/* [wam/time.c wk 28.03.93] Class Time
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 *
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: time.c,v 1.9 1996/01/25 20:18:13 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>
#include "wamdb.h"

/**************************************************
 *************	Constants  ************************
 **************************************************/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(Time)

BEGIN_DCLPRIVATEPART
    long val;
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

/**************************************************
 *************	Local Functions  ******************
 **************************************************/

/**************************************************
 ******************  Methods  *********************
 **************************************************/

DCLFOBJFNC( create )
{
    DCL_arg(long, val); /* milliseconds since midnight */
    id obj;
    id	var;

    obj = msgSuper( sym_new );
    SET_var(obj);
    var->val = val;
    return obj;
}

DCLFOBJFNC( now )
{
    id obj;
    id	var;

    obj = msgSuper( sym_new );
    SET_var(obj);
    var->val = TimeOfDay();
    return obj;
}


DCLOBJFNC( copy )
{
    id obj;
    long val;
    DCL_var();

    obj = msg(factory, sym_new );
    val = var->val;
    SET_var(obj);
    var->val = val;
    return obj;
}



DCLOBJFNC_i( getValue )  /* gibt den Wert zurueck */
{
    DCL_var();
    return var->val;
}

DCLOBJFNC( putValue )
{
    DCL_arg(long, val);
    DCL_var();

    var->val = val;
    return self;
}


DCLOBJFNC_p( allocAsDBString )
{
    char buf[20];
    int h,m,s,mil;
    long tm;
    DCL_var();

    tm	= var->val;
    mil = tm % 1000;
    tm /= 1000;
    h = tm / 3600;
    m = (tm % 3600) / 60;
    s = tm % 60;
    if( WamSQLType() == 2 ) /* ODBC */
	sprintf(buf,"{t '%02d:%02d:%02d'}",h,m,s);
    else
	sprintf(buf,"'%02d.%02d.%02d.%03d000'",h,m,s,mil);

    return xstrdup(buf);
}


DCLOBJFNC( asString )
{
    char buf[20];
    int h,m,s,mil;
    long tm;
    DCL_var();

    tm	= var->val;
    mil = tm % 1000;
    tm /= 1000;
    h = tm / 3600;
    m = (tm % 3600) / 60;
    s = tm % 60;
    sprintf(buf,"%2d.%02d.%02d.%03d",h,m,s,mil);

    return newString(buf);
}

DCLOBJFNC( time )
{
    return msg(self, sym_copy);
}

DCLOBJFNC_i( isEmptyOrNil )
{
    return 0; /* always valid */
}

DCLOBJFNC_i( isEqual )
{
    DCL_arg(id, other );
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->val == var2->val;
    }
    else if( WamIsKindOf( other, factory ) ) { /* a subclass */
	return var->val == getInteger(other);
    }
    else
	return 0;   /* from other class - cannot be compared */
}


DCLOBJFNC_i( isGT )
{
    DCL_arg(id, other );
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->val > var2->val;
    }
    else if( WamIsKindOf( other, factory ) ) { /* a subclass */
	return var->val > getInteger(other);
    }
    else
	return 0;   /* from other class - cannot be compared */
}

DCLOBJFNC_i( isGE )
{
    DCL_arg(id, other );
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->val >= var2->val;
    }
    else if( WamIsKindOf( other, factory ) ) { /* a subclass */
	return var->val >= getInteger(other);
    }
    else
	return 0;   /* from other class - cannot be compared */
}


DCLOBJFNC_i( isLT )
{
    DCL_arg(id, other );
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->val < var2->val;
    }
    else if( WamIsKindOf( other, factory ) ) { /* a subclass */
	return var->val < getInteger(other);
    }
    else
	return 0;   /* from other class - cannot be compared */
}


DCLOBJFNC_i( isLE )
{
    DCL_arg(id, other );
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->val <= var2->val;
    }
    else if( WamIsKindOf( other, factory ) ) { /* a subclass */
	return var->val <= getInteger(other);
    }
    else
	return 0;   /* from other class - cannot be compared */
}


DCLOBJFNC( asNumber )
{
    DCL_var();
    return newInteger(var->val);
}



void WamSUC_Time()
{
    id self = Time;
    CREATECLASS("Time");
    WamSubclassClass( sym_Object, self );
    WamSetAtticLimit(self, 500 );

    DCLFMTHD( create );
    DCLFMTHD( now );

    DCLMTHD( copy );
    DCLMTHD( getValue );
    DCLMTHD( putValue );
    DCLMTHD( allocAsDBString );
    DCLMTHD( asString );
    DCLMTHD( time );
    DCLMTHD( isEmptyOrNil );
    DCLMTHD( isEqual );
    DCLMTHD( isGT );
    DCLMTHD( isGE );
    DCLMTHD( isLT );
    DCLMTHD( isLE );
    DCLMTHD( asNumber );
}


/**** end of file ****/
