/* [wam/tablerow.c wk 18.03.93] Class TableRow
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 * stellt eine einzelene Table row dar
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: tablerow.c,v 1.4 1993/09/27 12:38:52 wk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>

/**************************************************
 *************	Constants  ************************
 **************************************************/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(TableRow)

BEGIN_DCLPRIVATEPART
    id	tbl;	   /* die Table */
    unsigned pos;  /* und die Row der Table */
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

/**************************************************
 *************	Local Functions  ******************
 **************************************************/

/**************************************************
 ******************  Methods  *********************
 **************************************************/

DCLFOBJFNC( create )
{
    DCL_arg(id, tbl );
    DCL_arg(unsigned, pos );
    id obj;
    id var;

    obj = msgSuper( sym_new );
    SET_var(obj);
    var->tbl = tbl;
    var->pos = pos;
 /* msg1(tbl, sym(addDependent), obj ); */
    return obj;

}


#if 0
DCLOBJFNC( free )
{
    DCL_var();
    msg1(var->tbl, sym(removeDependent), self );
    return msgSuper( sym_free );
}
#endif



/****************
 * Das erzeugte Objekt muss wieder freigegeben werden !
 */

DCLOBJFNC( at )
{
    DCL_arg(symbol_t, name);
    id obj;
    unsigned oldpos, size;
    DCL_var();


    size   = I_msg( var->tbl, sym_size	   );
    oldpos = I_msg( var->tbl, sym_position );
    if( var->pos >= size ) {
	msg2(self, sel(bounds), var->pos, size-1 );
	return nil;
    }
    if( oldpos != var->pos ) {
	msg1(var->tbl, sym_seekTo, var->pos );
    }

    obj = msg1( var->tbl, sym_at, name );

    if( oldpos != var->pos ) {
	msg1(var->tbl, sym_seekTo, oldpos );
    }
    return obj;
}




/****************
 * Returns: False wenn die Werte gleich waren
 *	    True  wenn es ein neuer Wert ist
 */

DCLOBJFNC_i( atPut )
{
    DCL_arg(symbol_t, name);
    DCL_arg(id, newVal );
    int chg;
    unsigned oldpos, size;
    DCL_var();

    size   = I_msg( var->tbl, sym_size	   );
    oldpos = I_msg( var->tbl, sym_position );
    if( var->pos >= size ) {
	msg2(self, sel(bounds), var->pos, size-1 );
	return 0;
    }
    if( oldpos != var->pos ) {
	msg1(var->tbl, sym_seekTo, var->pos );
    }

    chg = i_msg2( var->tbl, sym_atPut, name, newVal );

    if( oldpos != var->pos ) {
	msg1(var->tbl, sym_seekTo, oldpos );
    }
    return chg;
}


/****************
 * Erzeugt ein neues Dictionary, mit Kopien der Werte
 */

DCLOBJFNC( asDictionary )
{
    id obj;
    unsigned oldpos, size;
    DCL_var();


    size   = I_msg( var->tbl, sym_size	   );
    oldpos = I_msg( var->tbl, sym_position );
    if( var->pos >= size ) {
	msg2(self, sel(bounds), var->pos, size-1 );
	return nil;
    }
    if( oldpos != var->pos ) {
	msg1(var->tbl, sym_seekTo, var->pos );
    }

    obj = msg( var->tbl, sym_asDictionary );

    if( oldpos != var->pos ) {
	msg1(var->tbl, sym_seekTo, oldpos );
    }
    return obj;
}




DCLOBJFNC( beginBlock )
{
    DCL_var();
    return msg( var->tbl, sym_beginBlock );
}

DCLOBJFNC( endBlock )
{
    DCL_var();
    return msg( var->tbl, sym_endBlock );
}



void WamSUC_TableRow()
{
    id self = TableRow;
    CREATECLASS("TableRow");
    WamSubclassClass( sym_Object, self );
    WamSetAtticLimit( self, 50 );

    DCLFMTHD( create );
  /*DCLMTHD( free );*/
    DCLMTHD( at );
    DCLMTHD( atPut );
    DCLMTHD( asDictionary );
    DCLMTHD( beginBlock );
    DCLMTHD( endBlock );
}


/**** end of file ****/
