/* [wam/SymbSet.c wk 09.04.93] Class SymbolSet
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: symbset.c,v 1.5 1996/01/10 19:02:11 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>

/**************************************************
 *************	Constants  ************************
 **************************************************/
#define FIRSTCHUNK   10  /* beim ersten mal nich soviel allokieren */
#define CHUNK	     50  /* wahrscheinlich brauchen wir dann doch mehr*/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(SymbolSet)

BEGIN_DCLPRIVATEPART
    symbol_t *contents;
    size_t capacity; /* allocated size of contents */
    size_t size;     /* current size of contents */
    size_t enSize;   /* used for enumeration */
    size_t enIdx;    /* used for enumeration */
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

/**************************************************
 *************	Local Functions  ******************
 **************************************************/

/**************************************************
 ******************  Methods  *********************
 **************************************************/

DCLFOBJFNC( new )
{
    id obj;
    id var;

    obj = msgSuper( sym_new );
    SET_var(obj);
    var->contents = xcalloc(var->capacity=FIRSTCHUNK,sizeof *var->contents);
    var->size = 0;
    return obj;
}


DCLOBJFNC( free )
{
    DCL_var();

    free( var->contents );
    return msgSuper( sym_free );
}


/****************
 * Add an element if not already in the set
 */

DCLOBJFNC( addSymbol )
{
    DCL_arg(symbol_t, sym );
    size_t n;
    DCL_var();

    for(n=0; n < var->size; n++ )
	if( var->contents[n] == sym )
	    return self; /* already stored in Set*/

    if( var->size == var->capacity ) {
	var->capacity += CHUNK;
	var->contents = xrealloc(var->contents,
				 var->capacity * sizeof *var->contents);
    }

    var->contents[var->size] = sym;
    var->size++;
    return self;
}



DCLOBJFNC_I( size )
{
    DCL_var();
    return var->size;
}



/****************
 * Add an element if not already in the set
 */

DCLOBJFNC_i( contains )
{
    DCL_arg(symbol_t, sym );
    size_t n;
    DCL_var();

    for(n=0; n < var->size; n++ )
	if( var->contents[n] == sym )
	    return 1; /* already stored in Set */

    return 0;
}




/****************
 * Seq. Zugriff: aber einmal gleichzeitig
 * (fuer Anderes ist die Sequence Methode zu benutzen)
 * Returns: self or nil; bei nil braucht close nicht mehr
 * benutzt zu werden, da es ein leeres Array anzeigt.
 */

DCLOBJFNC( enumOpen )
{
    DCL_var();

    if( var->enSize ) {
	msg1(self,sym_error,"nested enumBegin");
	return nil;
    }

    if( !var->size )
	return nil;
    var->enSize = var->size;
    var->enIdx	 = 0;
    return self;
}


DCLOBJFNC_s( enumGet )
{
    DCL_var();

    if( !var->enSize ) {
	msg1(self,sym_error,"enumGet without enumBegin");
	return NULL;
    }
    for( ; var->enIdx < var->enSize; var->enIdx++ )
	if( var->contents[var->enIdx] )
	    return var->contents[var->enIdx++];
    var->enSize = 0;
    return 0;
}


DCLOBJFNC( enumClose )
{
    DCL_var();
    var->enSize = 0;
    return nil;
}





void WamSUC_SymbolSet()
{
    id self = SymbolSet;
    CREATECLASS("SymbolSet");
    WamSubclassClass( sym_Object, self );
    WamSetAtticLimit(self, 50 );

    DCLFMTHD( new );

    DCLMTHD( free );
    DCLMTHD( addSymbol );
    DCLMTHD( size );
    DCLMTHD( contains );
    DCLMTHD( enumOpen );
    DCLMTHD( enumGet  );
    DCLMTHD( enumClose);

}


/**** end of file ****/
