/* [wam/symbldct.c wk 27.02.93] Class SymbolDictionary
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: symbldct.c,v 1.4 1993/09/27 12:38:37 wk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>

/**************************************************
 *************	Constants  ************************
 **************************************************/
#define FIRSTCHUNK   10  /* beim ersten mal nich soviel allokieren */
#define CHUNK	     50  /* wahrscheinlich brauchen wir dann doch mehr*/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

typedef struct {
	symbol_t key;
	symbol_t val;
    } entry_t;


DCLSHAREDPART(SymbolDictionary)

BEGIN_DCLPRIVATEPART
    entry_t *contents;
    size_t capacity; /* allocated size of contents */
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

/**************************************************
 *************	Local Functions  ******************
 **************************************************/

/**************************************************
 ******************  Methods  *********************
 **************************************************/

DCLOBJFNC( free )
{
    DCL_var();

    free( var->contents );
    return msgSuper( sym_free );
}


/****************
 * Add a Key/Value pair
 */

DCLOBJFNC( atPut )
{
    DCL_arg(symbol_t, key );
    DCL_arg(symbol_t, val );
    size_t n;
    DCL_var();

    if( !var->contents )
	var->contents = xcalloc(var->capacity=FIRSTCHUNK,sizeof *var->contents);
    /* find an empty slot */
    for(n=0; n < var->capacity; n++ )
	if( !var->contents[n].key )
	    break;
    if( n == var->capacity ) { /* need some more space */
	var->capacity += CHUNK;
	var->contents = xrealloc(var->contents,
				 var->capacity * sizeof *var->contents);
    }
    /* store value */
    var->contents[n].key = key;
    var->contents[n].val = val;
    return self;
}


DCLOBJFNC_s( at )
{
    DCL_arg(symbol_t, key );
    size_t n;
    DCL_var();

    for(n=0; n < var->capacity; n++ )
	if( var->contents[n].key == key )
	    return var->contents[n].val;
    return 0;
}


DCLOBJFNC_s( keyFromValue )
{
    DCL_arg(symbol_t, val );
    size_t n;
    DCL_var();

    for(n=0; n < var->capacity; n++ )
	if( var->contents[n].key )
	    if( var->contents[n].val == val )
		return var->contents[n].key;
    return 0;
}



DCLOBJFNC_I( size )
{
    size_t n, cnt;
    DCL_var();

    for(n=cnt=0; n < var->capacity; n++ )
	if( var->contents[n].key )
	    cnt++;
    return cnt;
}




void WamSUC_SymbolDictionary()
{
    id self = SymbolDictionary;
    CREATECLASS("SymbolDictionary");
    WamSubclassClass( sym_Object, self );
    WamSetAtticLimit(self, 100 );

    DCLMTHD( free );
    DCLMTHD( atPut );
    DCLMTHD( at );
    DCLMTHD( keyFromValue );
    DCLMTHD( size );
}


/**** end of file ****/
