/* [wam/StringArray.c wk 25.02.93] Class StringArray
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: strgarry.c,v 1.6 1996/01/25 20:18:01 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>

/**************************************************
 *************	Constants  ************************
 **************************************************/
#define FIRSTCHUNK   10  /* beim ersten mal nich soviel allokieren */
#define CHUNK	     50  /* wahrscheinlich brauchen wir dann doch mehr*/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(StringArray)

BEGIN_DCLPRIVATEPART
    unsigned refCount;	   /* we have only shallow copies, so count them */
    char **contents;
    size_t capacity; /* allocated size of contents */
    size_t size;     /* current size of contents */
    size_t enSize;   /* used for enumeration */
    size_t enIdx;    /* used for enumeration */
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/
static void InitAdd( id var );

/**************************************************
 *************	Local Functions  ******************
 **************************************************/

static void InitAdd( id var )
{
    if( !var->contents )
	var->contents = xcalloc(var->capacity=FIRSTCHUNK,sizeof *var->contents);
    else if( var->size == var->capacity ) {
	var->capacity += CHUNK;
	var->contents = xrealloc(var->contents,
				 var->capacity * sizeof *var->contents);
    }
}

/**************************************************
 ******************  Methods  *********************
 **************************************************/

DCLOBJFNC( free )
{
    size_t n;
    DCL_var();

    if( var->refCount ) {
	var->refCount--;
	return nil;
    }

    if( var->contents ) {
	for(n=0; n < var->size; n++ )
	    free( var->contents[n] );
	free( var->contents );
    }

    return msgSuper( sym_free );
}


DCLOBJFNC( copy )
{
    DCL_var();

    var->refCount++;
    return self;
}


DCLOBJFNC( clear )
{
    size_t n;
    DCL_var();

    if( var->contents ) {
	for(n=0; n < var->size; n++ )
	    FREE( var->contents[n] );
	var->size = 0;
    }
    return self;
}

/****************
 * Add an element at the end
 * (it is better to use addString!)
 */

DCLOBJFNC( add )
{
    DCL_arg(char *, str );
    DCL_var();

    InitAdd( var );
    var->contents[var->size] = xstrdup(str);
    var->size++;
    return self;
}
DCLOBJFNC( addString )
{
    DCL_arg(char *, str );
    DCL_var();

    InitAdd( var );
    var->contents[var->size] = xstrdup(str);
    var->size++;
    return self;
}


/****************
 * Add an element at the end, but convert it corresponding to the
 * Syntax DatabaseEngine
 */

DCLOBJFNC( addAsDBString )
{
    DCL_arg(id, obj );
    DCL_var();

    InitAdd( var );
    var->contents[var->size] = obj == nil ? xstrdup("NULL") :
				  p_msg( obj, sym_allocAsDBString );
    var->size++;
    return self;
}



DCLOBJFNC_I( size )
{
    DCL_var();
    return var->size;
}


/****************
 * Seq. Zugriff: aber einmal gleichzeitig
 * (fuer Anderes ist die Sequence Methode zu benutzen)
 * Returns: self or nil; bei nil braucht close nicht mehr
 * benutzt zu werden, da es ein leeres Array anzeigt.
 */

DCLOBJFNC( enumOpen )
{
    DCL_var();

    if( var->enSize ) {
	msg1(self,sym_error,"nested enumBegin");
	return nil;
    }

    if( !var->capacity || !var->size )
	return nil;
    var->enSize = var->size;
    var->enIdx	 = 0;
    return self;
}


DCLOBJFNC_P( enumGet )
{
    DCL_var();

    if( !var->enSize ) {
	msg1(self,sym_error,"enumGet without enumBegin");
	return NULL;
    }
    for( ; var->enIdx < var->enSize; var->enIdx++ )
	if( var->contents[var->enIdx] )
	    return var->contents[var->enIdx++];
    var->enSize = 0;
    return NULL;
}


DCLOBJFNC( enumClose )
{
    DCL_var();
    var->enSize = 0;
    return nil;
}



/****************
 * Ermittelt die laenge aller String inklusive der terminating 0
 */

DCLOBJFNC_I( cumulativeLength  )
{
    size_t n, len;
    DCL_var();

    len = 0;
    if( var->contents ) {
	for(n=0; n < var->size; n++ )
	    len += strlen( var->contents[n] ) + 1;
    }

    return len;
}


/****************
 * Da Element an dem gegebenen Index zurckgeben. Exitiert
 * an dem index kein Element mehr, so wird nil zurckgeben.
 * Zugriff hinter den Grenzen des Array liefert ebenfalls nil und
 * lst kein #bounds aus.
 */
DCLOBJFNC( get )
{
    DCL_arg(unsigned, idx );
    DCL_var();

    if( var->contents && idx < var->size )
	return newString(var->contents[idx]);
    return nil;
}


void WamSUC_StringArray()
{
    id self = StringArray;
    CREATECLASS("StringArray");
    WamSubclassClass( sym_Object, self );
    WamSetAtticLimit( self, 100 );

    DCLMTHD( free );
    DCLMTHD( copy );
    DCLMTHD( clear );
    DCLMTHD( add );
    DCLMTHD( addString );
    DCLMTHD( addAsDBString );
    DCLMTHD( size );
    DCLMTHD( enumOpen );
    DCLMTHD( enumGet  );
    DCLMTHD( enumClose);
    DCLMTHD( get );
    DCLMTHD( cumulativeLength );

}


/**** end of file ****/
