/* [wam/pmsup2.c wk 11.04.93] GUI: PM Support Module 2
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 * Help Handler
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: pmsup2.c,v 1.6 1996/01/25 20:17:57 wernerk Exp $")
#if !defined(OS20)
    #error This implementation is only for OS/2 v2.0
#endif
#define OS20_PM 1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wk/lib.h>

#define INCL_WINHELP 1
#define INCL_WINWINDOWMGR 1
#define INCL_WININPUT 1
#include <os2.h>

#include <wk/wam.h>
#define WAM_PM_MODULE 2
#include "wammain.h"
#include "wamgui.h"


HMODULE GetModuleHandle(void);
/**************************************************
 *************	Constants  ************************
 **************************************************/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

static HWND hwndHelpInstance;
static int  helpIsEnabled;


static const char *allocedHelpTitle;
static const char *allocedHelpLibName;

static HAB  hab;

/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

/**************************************************
 ***************** Functions  *********************
 **************************************************/


/****************
 * Hilfesystem initialisieren, ist Hilfe nicht verfgbar
 * so wird eine Warnmeldung ausgegeben
 */

void WamPMInitializeHelp( HAB habMain, HWND hwndFrame)
{
    HELPINIT hini;
    char buf[200];

    if( helpIsEnabled )
	return; /* already initialized */

    hab = habMain;
    hini.cb = sizeof(HELPINIT);
    hini.ulReturnCode = 0L;

    hini.pszTutorialName = NULL;    /* no tutorial yet */

    hini.phtHelpTable = (PHELPTABLE)MAKELONG(ID_HELPTABLE, 0xFFFF);
    hini.hmodHelpTableModule = GetModuleHandle();
    hini.hmodAccelActionBarModule = GetModuleHandle();
    hini.idAccelTable = 0;
    hini.idActionBar = 0;

    if(!WinLoadString(habMain, GetModuleHandle(),
			       IDS_HELPTITLE, DIM(buf), buf))
	strcpy(buf,"IDS_<" STRING(IDS_HELPTITLE) ">");
    allocedHelpTitle = xstrdup(buf);
    hini.pszHelpWindowTitle = (PSZ)allocedHelpTitle;

    if(!WinLoadString(habMain, GetModuleHandle(),
			       IDS_HELPLIBNAME, DIM(buf), buf))
	strcpy(buf,"IDS_<" STRING(IDS_HELPLIBNAME) ">");
    allocedHelpLibName = xstrdup(buf);
    hini.pszHelpLibraryName = (PSZ)allocedHelpLibName;
  #ifdef DEBUG
    hini.fShowPanelId = CMIC_SHOW_PANEL_ID;
  #else
    hini.fShowPanelId = CMIC_HIDE_PANEL_ID;
  #endif

    hwndHelpInstance = WinCreateHelpInstance(habMain, &hini);
    if( hwndHelpInstance && !hini.ulReturnCode )
	if( WinAssociateHelpInstance(hwndHelpInstance, hwndFrame) )
	    helpIsEnabled = 1;
    if( !helpIsEnabled ) {
	if(!WinLoadString(habMain,GetModuleHandle(),
				  IDS_HELPLOADERR, DIM(buf), buf))
	    strcpy(buf,"No Help available");
	WinMessageBox(HWND_DESKTOP, hwndFrame,
		      (PSZ)buf, (PSZ)wamApplicationName, 0,
		      MB_MOVEABLE | MB_CUAWARNING | MB_OK  );

    }

    return;
}



void WamPMTerminateHelp()
{
    if( helpIsEnabled ) {
	if(hwndHelpInstance)  {
	    WinDestroyHelpInstance(hwndHelpInstance);
	    hwndHelpInstance = 0;
	}
	helpIsEnabled = 0;
    }
    FREE((char*)allocedHelpTitle);
    FREE((char*)allocedHelpLibName);
}




/****************
 * Display the requested Help
 * mode: IDM_HELP... or 0 to display a panel
 */

void WamPMDisplayHelp(HWND hwnd, int itemId)
{
    if( !helpIsEnabled )
	return;

    if( itemId == IDM_HELPHELPFORHELP ) { /* just display system help */
	if( WinSendMsg(hwndHelpInstance, HM_DISPLAY_HELP, NULL, NULL) )
	    WinAlarm(HWND_DESKTOP, WA_ERROR);
    }
    else if( itemId == IDM_HELPEXTENDED ) {
	if( WinSendMsg(hwndHelpInstance, HM_EXT_HELP, NULL, NULL) )
	    WinAlarm(HWND_DESKTOP, WA_ERROR);
    }
    else if( itemId == IDM_HELPINDEX ) {
	if( WinSendMsg(hwndHelpInstance, HM_HELP_INDEX, NULL, NULL) )
	    WinAlarm(HWND_DESKTOP, WA_ERROR);
    }
    else if( itemId == IDM_HELPTUTORIAL ) {
	    WinAlarm(HWND_DESKTOP, WA_ERROR);
    }
    else if( itemId == IDM_HELPABOUT ) {
	    WinAlarm(HWND_DESKTOP, WA_ERROR);
    }
    else {
	SHORT idDlg;
	HWND  hwndFocus;

	/* get the id of the dialog box */
	idDlg = WinQueryWindowUShort(hwnd, QWS_ID);


	/* find out which window has the focus and get its id */
	hwndFocus = WinQueryFocus(HWND_DESKTOP);
	itemId = WinQueryWindowUShort(hwndFocus, QWS_ID);

	Info("Display help for %d / %d", idDlg, itemId );
	itemId = idDlg;

	if( WinSendMsg(hwndHelpInstance, HM_DISPLAY_HELP,
		    MPFROM2SHORT(itemId, NULL), MPFROMSHORT(HM_RESOURCEID)))
	    WinAlarm(HWND_DESKTOP, WA_ERROR);
    }

}


/**** bottom of file ****/
