/* [wam/pmsup1.c wk 14.2.93] GUI: PM Support Module 1
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: pmsup1.c,v 1.4 1993/09/30 18:18:58 wk Exp $")
#if !defined(OS20)
    #error This implementation is only for OS/2 v2.0
#endif
#define OS20_PM 1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wk/lib.h>

#define INCL_WIN 1
#include <os2.h>

#include <wk/wam.h>
#define WAM_PM_MODULE 1
#include "wammain.h"
#include "wamgui.h"



/**************************************************
 *************	Constants  ************************
 **************************************************/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

/**************************************************
 *************	Local Functions  ******************
 **************************************************/


const char *WamWindowStrMessage( ushort n )
{
    int i;

    static struct { ushort id; const char *p; } tbl[] = {
       { 0x0000, "WM_NULL"                        },
       { 0x0001, "WM_CREATE"                      },
       { 0x0002, "WM_DESTROY"                     },
       { 0x0003, "WM_OTHERWINDOWDESTROYED"        },
       { 0x0004, "WM_ENABLE"                      },
       { 0x0005, "WM_SHOW"                        },
       { 0x0006, "WM_MOVE"                        },
       { 0x0007, "WM_SIZE"                        },
       { 0x0008, "WM_ADJUSTWINDOWPOS"             },
       { 0x0009, "WM_CALCVALIDRECTS"              },
       { 0x000a, "WM_SETWINDOWPARAMS"             },
       { 0x000b, "WM_QUERYWINDOWPARAMS"           },
       { 0x000c, "WM_HITTEST"                     },
       { 0x000d, "WM_ACTIVATE"                    },
       { 0x000f, "WM_SETFOCUS"                    },
       { 0x0010, "WM_SETSELECTION"                },
       { 0x0011, "WM_PPAINT"                      },
       { 0x0012, "WM_PSETFOCUS"                   },
       { 0x0013, "WM_PSYSCOLORCHANGE"             },
       { 0x0014, "WM_PSIZE"                       },
       { 0x0015, "WM_PACTIVATE"                   },
       { 0x0016, "WM_PCONTROL"                    },
       { 0x0020, "WM_COMMAND"                     },
       { 0x0021, "WM_SYSCOMMAND"                  },
       { 0x0022, "WM_HELP"                        },
       { 0x0023, "WM_PAINT"                       },
       { 0x0024, "WM_TIMER"                       },
       { 0x0025, "WM_SEM1"                        },
       { 0x0026, "WM_SEM2"                        },
       { 0x0027, "WM_SEM3"                        },
       { 0x0028, "WM_SEM4"                        },
       { 0x0029, "WM_CLOSE"                       },
       { 0x002a, "WM_QUIT"                        },
       { 0x002b, "WM_SYSCOLORCHANGE"              },
       { 0x002d, "WM_SYSVALUECHANGED"             },
       { 0x002e, "WM_APPTERMINATENOTIFY"          },
       { 0x002f, "WM_PRESPARAMCHANGED"            },
       { 0x0030, "WM_CONTROL"                     },
       { 0x0031, "WM_VSCROLL"                     },
       { 0x0032, "WM_HSCROLL"                     },
       { 0x0033, "WM_INITMENU"                    },
       { 0x0034, "WM_MENUSELECT"                  },
       { 0x0035, "WM_MENUEND"                     },
       { 0x0036, "WM_DRAWITEM"                    },
       { 0x0037, "WM_MEASUREITEM"                 },
       { 0x0038, "WM_CONTROLPOINTER"              },
       { 0x0039, "WM_CONTROLHEAP"                 },
       { 0x003a, "WM_QUERYDLGCODE"                },
       { 0x003b, "WM_INITDLG"                     },
       { 0x003c, "WM_SUBSTITUTESTRING"            },
       { 0x003d, "WM_MATCHMNEMONIC"               },
       { 0x003e, "WM_SAVEAPPLICATION"             },
       { 0x0040, "WM_FLASHWINDOW"                 },
       { 0x0041, "WM_FORMATFRAME"                 },
       { 0x0042, "WM_UPDATEFRAME"                 },
       { 0x0043, "WM_FOCUSCHANGE"                 },
       { 0x0044, "WM_SETBORDERSIZE"               },
       { 0x0045, "WM_TRACKFRAME"                  },
       { 0x0046, "WM_MINMAXFRAME"                 },
       { 0x0047, "WM_SETICON"                     },
       { 0x0048, "WM_QUERYICON"                   },
       { 0x0049, "WM_SETACCELTABLE"               },
       { 0x004a, "WM_QUERYACCELTABLE"             },
       { 0x004b, "WM_TRANSLATEACCEL"              },
       { 0x004c, "WM_QUERYTRACKINFO"              },
       { 0x004d, "WM_QUERYBORDERSIZE"             },
       { 0x004e, "WM_NEXTMENU"                    },
       { 0x004f, "WM_ERASEBACKGROUND"             },
       { 0x0050, "WM_QUERYFRAMEINFO"              },
       { 0x0051, "WM_QUERYFOCUSCHAIN"             },
       { 0x0052, "WM_OWNERPOSCHANGE"              },
       { 0x0053, "WM_CALCFRAMERECT"               },
       { 0x0055, "WM_WINDOWPOSCHANGED"            },
       { 0x0056, "WM_ADJUSTFRAMEPOS"              },
       { 0x0059, "WM_QUERYFRAMECTLCOUNT"          },
       { 0x005B, "WM_QUERYHELPINFO"               },
       { 0x005C, "WM_SETHELPINFO"                 },
       { 0x005D, "WM_ERROR"                       },
       { 0x005E, "WM_REALIZEPALETTE"              },
       { 0x0060, "WM_RENDERFMT"                   },
       { 0x0061, "WM_RENDERALLFMTS"               },
       { 0x0062, "WM_DESTROYCLIPBOARD"            },
       { 0x0063, "WM_PAINTCLIPBOARD"              },
       { 0x0064, "WM_SIZECLIPBOARD"               },
       { 0x0065, "WM_HSCROLLCLIPBOARD"            },
       { 0x0066, "WM_VSCROLLCLIPBOARD"            },
       { 0x0067, "WM_DRAWCLIPBOARD"               },
       { 0x0070, "WM_MOUSEMOVE"                   },
       { 0x0071, "WM_BUTTON1DOWN"                 },
       { 0x0072, "WM_BUTTON1UP"                   },
       { 0x0073, "WM_BUTTON1DBLCLK"               },
       { 0x0074, "WM_BUTTON2DOWN"                 },
       { 0x0075, "WM_BUTTON2UP"                   },
       { 0x0076, "WM_BUTTON2DBLCLK"               },
       { 0x0077, "WM_BUTTON3DOWN"                 },
       { 0x0078, "WM_BUTTON3UP"                   },
       { 0x0079, "WM_BUTTON3DBLCLK"               },
       { 0x007a, "WM_CHAR"                        },
       { 0x007b, "WM_VIOCHAR"                     },
       { 0x007c, "WM_JOURNALNOTIFY"               },
       { 0x00A0, "WM_DDE_FIRST"                   },
       { 0x00A1, "WM_DDE_REQUEST"                 },
       { 0x00A2, "WM_DDE_ACK"                     },
       { 0x00A3, "WM_DDE_DATA"                    },
       { 0x00A4, "WM_DDE_ADVISE"                  },
       { 0x00A5, "WM_DDE_UNADVISE"                },
       { 0x00A6, "WM_DDE_POKE"                    },
       { 0x00A7, "WM_DDE_EXECUTE"                 },
       { 0x00A8, "WM_DDE_TERMINATE"               },
       { 0x00A9, "WM_DDE_INITIATEACK"             },
       { 0x00AF, "WM_DDE_LAST"                    },
       { 0x00b0, "WM_DBCSFIRST"                   },
       { 0x00cf, "WM_DBCSLAST"                    },

       { 0x0160, "LM_QUERYITEMCOUNT"              },
       { 0x0161, "LM_INSERTITEM"                  },
       { 0x0162, "LM_SETTOPINDEX"                 },
       { 0x0163, "LM_DELETEITEM"                  },
       { 0x0164, "LM_SELECTITEM"                  },
       { 0x0165, "LM_QUERYSELECTION"              },
       { 0x0166, "LM_SETITEMTEXT"                 },
       { 0x0167, "LM_QUERYITEMTEXTLENGTH"         },
       { 0x0168, "LM_QUERYITEMTEXT"               },
       { 0x0169, "LM_SETITEMHANDLE"               },
       { 0x016a, "LM_QUERYITEMHANDLE"             },
       { 0x016b, "LM_SEARCHSTRING"                },
       { 0x016c, "LM_SETITEMHEIGHT"               },
       { 0x016d, "LM_QUERYTOPINDEX"               },
       { 0x016e, "LM_DELETEALL"                   },

       { 0x0410, "WM_CHORD"                       },
       { 0x0411, "WM_BUTTON1MOTIONSTART"          },
       { 0x0412, "WM_BUTTON1MOTIONEND"            },
       { 0x0413, "WM_BUTTON1CLICK"                },
       { 0x0414, "WM_BUTTON2MOTIONSTART"          },
       { 0x0415, "WM_BUTTON2MOTIONEND"            },
       { 0x0416, "WM_BUTTON2CLICK"                },
       { 0x0420, "WM_BEGINDRAG"                   },
       { 0x0421, "WM_ENDDRAG"                     },
       { 0x0422, "WM_SINGLESELECT"                },
       { 0x0423, "WM_OPEN"                        },
       { 0x0424, "WM_CONTEXTMENU"                 },
       { 0x0425, "WM_CONTEXTHELP"                 },
       { 0x0426, "WM_TEXTEDIT"                    },
       { 0x0427, "WM_BEGINSELECT"                 },
       { 0x0428, "WM_ENDSELECT"                   },

       { 0, NULL } } ;

    static char buffer[10];

    for(i=0; tbl[i].p ; i++ )
	if( tbl[i].id == n )
	    return tbl[i].p;

    sprintf(buffer, "WM_%#04x", n );
    return buffer;
}

/**** bottom of file ****/
