/* [wam/nil.c wk 06.04.93] Nil Support
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 * Dieses Modul hat eine Funktion und wird nur vom
 * Messager aufgerufen, falls dessen receiver nil ist.
 * Hier wird nicht zwichen Factory und Instance-methods
 * unterschieden.
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: nil.c,v 1.8 1996/01/25 20:17:50 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <wk/string.h>

#include <wk/wam.h>

/**************************************************
 *************	Constants  ************************
 **************************************************/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

typedef struct {
	symbol_t *sel;	      /* adr of selector */
	objfnc_t fnc;	      /* self, arg_ptr */
    } methodTbl_t;
/* table ist am ende des files, so erspare ich mir die prototypes ;-) */

/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

/**************************************************
 *************	Local Functions  ******************
 **************************************************/

static int I_isEmptyOrNil(id dummy, va_list arg_ptr)
{
    return 1; /* of course its nil */
}

static id I_free(id dummy, va_list arg_ptr)
{
    return nil;
}



static id I_doesNotRecognize(id dummy, va_list arg_ptr)   /* args: symbol */
{
    DCL_arg(symbol_t,m);
    char buf[200];

    WamQuerySymbolName( m, buf, DIM(buf)-15 );
    strcat(buf, " not recognized by Nil-Handler");
    msg1(Object,sym_error, buf);
    return nil;
}



static symbol_t I_name(id dummy,  va_list arg_ptr )
{
    return sym_Nil;
}


static id I_class(id dummy,  va_list arg_ptr )
{
    return nil;
}


static int I_isMemberOf(id dummy, va_list arg_ptr) /*for quick access: WamIsMemberOf()*/
{
    DCL_arg(id,aClass);

    return aClass ? 0 : 1;
}

static int I_isKindOf(id dummy, va_list arg_ptr) /*for quick access: WamIsKindOf()*/
{
    DCL_arg(id,aClass);
    return aClass ? 0 : 1;
}



static int I_size(id dummy,  va_list arg_ptr )
{
    return 0;
}


static int I_isEqual(id dummy,	va_list arg_ptr )
{
    DCL_arg(id, other );    /* beliebig */
    return other ? 0 : 1;  /* only nil is equal to nil */
}



static id I_show(id dummy,  va_list arg_ptr )
{
    Info("Instance of PseudoClass Nil");
    return nil;
}


static id I_copy(id dummy,  va_list arg_ptr )
{
    return nil;
}

static id I_isTrue(id dummy,  va_list arg_ptr )
{
    return False;
}

static id I_asString(id dummy,	va_list arg_ptr )
{
    return newString("");
}


/****************
 * Special Method, gibt ein Object als String fuer die datenbank
 * zurueck, dabei wird ein Pointer zurueckgegeben, dessen Speicher
 * bereich der aufrufer dann verwalten (e.g. freigeben) muss.
 */
static char *I_allocAsDBString(id dummy,  va_list arg_ptr )
{
    return xstrdup("NULL");
}

/**************************************************
 *************	Method Table **********************
 **************************************************/

static methodTbl_t methodTbl[] = {
    {  &sym_isEmptyOrNil    , I_isEmptyOrNil },
    {  &sym_free	    , I_free	     },
    {  &sym_deepFree	    , I_free	     },
    {  &sym_doesNotRecognize, I_doesNotRecognize  },
    {  &sym_name	    , I_name		},
    {  &sym_class	    , I_class		},
    {  &sym_isMemberOf	    , I_isMemberOf	},
    {  &sym_isKindOf	    , I_isKindOf	},
    {  &sym_size	    , I_size		},
    {  &sym_isEqual	    , I_isEqual 	},
    {  &sym_show	    , I_show		},
    {  &sym_copy	    , I_copy		},
    {  &sym_allocAsDBString , I_allocAsDBString },
    {  &sym_isTrue	    , I_isTrue		},
    {  &sym_asString	    , I_asString	},
    {  NULL, NULL }
};

/**************************************************
 *************	Global Functions  *****************
 **************************************************/


/****************
 * Kludge: if arg_ptr is NULL we obly use this to check wether nil responds to
 * the selector.
 */

id WamSendMsgToNil( symbol_t selector, va_list arg_ptr,
		    int traceFlag, int recursionLevel )
{
    int i;
    char symbuf[ 40 ]; /* should be 128 */
    symbol_t *sp;

    if( traceFlag )
	printf( "MsgTrc:%*s %s -> Nil-Handler : ",
	     ((recursionLevel-1)&0x1f) * 2, "",
	     WamQuerySymbolName( selector, symbuf, DIM(symbuf) ) );
    for(i=0; sp = methodTbl[i].sel; i++ )
	if( *sp == selector ) {
	    if( !arg_ptr )
		return (id)methodTbl[i].fnc;
	    if( traceFlag )
		printf( "will be performed\n" );
	    return methodTbl[i].fnc(nil, arg_ptr );
	}

    if( !arg_ptr )
	return nil;
    if( traceFlag )
	puts("method not recognized by Nil-Handler");
    if( selector == sym_doesNotRecognize )
	Bug( "method 'doesNotRecognize' not recognized by Nil-Handler");
    return WamSendMsg( nil, sym_doesNotRecognize, selector );
}

/**** end of file ****/
