/* [wam/integer.c wk 25.02.93] Class Integer
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 *
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: integer.c,v 1.7 1993/11/20 19:34:00 wk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>

/**************************************************
 *************	Constants  ************************
 **************************************************/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(Integer)

BEGIN_DCLPRIVATEPART
    long val;
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

/**************************************************
 *************	Local Functions  ******************
 **************************************************/

/**************************************************
 ******************  Methods  *********************
 **************************************************/

DCLFOBJFNC( create )
{
    DCL_arg(long, val);
    id obj;
    id	var;

    obj = msgSuper( sym_new );
    SET_var(obj);
    var->val = val;
    return obj;
}


DCLOBJFNC( copy )
{
    id obj;
    long val;
    DCL_var();

    obj = msg(factory, sym_new );
    val = var->val;
    SET_var(obj);
    var->val = val;
    return obj;
}

DCLOBJFNC(asNumber)
{
    id obj;
    long val;
    DCL_var();

    obj = msg(factory, sym_new );
    val = var->val;
    SET_var(obj);
    var->val = val;
    return obj;
}




DCLOBJFNC( negated )
{
    id obj;
    long val;
    DCL_var();

    obj = msg(factory, sym_new );
    val = var->val;
    SET_var(obj);
    var->val = -val;
    return obj;
}



DCLOBJFNC_i( getValue )  /* gibt den Wert zurueck */
{
    DCL_var();
    return var->val;
}

DCLOBJFNC( putValue )
{
    DCL_arg(long, val);
    DCL_var();

    var->val = val;
    return self;
}



DCLOBJFNC_p( allocAsDBString )
{
    char buf[50];
    DCL_var();
    sprintf( buf, "%ld", var->val );
    return xstrdup(buf);
}


DCLOBJFNC_i( isEqual )
{
    DCL_arg(id, other );    /* sollte Integer oder float sein */
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->val == var2->val;
    }
    else if( WamIsKindOf( other, factory ) )
	return var->val == getInteger(other);
    else if( WamIsKindOf( other, Float ) )
	return var->val == getFloat(other);
    else
	return 0;   /* from other class - cannot be equal */
}


DCLOBJFNC_i( isGT )
{
    DCL_arg(id, other );    /* sollte Integer oder float sein */
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->val > var2->val;
    }
    else if( WamIsKindOf( other, factory ) )
	return var->val > getInteger(other);
    else if( WamIsKindOf( other, Float ) )
	return var->val > getFloat(other);
    else
	return 0;   /* from other class - cannot be equal */
}

DCLOBJFNC_i( isGE )
{
    DCL_arg(id, other );    /* sollte Integer oder float sein */
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->val >= var2->val;
    }
    else if( WamIsKindOf( other, factory ) )
	return var->val >= getInteger(other);
    else if( WamIsKindOf( other, Float ) )
	return var->val >= getFloat(other);
    else
	return 0;   /* from other class - cannot be equal */
}


DCLOBJFNC_i( isLT )
{
    DCL_arg(id, other );    /* sollte Integer oder float sein */
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->val < var2->val;
    }
    else if( WamIsKindOf( other, factory ) )
	return var->val < getInteger(other);
    else if( WamIsKindOf( other, Float ) )
	return var->val < getFloat(other);
    else
	return 0;   /* from other class - cannot be equal */
}

DCLOBJFNC_i( isLE )
{
    DCL_arg(id, other );    /* sollte Integer oder float sein */
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->val <= var2->val;
    }
    else if( WamIsKindOf( other, factory ) )
	return var->val <= getInteger(other);
    else if( WamIsKindOf( other, Float ) )
	return var->val <= getFloat(other);
    else
	return 0;   /* from other class - cannot be equal */
}


DCLOBJFNC_i( isEmptyOrNil )
{
    DCL_var();
    return var->val == 0;
}


/****************
 *  Den Wert um eins erhoehen
 */

DCLOBJFNC(inc)
{
    DCL_var();
    var->val++;
    return self;
}

/****************
 *  Den Wert um eins erniedrigen
 */

DCLOBJFNC(dec)
{
    DCL_var();
    var->val--;
    return self;
}


DCLOBJFNC(isTrue)
{
    DCL_var();
    return var->val ? True : False;
}

DCLOBJFNC(asString)
{
    char buf[20];
    DCL_var();

    sprintf(buf,"%ld", var->val);
    return newString(buf);
}



void WamSUC_Integer()
{
    id self = Integer;
    CREATECLASS("Integer");
    WamSubclassClass( sym_Object, self );
    WamSetAtticLimit( self, 500 );

    DCLFMTHD( create );

    DCLMTHD( copy );
    DCLMTHD( asNumber);
    DCLMTHD( negated );
    DCLMTHD( getValue );
    DCLMTHD( putValue );
    DCLMTHD( allocAsDBString );
    DCLMTHD( isEqual );
    DCLMTHD( isGT );
    DCLMTHD( isGE );
    DCLMTHD( isLT );
    DCLMTHD( isLE );
    DCLMTHD( isEmptyOrNil );
    DCLMTHD( inc );
    DCLMTHD( dec );
    DCLMTHD( isTrue );
    DCLMTHD( asString );
}


/**** end of file ****/
